;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;; Le module                                                                 
(module
  __caml_printf
  (foreign (include #"caml-bigloo.h"))
  (import)
  (export
    (barf_if_more_args_32@printf x1)
    (fprintf_48@printf x1)
    (2-151-fprintf_48@printf x1 x2)
    (printf_219@printf x1)
    print_144@printf
    fprint_78@printf))
;; L'initialisation du module                                                
(init_camloo!)
;; Les variables globales                                                    
;; Les expressions globales                                                  
(define barf_if_more_args_32@printf
  (lambda (x1)
    (invalid_arg_209@exc
      #"fprintf: too many arguments")))

(begin
  (define fprintf_48@printf
    (lambda (x1)
      (lambda (x2) (2-151-fprintf_48@printf x1 x2))))
 (define 2-151-fprintf_48@printf
    (lambda (x1 x2)
      (letrec ((x3 (lambda (x7)
                     (if (>=fx x7 (string-length x2))
                       barf_if_more_args_32@printf
                       (let ((x8 (string-ref x2 x7)))
                         (labels
                           ((:-d.staticfail1001
                              ()
                              (begin (c-output_char x1 x8) (x3 (+fx x7 1)))))
                           (let ((:-d.1002 x8))
                             (cond ((char=? :-d.1002 #\%)
                                    (let ((x9 (x4 (+fx x7 1))))
                                      (let ((x10 (string-ref x2 x9)))
                                        (labels
                                          ((:-d.staticfail1003
                                             ()
                                             (invalid_arg_209@exc
                                               ((^_54@fstring
                                                  #"fprintf: unknown format ")
                                                (char_for_read_215@fchar
                                                  x10)))))
                                          (case x10
                                            ((#\%)
                                             (begin
                                               (c-output_char x1 #\%)
                                               (x3 (+fx x9 1))))
                                            ((#\s)
                                             (lambda (x11)
                                               (begin
                                                 (if (or (not (c-obj_is_block
                                                                x11))
                                                         ((lambda (x y)
                                                            (not (eq? x y)))
                                                          (tag-of x11)
                                                          253))
                                                   (invalid_arg_209@exc
                                                     #"fprintf: string argument expected")
                                                   (if (<=fx x9 (+fx x7 1))
                                                     ((output_string_156@io x1)
                                                      x11)
                                                     (let ((x12 (let* ((:-d.handler-top1005
                                                                         current_handler)
                                                                       (:-d.1006
                                                                         (unspecified)))
                                                                  (labels
                                                                    ((:-d.try1007
                                                                       (:-d.1006)
                                                                       (begin
                                                                         (get-the-continuation
                                                                           :-d.1006)
                                                                         (if (eq? #t
                                                                                  #f)
                                                                           (:-d.try1007
                                                                             (:-d.try1007
                                                                               (:-d.try1007
                                                                                 1))))
                                                                         (if :-d.1006
                                                                           (c-int_of_string
                                                                             (((sub_string_61@fstring
                                                                                 x2)
                                                                               (+fx x7
                                                                                    1))
                                                                              (-fx (-fx x9
                                                                                        x7)
                                                                                   1)))
                                                                           current_handler))))
                                                                    (let ((x12 (:-d.try1007
                                                                                 :-d.1006)))
                                                                      (set! current_handler
                                                                        :-d.handler-top1005)
                                                                      (if (=fx *try*
                                                                               1)
                                                                        (begin
                                                                          (set! *try*
                                                                            0)
                                                                          (invalid_arg_209@exc
                                                                            #"fprintf: bad %s format"))
                                                                        x12))))))
                                                       (if (and (>fx x12 0)
                                                                (<fx (string-length
                                                                       x11)
                                                                     x12))
                                                         (begin
                                                           ((output_string_156@io
                                                              x1)
                                                            ((make_string_7@fstring
                                                               (-fx x12
                                                                    (string-length
                                                                      x11)))
                                                             #\space))
                                                           ((output_string_156@io
                                                              x1)
                                                            x11))
                                                         (if (and (<fx x12 0)
                                                                  (<fx (string-length
                                                                         x11)
                                                                       (negfx x12)))
                                                           (begin
                                                             ((output_string_156@io
                                                                x1)
                                                              x11)
                                                             ((output_string_156@io
                                                                x1)
                                                              ((make_string_7@fstring
                                                                 (-fx (negfx x12)
                                                                      (string-length
                                                                        x11)))
                                                               #\space)))
                                                           ((output_string_156@io
                                                              x1)
                                                            x11))))))
                                                 (x3 (+fx x9 1)))))
                                            ((#\c)
                                             (lambda (x11)
                                               (if (c-obj_is_block x11)
                                                 (invalid_arg_209@exc
                                                   #"fprintf: char argument expected")
                                                 (begin
                                                   (c-output_char x1 x11)
                                                   (x3 (+fx x9 1))))))
                                            ((#\u #\X #\x #\o #\i #\d)
                                             ((x5 x7) x9))
                                            ((#\G #\g #\E #\e #\f) ((x6 x7) x9))
                                            ((#\b)
                                             (lambda (x11)
                                               (begin
                                                 (if (c-obj_is_block x11)
                                                   ((output_string_156@io x1)
                                                    (if x11 #"true" #"false"))
                                                   (invalid_arg_209@exc
                                                     #"fprintf: boolean argument expected"))
                                                 (x3 (+fx x9 1)))))
                                            (else (:-d.staticfail1003)))))))
                                   (else (:-d.staticfail1001)))))))))
               (x4 (lambda (x7)
                     (let ((x8 (string-ref x2 x7)))
                       (labels
                         ((:-d.staticfail1008 () x7))
                         (case x8
                           ((#\-
                             #\.
                             #\space
                             #\9
                             #\8
                             #\7
                             #\6
                             #\5
                             #\4
                             #\3
                             #\2
                             #\1
                             #\0)
                            (x4 (+fx x7 1)))
                           (else (:-d.staticfail1008)))))))
               (x5 (lambda (x7)
                     (lambda (x8)
                       (lambda (x9)
                         (if (c-obj_is_block x9)
                           (invalid_arg_209@exc
                             #"fprintf: int argument expected")
                           (let ((x10 (-fx x8 x7)))
                             (let ((x11 (c-create_string (+fx x10 2))))
                               (begin
                                 (c-blit_string x2 x7 x11 0 x10)
                                 (begin
                                   (string-set! x11 x10 #\l)
                                   (begin
                                     (string-set!
                                       x11
                                       (+fx x10 1)
                                       (string-ref x2 x8))
                                     (begin
                                       ((output_string_156@io x1)
                                        (c-format_int x11 x9))
                                       (x3 (+fx x8 1)))))))))))))
               (x6 (lambda (x7)
                     (lambda (x8)
                       (lambda (x9)
                         (if (or (not (c-obj_is_block x9))
                                 ((lambda (x y) (not (eq? x y)))
                                  (tag-of x9)
                                  254))
                           (invalid_arg_209@exc
                             #"fprintf: float argument expected")
                           (begin
                             ((output_string_156@io x1)
                              (c-format_float
                                (((sub_string_61@fstring x2) x7)
                                 (+fx (-fx x8 x7) 1))
                                x9))
                             (x3 (+fx x8 1)))))))))
        (x3 0))))
)
(define printf_219@printf
  (lambda (x1)
    ((fprintf_48@printf std_out_112@io) x1)))

(begin
  (define fprint_78@printf output_string_156@io)
  (define print_144@printf print_string_98@io))
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
