;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;; Le module                                                                 
(module
  __caml_filename
  (foreign (include #"caml-bigloo.h"))
  (import)
  (export
    (check_suffix_88@filename x1)
    (2-53-check_suffix_88@filename x1 x2)
    (chop_suffix_96@filename x1)
    (2-39-chop_suffix_96@filename x1 x2)
    current_dir_name_124@filename
    (concat_228@filename x1)
    (2-115-concat_228@filename x1 x2)
    (is_absolute_255@filename x1)
    (slash_pos_240@filename x1)
    (basename_226@filename x1)
    (dirname_229@filename x1)))
;; L'initialisation du module                                                
(init_camloo!)
;; Les variables globales                                                    
;; Les expressions globales                                                  
(begin
  (define check_suffix_88@filename
    (lambda (x1)
      (lambda (x2)
        (2-53-check_suffix_88@filename x1 x2))))
 (define 2-53-check_suffix_88@filename
    (lambda (x1 x2)
      (and (>=fx (string-length x1) (string-length x2))
           (c-tree_equal
             (((sub_string_61@fstring x1)
               (-fx (string-length x1) (string-length x2)))
              (string-length x2))
             x2))))
)
(begin
  (define chop_suffix_96@filename
    (lambda (x1)
      (lambda (x2)
        (2-39-chop_suffix_96@filename x1 x2))))
 (define 2-39-chop_suffix_96@filename
    (lambda (x1 x2)
      (((sub_string_61@fstring x1) 0)
       (-fx (string-length x1) (string-length x2)))))
)
(define current_dir_name_124@filename #".")
(begin
  (define concat_228@filename
    (lambda (x1)
      (lambda (x2) (2-115-concat_228@filename x1 x2))))
 (define 2-115-concat_228@filename
    (lambda (x1 x2)
      (let ((x3 (-fx (string-length x1) 1)))
        (if (or (<fx x3 0) (eq? (string-ref x1 x3) #\/))
          ((^_54@fstring x1) x2)
          ((^_54@fstring x1) ((^_54@fstring #"/") x2))))))
)
(define is_absolute_255@filename
  (lambda (x1)
    (or (and (>=fx (string-length x1) 1)
             (c-tree_equal
               (((sub_string_61@fstring x1) 0) 1)
               #"/"))
        (or (and (>=fx (string-length x1) 2)
                 (c-tree_equal
                   (((sub_string_61@fstring x1) 0) 2)
                   #"./"))
            (and (>=fx (string-length x1) 3)
                 (c-tree_equal
                   (((sub_string_61@fstring x1) 0) 3)
                   #"../"))))))

(define slash_pos_240@filename
  (lambda (x1)
    (letrec ((x2 (lambda (x3)
                   (if (<fx x3 0)
                     (raise 'not_found@exc)
                     (if (eq? (string-ref x1 x3) #\/)
                       x3
                       (x2 (-fx x3 1)))))))
      (x2 (-fx (string-length x1) 1)))))

(define basename_226@filename
  (lambda (x1)
    (let* ((:-d.handler-top1002 current_handler)
           (:-d.1003 (unspecified)))
      (labels
        ((:-d.try1004
           (:-d.1003)
           (begin
             (get-the-continuation :-d.1003)
             (if (eq? #t #f)
               (:-d.try1004 (:-d.try1004 (:-d.try1004 1))))
             (if :-d.1003
               (let ((x2 (+fx (slash_pos_240@filename x1) 1)))
                 (((sub_string_61@fstring x1) x2)
                  (-fx (string-length x1) x2)))
               current_handler))))
        (let ((x2 (:-d.try1004 :-d.1003)))
          (set! current_handler :-d.handler-top1002)
          (if (=fx *try* 1)
            (begin
              (set! *try* 0)
              (labels
                ((:-d.staticfail1005 () (raise x2)))
                (case (caml-extensible-constr-tag x2)
                  ((not_found@exc) x1)
                  (else (:-d.staticfail1005)))))
            x2))))))

(define dirname_229@filename
  (lambda (x1)
    (if (c-tree_equal x1 #"/")
      x1
      (let* ((:-d.handler-top1007 current_handler)
             (:-d.1008 (unspecified)))
        (labels
          ((:-d.try1009
             (:-d.1008)
             (begin
               (get-the-continuation :-d.1008)
               (if (eq? #t #f)
                 (:-d.try1009 (:-d.try1009 (:-d.try1009 1))))
               (if :-d.1008
                 (((sub_string_61@fstring x1) 0)
                  (slash_pos_240@filename x1))
                 current_handler))))
          (let ((x2 (:-d.try1009 :-d.1008)))
            (set! current_handler :-d.handler-top1007)
            (if (=fx *try* 1)
              (begin
                (set! *try* 0)
                (labels
                  ((:-d.staticfail1010 () (raise x2)))
                  (case (caml-extensible-constr-tag x2)
                    ((not_found@exc) #".")
                    (else (:-d.staticfail1010)))))
              x2)))))))

(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
