;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/comptime0.0/Camloo/lconst.scm ...              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec  2 13:17:17 1993                          */
;*    Last change :  Fri Feb 25 10:59:51 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La compilation des formes `Lconst'                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module lconst
   (foreign (include "caml-bigloo.h")
	    (define bint runtime-caml-make-tag (int int)
	       "STATIC_CAML_MAKE_TAG"))
   (export  (ConstrExtensible? constr)
            (lconst             exp)
	    (constr-tag         exp)
	    (constr-tag-value   exp)
	    (get-constr-prop    exp cp)
	    (set-constr-prop!   exp prop)
	    (unset-constr-prop! exp prop)))

;*---------------------------------------------------------------------*/
;*    ConstrExtensible? ...                                            */
;*---------------------------------------------------------------------*/
(define (ConstrExtensible? constr)
   (eq? (car constr) 'ConstrExtensible))

;*---------------------------------------------------------------------*/
;*    Lconst-string ...                                                */
;*---------------------------------------------------------------------*/
(define (Lconst-string s)
   (let ((max-len 1000)
	 (str-len (string-length s)))
      (if (<=fx str-len max-len)
	  (string-for-read s)
	  (let loop ((r   0)
		     (res '()))
	     (if (<=fx (-fx str-len r) max-len)
		 `(string-append
		   ,@(reverse (cons (string-for-read (substring s r str-len))
				    res)))
		 (loop (+fx r max-len)
		       (cons (string-for-read (substring s r (+fx r max-len)))
			     res)))))))
 
;*---------------------------------------------------------------------*/
;*    Lconst ...                                                       */
;*    -------------------------------------------------------------    */
;*    Ce n'est pas tres beau mais avant d'allouer un constructeur      */
;*    on regarde s'il ne s'agit pas d'un `cons' (ou de '()). Si        */
;*    c'est le cas on fait une allocation particuliere (voir           */
;*    fichiers `lprim.scm' et `lswitch.scm'.                           */
;*---------------------------------------------------------------------*/
(define (Lconst exp)
   (match-case exp
      ((SCatom ?e)
       (if (string? e)
	   (Lconst-string e)
	   e))
      ((SCblock (and ?tag (ConstrRegular (qualifiedident ?module ?name)
					 ?tag-num ?nb-constr)) ?e)
       (let ((m? (and (string=? module "builtin"))))
	  (cond
	     ((and m? (string=? name "[]"))
	      ''())
	     ((and m? (string=? name "false"))
	      #f)
	     ((and m? (string=? name "true"))
	      #t)
	     ((and m? (string=? name "::"))
	      `(cons ,@(map Lconst e)))
	     (else
	      (if (null? e)
		  (constr-tag tag)
		  `(caml-make-regular ,(constr-tag tag)
				      ,(length e)
				      ,@(map Lconst e)))))))
      ((SCblock (and ?tag (ConstrExtensible ?- ?-)) ?e)
       (if (null? e)
	   (constr-tag tag)
	   `(caml-make-extensible ,(constr-tag tag)
				  ,(length e)
				  ,@(map Lconst e))))))

;*---------------------------------------------------------------------*/
;*    constr-tag ...                                                   */
;*---------------------------------------------------------------------*/
(define (constr-tag exp)
   (match-case exp
      ((ConstrRegular ?- ?tag-num ?nb-constr)
       `(caml-make-tag ,tag-num ,nb-constr))
      ((ConstrExtensible (?- ?module ?exception) ?int)
       (let ((exce (if (symbol? exception)
		       exception
		       (string->symbol exception))))
	  `',(symbol-append exce '@ (string->symbol module))))))

;*---------------------------------------------------------------------*/
;*    constr-tag-value ...                                             */
;*---------------------------------------------------------------------*/
(define (constr-tag-value exp)
   (match-case exp 
      ((ConstrConstant ?- ?tag-num ?nb-constr)
       `(caml-make-tag ,tag-num ,nb-constr))
      ((ConstrRegular ?- ?tag-num ?nb-constr)
       (runtime-caml-make-tag tag-num nb-constr))
      ((ConstrExtensible (?- ?module ?exception) ?int)
       (let ((exce (if (symbol? exception)
		       exception
		       (string->symbol exception))))
	  (symbol-append exce '@ (string->symbol module))))))

;*---------------------------------------------------------------------*/
;*    get-constr-prop ...                                              */
;*---------------------------------------------------------------------*/
(define (get-constr-prop exp cp)
   (if (symbol? exp)
       (let ((plist (symbol-plist exp)))
	  (if (pair? plist)
	      (car plist)
	      #f))
       (let ((cell (assoc exp cp)))
	  (if (pair? cell)
	      (cdr cell)
	      #f))))

;*---------------------------------------------------------------------*/
;*    set-constr-prop! ...                                             */
;*---------------------------------------------------------------------*/
(define (set-constr-prop! exp prop)
   (if (symbol? exp)
       (begin
	  (putprop! exp prop #t)
	  '())
       (list (cons exp prop))))

;*---------------------------------------------------------------------*/
;*    unset-constr-prop! ...                                           */
;*---------------------------------------------------------------------*/
(define (unset-constr-prop! exp prop)
   (if (symbol? exp)
       (remprop! exp prop)))
   
