;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;; Le module                                                                 
(module
  __caml_misc
  (foreign (include #"caml-bigloo.h"))
  (import
    (__caml_config #"config.scm")
    (__camli_config #"config.sci"))
  (export
    (fatal_error_193@misc x1)
    toplevel_224@misc
    (print_begline_186@misc x1)
    (prerr_begline_213@misc x1)
    (prerr_endline2_160@misc x1)
    load_path_99@misc
    (file_exists_172@misc x1)
    (cannot_find_218@misc x1)
    (find_in_path_8@misc x1)
    rollback_buffer_5@misc
    (reset_rollback_7@misc x1)
    (add_rollback_29@misc x1)
    (rollback_156@misc x1)
    (remove_file_255@misc x1)))
;; L'initialisation du module                                                
(init_camloo!)
;; Les variables globales                                                    
;; Les expressions globales                                                  
(define fatal_error_193@misc
  (lambda (x1)
    (raise (caml-make-extensible 'zinc@misc 1 x1))))

(define toplevel_224@misc
  (caml-make-regular (caml-make-tag 0 1) 1 #f))

(define print_begline_186@misc
  (lambda (x1)
    (begin
      (if (caml-constr-get-field toplevel_224@misc 0)
        (print_string_98@io
          toplevel_output_prompt_179@config)
        (print_string_98@io
          batch_output_prompt_200@config))
      (print_string_98@io x1))))

(define prerr_begline_213@misc
  (lambda (x1)
    (begin
      (if (caml-constr-get-field toplevel_224@misc 0)
        (prerr_string_235@io
          toplevel_error_prompt_60@config)
        (prerr_string_235@io
          batch_error_prompt_64@config))
      (prerr_string_235@io x1))))

(define prerr_endline2_160@misc
  (lambda (x1)
    (begin
      (prerr_endline_232@io x1)
      (prerr_endline_232@io #""))))

(define load_path_99@misc
  (caml-make-regular (caml-make-tag 0 1) 1 '()))

(define file_exists_172@misc
  (lambda (x1)
    (let* ((:-d.handler-top1002 current_handler)
           (:-d.1003 (unspecified)))
      (labels
        ((:-d.try1004
           (:-d.1003)
           (begin
             (get-the-continuation :-d.1003)
             (if (eq? #t #f)
               (:-d.try1004 (:-d.try1004 (:-d.try1004 1))))
             (if :-d.1003
               (begin
                 (c-sys_close
                   (c-sys_open x1 (cons (caml-make-tag 0 9) '()) 0))
                 #t)
               current_handler))))
        (let ((x2 (:-d.try1004 :-d.1003)))
          (set! current_handler :-d.handler-top1002)
          (if (=fx *try* 1)
            (begin
              (set! *try* 0)
              (labels
                ((:-d.staticfail1005 () (raise x2)))
                (case (caml-extensible-constr-tag x2)
                  ((sys_error@sys) #f)
                  (else (:-d.staticfail1005)))))
            x2))))))

(define cannot_find_218@misc
  (lambda (x1)
    (begin
      (prerr_begline_213@misc #" Cannot find file ")
      (begin
        (prerr_endline_232@io x1)
        (raise 'toplevel@misc)))))

(define find_in_path_8@misc
  (lambda (x1)
    (if (file_exists_172@misc x1)
      x1
      (if (is_absolute_255@filename x1)
        (cannot_find_218@misc x1)
        (letrec ((x2 (lambda (x3)
                       (if (null? x3)
                         (cannot_find_218@misc x1)
                         (let ((x4 ((concat_228@filename (car x3)) x1)))
                           (if (file_exists_172@misc x4) x4 (x2 (cdr x3))))))))
          (x2 (caml-constr-get-field load_path_99@misc 0)))))))

(define rollback_buffer_5@misc
  (caml-make-regular (caml-make-tag 0 1) 1 '()))

(define reset_rollback_7@misc
  (lambda (x1)
    (caml-constr-set-field!
      rollback_buffer_5@misc
      0
      '())))

(define add_rollback_29@misc
  (lambda (x1)
    (caml-constr-set-field!
      rollback_buffer_5@misc
      0
      (cons x1
            (caml-constr-get-field rollback_buffer_5@misc 0)))))

(define rollback_156@misc
  (lambda (x1)
    (let ((x2 (caml-constr-get-field rollback_buffer_5@misc 0)))
      (if (null? x2)
        (caml-make-tag 0 1)
        (begin
          ((car x2) (caml-make-tag 0 1))
          (begin
            (caml-constr-set-field!
              rollback_buffer_5@misc
              0
              (cdr x2))
            (rollback_156@misc (caml-make-tag 0 1))))))))

(define remove_file_255@misc
  (lambda (x1)
    (let* ((:-d.handler-top1007 current_handler)
           (:-d.1008 (unspecified)))
      (labels
        ((:-d.try1009
           (:-d.1008)
           (begin
             (get-the-continuation :-d.1008)
             (if (eq? #t #f)
               (:-d.try1009 (:-d.try1009 (:-d.try1009 1))))
             (if :-d.1008 (c-sys_remove x1) current_handler))))
        (let ((x2 (:-d.try1009 :-d.1008)))
          (set! current_handler :-d.handler-top1007)
          (if (=fx *try* 1)
            (begin
              (set! *try* 0)
              (labels
                ((:-d.staticfail1010 () (raise x2)))
                (case (caml-extensible-constr-tag x2)
                  ((sys_error@sys) (caml-make-tag 0 1))
                  (else (:-d.staticfail1010)))))
            x2))))))

(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
