;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.7/Llib/struct.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 30 13:02:29 1992                          */
;*    Last change :  Fri Dec 30 11:57:48 1994 (serrano)                */
;*                                                                     */
;*    Les structures (non r4)                                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __structure
   (foreign (define obj     c-struct-ref  (bstruct bint)     "STRUCT_SLOT_REF")
	    (define obj     c-struct-set! (bstruct bint obj) "STRUCT_SLOT_SET")
	    (define bsymbol c-struct-key  (bstruct)          "STRUCT_KEY")
	    (define bool    c-struct?     (obj)              "STRUCTP")
	    (define obj     c-struct-length (bstruct)          "STRUCT_LENGTH")
	    (bstruct        c-make-struct   (bsymbol bint obj) "make_struct")
	    (bstruct        c-create-struct (bsymbol bint)     "create_struct")
	    (define obj     c-peek        (obj bint)           "PEEK")
	    (define obj     c-poke!       (obj bint obj)       "POKE"))
   (export  (inline make-struct    key len init)
	    (inline struct?        o)
	    (inline struct-key     struct)
	    (inline struct-length  struct)
	    (inline struct-ref     struct k)
	    (inline struct-set!    struct k o)
	    (struct-update!        <struct> <struct>)
	    (inline peek           struct offset)
	    (inline poke!          struct offset value))
   (pragma  (c-struct? _no_side_effect_ _imutable_
		       _no_mutation_ _imbricable_)
	    (c-struct-ref _no_side_effect_ _no_mutation_ _imbricable_)
	    (c-struct-key _no_side_effect_ _imutable_
			  _no_mutation_ _imbricable_)))

;*---------------------------------------------------------------------*/
;*    make-struct ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (make-struct key len init)
   (c-make-struct key len init))

;*---------------------------------------------------------------------*/
;*    peek ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (peek struct offset)
   (c-peek struct offset))

;*---------------------------------------------------------------------*/
;*    poke! ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (poke! struct offset value)
   (c-poke! struct offset value))

;*---------------------------------------------------------------------*/
;*    struct? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline  (struct? o)
   (c-struct? o))

;*---------------------------------------------------------------------*/
;*    struct-key ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline  (struct-key s)
   (c-struct-key s))

;*---------------------------------------------------------------------*/
;*    struct-length ...                                                */
;*---------------------------------------------------------------------*/
(define-inline  (struct-length s)
   (c-struct-length s))
   
;*---------------------------------------------------------------------*/
;*    struct-ref ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline  (struct-ref s k)
   (c-struct-ref s k))

;*---------------------------------------------------------------------*/
;*    struct-set! ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline  (struct-set! s k o)
   (c-struct-set! s k o))

;*---------------------------------------------------------------------*/
;*    struct-update! ...                                               */
;*---------------------------------------------------------------------*/
(define (struct-update! dst src)
   (if (and (eq? (struct-key dst) (struct-key src))
	    (=fx (struct-length dst) (struct-length src)))
       (let loop ((i (-fx (struct-length dst) 1)))
	  (if (=fx i -1)
	      dst
	      (begin
		 (struct-set! dst i (struct-ref src i))
		 (loop (-fx i 1)))))
       (error "struct-update!" "Incompatible structures" (list dst src))))

 
