;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.7/Ieee/equiv.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun 24 14:58:25 1992                          */
;*    Last change :  Mon Jun 13 10:14:59 1994 (serrano)                */
;*                                                                     */
;*    6.2. Equivalence predicates (page 13, r4)                        */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_equivalence_6_2
   (foreign (define bool c-eq? (obj obj) "EQP"))
   (export  (inline eqv? obj1 obj2)
	    (inline eq?  obj1 obj2)
	    (equal?      obj1 obj2))
   (pragma  (c-eq? _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (equal? _no_side_effect_ _imutable_ _no_mutation_)))

;*---------------------------------------------------------------------*/
;*    eq? ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (eq? obj1 obj2)
   (c-eq? obj1 obj2))

;*---------------------------------------------------------------------*/
;*    eqv? ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (eqv? obj1 obj2)
   (c-eq? obj1 obj2))

;*---------------------------------------------------------------------*/
;*    equal? ...                                                       */
;*---------------------------------------------------------------------*/
(define (equal? obj1 obj2)
   (cond
      ((c-eq? obj1 obj2)
       #t)
      ((integer? obj1)
       #f)
      ((symbol? obj1)
       #f)
      ((pair? obj1)
       (and (pair? obj2) (equal? (car obj1) (car obj2))
	    (equal? (cdr obj1) (cdr obj2))))
      ((vector? obj1)
       (let ((lobj1 (vector-length obj1)))
	  (and (vector? obj2)
	       (=fx (vector-length obj2) lobj1)
	       (=fx (vector-tag obj1) (vector-tag obj2))
	       (let test ((i (-fx lobj1 1)))
		  (or (=fx i -1)
		      (and (equal? (vector-ref-ur obj1 i)
				   (vector-ref-ur obj2 i))
			   (test (-fx i 1))))))))
      ((string? obj1)
       (and (string? obj2) (string=? obj1 obj2)))
      ((c-real? obj1)
       (and (c-real? obj2)
	    (=fl obj1 obj2)))
      ((c-struct? obj1)
       (let ((lobj1 (struct-length obj1)))
	  (and (struct? obj2)
	       (=fx (struct-length obj2) lobj1)
	       (let test ((i (-fx lobj1 1)))
		  (or (=fx i -1)
		      (and (equal? (struct-ref obj1 i) (struct-ref obj2 i))
			   (test (-fx i 1))))))))
      ((c-foreign? obj1)
       (and (c-foreign? obj2)
	    (c-foreign-eq? obj1 obj2)))
      ((cell? obj1)
       (and (cell? obj2)
	    (equal? (cell-ref obj1) (cell-ref obj2))))
      ((number? obj1)
       (and (number? obj2)
	    (= obj1 obj2)))
      (else
       #f)))
