;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.7/Eval/evenv.scm ...        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 28 18:54:38 1994                          */
;*    Last change :  Sat Oct 29 10:18:52 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La manipulation de l'environnement global de l'interprete        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __evenv
   (export  (init-the-global-environment!)
	    (inline eval-global?           exp)
	    (inline eval-global-value      exp)
	    (inline set-eval-global-value! exp exp)
	    (inline eval-global-tag        exp)
	    (inline eval-global-name       exp)
	    (assert-unbind!                name)
	    (bind-eval-global!             name var)
	    (eval-lookup                   exp)
	    (define-primop!                var val)
	    (define-primop-ref!            var addr))
   (pragma  (init-the-global-environment! _no_eval_value_)
	    (eval-global?                 _no_eval_value_)
	    (eval-global-value            _no_eval_value_)
	    (set-eval-global-value!       _no_eval_value_)
	    (eval-global-tag              _no_eval_value_)
	    (eval-global-name             _no_eval_value_)
	    (assert-unbind!               _no_eval_value_)
	    (bind-eval-global!            _no_eval_value_)
	    (eval-lookup                  _no_eval_value_)
	    (define-primop!               _no_eval_value_)
	    (define-primop-ref!           _no_eval_value_)))

;*---------------------------------------------------------------------*/
;*    init-the-global-environment! ...                                 */
;*    -------------------------------------------------------------    */
;*    Il faut que cette fonction utilise le symbol `0000'              */
;*    pour etre sur qu'il est definit au moment ou on fait les         */
;*    `define-primop'.                                                 */
;*---------------------------------------------------------------------*/
(define (init-the-global-environment!)
   'nothing)
   
;*---------------------------------------------------------------------*/
;*    bind-eval-global! ...                                            */
;*---------------------------------------------------------------------*/
(define (bind-eval-global! name var)
   (putprop! name '0000 var))

;*---------------------------------------------------------------------*/
;*    define-primop! ...                                               */
;*---------------------------------------------------------------------*/
(define (define-primop! var val)
   (let ((cell (eval-lookup var)))
      (if (not (eval-global? cell))
	  (bind-eval-global! var (vector 0 var val))
	  (set-eval-global-value! cell val))))

;*---------------------------------------------------------------------*/
;*    define-primop-ref! ...                                           */
;*---------------------------------------------------------------------*/
(define (define-primop-ref! var addr)
   (if (not (eval-lookup var))
       (bind-eval-global! var (vector 1 var addr))))

;*---------------------------------------------------------------------*/
;*    assert-unbind! ...                                               */
;*---------------------------------------------------------------------*/
(define (assert-unbind! name)
   (remprop! name '0000))

;*---------------------------------------------------------------------*/
;*    eval-lookup ...                                                  */
;*---------------------------------------------------------------------*/
(define (eval-lookup var)
   (let ((prop (getprop var '0000)))
      (if prop
	  prop
	  #f)))

;*---------------------------------------------------------------------*/
;*    eval-global? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (eval-global? variable)
   (and (vector? variable)
	(=fx (vector-length variable) 3)))

;*---------------------------------------------------------------------*/
;*    eval-global-tag ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (eval-global-tag eval-global)
   (vector-ref-ur eval-global 0))

;*---------------------------------------------------------------------*/
;*    eval-global-name ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (eval-global-name eval-global)
   (vector-ref-ur eval-global 1))

;*---------------------------------------------------------------------*/
;*    eval-global-value ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (eval-global-value eval-global)
   (vector-ref-ur eval-global 2))

;*---------------------------------------------------------------------*/
;*    set-eval-global-value! ...                                       */
;*---------------------------------------------------------------------*/
(define-inline (set-eval-global-value! eval-global value)
   (vector-set-ur! eval-global 2 value))
