;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.7/Eval/eval.scm ...         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Oct 22 09:34:28 1994                          */
;*    Last change :  Thu Jan 19 14:09:21 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'evaluateur de Bigloo                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __eval
   (export  (eval                   <expression>)
	    (load                   <string>)
	    (loadq                  <string>)
	    (loada                  <string>)
	    (repl)
	    (module-declaration!    decls)
	    (expand-define-macro    <expression> <expander>)
	    (expand-define-expander <expression> <expander>)
	    (expand-define-pattern  <expression>)
	    *prompt*
	    *load-path*
	    *user-pass-name*
	    *user-pass*
	    (notify-assert-fail     formals actuals pred)
	    *assert-exiting-value*
	    *nil*)
   (pragma  (expand-define-macro    _no_eval_value_)
	    (expand-define-expander _no_eval_value_)
	    (expand-define-pattern  _no_eval_value_)
	    (notify-assert-fail     _no_eval_value_))
   (import  (__install_expanders "Eval/expanders.scm")
	    (__progn             "Eval/progn.scm")
	    (__expand            "Eval/expand.scm")
	    (__evcompile         "Eval/evcompile.scm")
	    (__evmeaning         "Eval/evmeaning.scm")
	    (extend.r.macro-env __match_normalize "Match/normalize.scm"))
   (foreign (include "signal.h")
	    (define int display-prompt (string int) "printf")
	    (obj reset-console!        (obj)        "reset_console")
	    (define int sigsetmask     (int)        "sigsetmask")
	    (define int sigint                      "SIGINT")))

;*---------------------------------------------------------------------*/
;*    On installe tous les expanseurs                                  */
;*---------------------------------------------------------------------*/
(install-all-expanders!)

;*---------------------------------------------------------------------*/
;*    eval ...                                                         */
;*---------------------------------------------------------------------*/
(define (eval exp)
   (let ((exp (if (procedure? *user-pass*)
		  (*user-pass* (list exp))
		  exp)))
      (evmeaning (evcompile (expand exp) '() 'nowhere #f) '())))

;*---------------------------------------------------------------------*/
;*    La boucle `top-level'. Puisqu'il faut eviter d'avoir plusieurs   */
;*    fichiers ou il a `eval' dans la libraire, on met la `repl' ici.  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Les variables de l'historique                                    */
;*---------------------------------------------------------------------*/
(define *history-head*       '(dummy))
(define *history-tail*       *history-head*)
(define *history-length*     0)
(define *history-max-length* 50)
(define *prompt*             "%d:=> ")

;*---------------------------------------------------------------------*/
;*    h ...                                                            */
;*---------------------------------------------------------------------*/
(define (h . num)
   (let loop ((h (cdr *history-head*)))
      (cond
	 ((null? h)
	  (unspecified))
	 ((null? (cdr h))
	  (unspecified))
	 (else
	  (begin
	     (display* (car (car h)) ": ")
	     (write (cdr (car h)))
	     (newline)
	     (loop (cdr h)))))))

;*---------------------------------------------------------------------*/
;*    ! ...                                                            */
;*---------------------------------------------------------------------*/
(define (! num)
   (let ((event (assq num (cdr *history-head*))))
      (if (not (pair? event))
	  (error "history" "event not found" num)
	  (eval (cdr event)))))

;*---------------------------------------------------------------------*/
;*    *end-of-repl*                                                    */
;*---------------------------------------------------------------------*/
(define *end-of-repl* exit)
(define *repl-num*    0)

;*---------------------------------------------------------------------*/
;*    repl ...                                                         */
;*---------------------------------------------------------------------*/
(define (repl)
   (let ((old-end-of-repl *end-of-repl*))
      (bind-exit (end-of-repl)
	 (begin
	    (set! *repl-num* (+fx *repl-num* 1))
	    (set! *end-of-repl* end-of-repl)
	    (internal-repl)))
      (set! *repl-num* (-fx *repl-num* 1))
      (set! *end-of-repl* old-end-of-repl)
      (unspecified)))

;*---------------------------------------------------------------------*/
;*    internal-repl ...                                                */
;*---------------------------------------------------------------------*/
(define (internal-repl)
   ;; le vrai top level
   (let ((lambda-stack  (get-lambda-stack)))
      (define (local-repl)
	 (let loop ()
	    (letrec ((handler (lambda (escape proc mes obj)
				 ;; on imprime le message d'erreur
				 (notify-error proc mes obj)
				 (dump-lambda-stack)
				 (flush-output-port (current-error-port))
				 ;; on restaure la pile de trace
				 (set-lambda-stack! lambda-stack)
				 ;; on ajuste le lecteur
				 (if (eof-object? obj)
				     (reset-eof (current-input-port)))
				 ;; on replace les signaux.
				 (sigsetmask 0)
				 (escape (unspecified)))))
	       (try
		(let loop ()
		   (newline)
		   (display-prompt *prompt* *repl-num*)
		   (let ((exp (read (current-input-port))))
		      ;; on s'occupe de l'historique
		      (set! *history-length* (+fx 1 *history-length*))
		      (set-cdr! *history-tail*
				(cons (cons *history-length* exp) '()))
		      (set! *history-tail* (cdr *history-tail*))
		      (if (> *history-length* *history-max-length*)
			  (set! *history-head* (cdr *history-head*)))
		      (if (eof-object? exp)
			  (quit)
			  (let ((v (eval exp)))
			     (print v)
			     (loop)))))
		handler))
	    (loop)))
      (letrec ((re-loop    (lambda (n) (unspecified)))
	       (catch-intr (lambda (n)
				 ;; l'attrapeur de signaux
				 (newline (current-error-port))
				 (fprint (current-error-port)
					 "*** INTERRUPT:bigloo:")
				 (flush-output-port (current-error-port))
				 (reader-reset!)
				 (reset-console! (current-input-port))
				 (set-lambda-stack! lambda-stack)
				 ;; il faut supprimer l'ancien (try ...)
				 ;; de repl
				 (remove-error-handler!)
				 ;; on re-active le mask des signaux.
				 (sigsetmask 0)
				 ;; on reprend la boucle.
				 (re-loop 'dummy))))
	 ;; on sauve l'ancien handler
	 (set! *old-sigint-handler* (cons (get-signal-handler sigint)
					  *old-sigint-handler*))
	 ;; on installe l'attrapeur de signaux ^C
	 (signal sigint catch-intr)
	 ;; on boucle sur un `bind-exit'
	 (let loop ()
	    (bind-exit (keep)
	       (set! re-loop keep)
	       (local-repl))
	    ;; on lance
	    (loop)))))

;*---------------------------------------------------------------------*/
;*    *old-sigint-handler* ...                                         */
;*    -------------------------------------------------------------    */
;*    Une variable qui sert au sauvegarder les handlers de ^C          */
;*---------------------------------------------------------------------*/
(define *old-sigint-handler* (list #f))

;*---------------------------------------------------------------------*/
;*    quit ...                                                         */
;*---------------------------------------------------------------------*/
(define (quit)
   ;; il faut d'abord restaurer l'ancien handler de ^C
   (if (procedure? (car *old-sigint-handler*))
       (begin
	  (signal sigint (car *old-sigint-handler*))
	  (set!  *old-sigint-handler* (cdr *old-sigint-handler*))))
   ;; il faut egalement restaurer l'ancien (try ...) de repl
   (remove-error-handler!)
   ;; maintenant que tout est propre, on peut quitter cette instance
   ;; de la boucle.
   (*end-of-repl* (unspecified)))

;*---------------------------------------------------------------------*/
;*    *load-path*                                                      */
;*---------------------------------------------------------------------*/
(define *load-path* '())

;*---------------------------------------------------------------------*/
;*    find-file ...                                                    */
;*---------------------------------------------------------------------*/
(define (find-file name)
   (if (file-exists? name)
       name
       (let loop ((path *load-path*))
	  (if (null? path)
	      name
	      (let ((try (string-append (car path) "/" name)))
		 (if (file-exists? try)
		     try
		     (loop (cdr path))))))))

;*---------------------------------------------------------------------*/
;*    load ...                                                         */
;*---------------------------------------------------------------------*/
(define (load file-name)
   (loadv file-name #t))

(define (loadq file-name)
   (loadv file-name #f))

(define (loadv file-name v?)
   (let ((port (open-input-file (find-file file-name))))
      (if (input-port? port)
	  (let loop ((sexp         (read port))
		     (v            (unspecified))
		     (module-seen? #f)
		     (main         #f))
	     (cond
		((eof-object? sexp)
		 (close-input-port port)
		 (if (procedure? main)
		     (main (command-line))
		     v))
		((and (pair? sexp) (eq? (car sexp) 'module))
		 (if module-seen?
		     (error "load" "module defined twice" sexp)
		     (let ((main (assq 'main (cddr sexp))))
			(let ((v (eval sexp)))
			   (if v?
			       (print v))
			   (loop (read port)
				 v
				 #t
				 (if (pair? main)
				     (cadr main)
				     v))))))
		(else
		 (let ((v (eval sexp)))
		    (if v?
			(print v))
		    (loop (read port)
			  v
			  module-seen?
			  main)))))
	  (error "load" "Can't open file" file-name))))

;*---------------------------------------------------------------------*/
;*    loada ...                                                        */
;*---------------------------------------------------------------------*/
(define (loada file)
   (let ((port (open-input-file file)))
      (if (input-port? port)
	  (begin
	     (set! *afile-list* (append (read port) *afile-list*))
	     (close-input-port port))
	  (error "loada" "Can't open file" file))))
   
;*---------------------------------------------------------------------*/
;*    On met dans ce fichier les definitions de                        */
;*    `expand-define-expander' et `expand-define-macro' car elles      */
;*    contiennent des appels a `Eval'.                                 */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    expand-define-expander ...                                       */
;*---------------------------------------------------------------------*/
(define (expand-define-expander x e)
   (match-case x
      ((?- (and (not (?- . ?-)) ?name) . ?macro)
       (install-expander name (eval (normalize-progn macro)))
       (unspecified))
      (else
       (error "define-expander" "Illegal `define-expander' syntax" x))))

;*---------------------------------------------------------------------*/
;*    expand-define-macro ...                                          */
;*---------------------------------------------------------------------*/
(define (expand-define-macro x e)
   (match-case x
      ((or (?- (?name . ?args) . ?body)
	   (?- ?name (lambda ?args . ?body)))
       (install-expander name  
			 (eval `(lambda (x e)
				   (e (let ,(destructure args '(cdr x) '())
					 ,(normalize-progn body))
				      e))))
       (unspecified))
      (else
       (error "define-macro" "Illegal `define-macro' syntax" x))))

;*---------------------------------------------------------------------*/
;*    destructure ...                                                  */
;*---------------------------------------------------------------------*/
(define (destructure pat arg bindings)
   (cond
      ((null? pat) (cons `(,(gensym '.dummy.)
			   (if (not (null? ,arg))
			       (error "expand"
				      "To many arguments provided"
				      ,arg)
			       '()))
			 bindings))
      ((symbol? pat) (cons `(,pat ,arg) bindings))
      ((pair? pat)
       (destructure (car pat) `(car ,arg)
		    (destructure (cdr pat) `(cdr ,arg)
				 bindings)))))

;*---------------------------------------------------------------------*/
;*    module-declaration! ...                                          */
;*---------------------------------------------------------------------*/
(define (module-declaration! decls)
   (let loop ((decls decls))
      (cond
	 ((null? decls)
	  'done)
	 ((not (pair? (car decls)))
	  (error "eval" "Illegal module declaration" decls))
	 ((eq? (car (car decls)) 'include)
	  (include! (cdr (car decls)))
	  (loop (cdr decls)))
	 ((eq? (car (car decls)) 'import)
	  (import! (cdr (car decls)))
	  (loop (cdr decls)))
	 ((eq? (car (car decls)) 'load)
	  (import! (cdr (car decls)))
	  (loop (cdr decls)))
	 (else
	  (loop (cdr decls))))))

;*---------------------------------------------------------------------*/
;*    *files* ...                                                      */
;*---------------------------------------------------------------------*/
(define *included-files* '())
(define *imported-files* '())
(define *afile-list*     '())

;*---------------------------------------------------------------------*/
;*    include! ...                                                     */
;*---------------------------------------------------------------------*/
(define (include! includes)
   (for-each (lambda (i)
		(if (not (member i *included-files*))
		    (begin
		       (set! *included-files* (cons i *included-files*))
		       (loadq i))))
	     includes))

;*---------------------------------------------------------------------*/
;*    import! ...                                                      */
;*---------------------------------------------------------------------*/
(define (import! iclauses)
   (let ((l (map (lambda (i)
		     (match-case i
			((?- ?second)
			 (if (string? second)
			     second
			     (let ((cell (assq second *afile-list*)))
				(if (pair? cell)
				    (cadr cell)
				    #f))))
			((?- ?- ?third)
			 third)
			(?module
			 (let ((cell (assq module *afile-list*)))
			    (if (pair? cell)
				(cadr cell)
				#f)))
		 	(else
			 #f)))
		  iclauses)))
      (for-each (lambda (i)
		   (if (and (string? i)
			    (not (member i *imported-files*)))
		       (begin
			  (set! *imported-files* (cons i *imported-files*))
			  (loadq i))))
		l)))

;*---------------------------------------------------------------------*/
;*    expand-define-pattern ...                                        */
;*---------------------------------------------------------------------*/
(define (expand-define-pattern x)
   (match-case x
      ((?- ?name ?var ?body)
       (extend.r.macro-env name (eval `(lambda ,var ,body)))
       ''dummy)
      (else
       (error "expand-define-pattern" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    notify-assert-fail ...                                           */
;*---------------------------------------------------------------------*/
(define (notify-assert-fail formals actuals assert-shape)
   (let ((port (current-error-port))
	 (old  (get-write-length)))
      (set-write-length! 80)
      (notify-error "assert"
		    "assertion failed"
		    assert-shape)
      (fprint port "_________________________________")
      (fprint port "the values of the variables are: ")
      (for-each (lambda (f a)
		   (fprint port "   " f " : " a))
		formals actuals)
      (fprint port "_________________________________")
      (set-write-length! old)
      (dump-lambda-stack 10)
      (let ((old-prompt *prompt*))
	 (set! *prompt* "*:=> ")
	 (repl)
	 (set! *prompt* old-prompt))))

;*---------------------------------------------------------------------*/
;*    *assert-exiting-value* ...                                       */
;*---------------------------------------------------------------------*/
(define *assert-exiting-value* (unspecified))
       
;*---------------------------------------------------------------------*/
;*    *nil* ...                                                        */
;*---------------------------------------------------------------------*/
(define *nil* #t)

;*---------------------------------------------------------------------*/
;*    *user-pass* ...                                                  */
;*---------------------------------------------------------------------*/
(define *user-pass*      (unspecified))  ;; l'eventuelle user passe 
(define *user-pass-name* "User")         ;; le nom de la user pass

