/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.7/Clib/writer.c ...         */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec 17 09:44:20 1991                          */
/*    Last change :  Wed Jan 18 17:12:05 1995 (serrano)                */
/*                                                                     */
/*    On imprime les objets (non recursifs)                            */
/*---------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern obj_t c_constant_string_to_string();

/*---------------------------------------------------------------------*/
/*    Les noms des caracateres                                         */
/*---------------------------------------------------------------------*/
static char *char_name[] =
{
   "","","","","","","","",
   "",  "tab", "newline", "", "", "return", "", "",
   "", "","","","","","","",
   "", "", "","","", "", "", "",
   "space", "!", "\"","#","$","%","&","'",
   "(", ")", "*", "+", ",", "-", ".", "/",
   "0", "1", "2", "3", "4", "5", "6", "7",
   "8", "9", ":", ";", "<", "=", ">", "?",
   "@", "A", "B", "C", "D", "E", "F", "G",
   "H", "I", "J", "K", "L", "M", "N", "O",
   "P", "Q", "R", "S", "T", "U", "V", "W",
   "X", "Y", "Z", "[", "\\", "]", "^", "_",
   "`", "a", "b", "c", "d", "e", "f", "g",
   "h", "i", "j", "k", "l", "m", "n", "o",
   "p", "q", "r", "s", "t", "u", "v", "w",
   "x", "y", "z", "{", "|", "}", "~", ""
};


/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    strputc ...                                                      */
/*---------------------------------------------------------------------*/
obj_t
strputc( c, p )
char  c;
obj_t p;
{
	long offset;
	
	if( END_OF_STRING_PORTP( p ) )
	   strport_grow( p );

	offset = OUTPUT_STRING_PORT( p ).offset;

	OUTPUT_STRING_PORT( p ).buffer[ offset ] = c;
	OUTPUT_STRING_PORT( p ).offset = offset + 1;

	return p;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    lstrputs ...                                                     */
/*---------------------------------------------------------------------*/
static obj_t
lstrputs( s, p, len )
char *s;
obj_t p;
long  len;
{
	long offset;
	
	offset = OUTPUT_STRING_PORT( p ).offset;

	while((OUTPUT_STRING_PORT( p ).offset+len) > OUTPUT_STRING_PORT( p ).size)
	   strport_grow( p );

	strcpy( &(OUTPUT_STRING_PORT( p ).buffer[ offset ]), s );

	OUTPUT_STRING_PORT( p ).offset = offset + len;

	return p;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    strputs ...                                                      */
/*---------------------------------------------------------------------*/
obj_t
strputs( s, p )
char *s;
obj_t p;
{
	return lstrputs( s, p, strlen( s ) );
}
	
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    write_object_s ...                                               */
/*---------------------------------------------------------------------*/
static obj_t
write_object_s( o ,f )
obj_t o, f;
{
   if( INTEGERP( o ) )
   {
		char new[ 100 ];
		
      sprintf( new, "%ld", CINT( o ) );

		strputs( new, f );
		
      return o;
   }
   else
      if( CHARP( o ) )
      {
         strputc( CCHAR( o ), f );
			
         return BUNSPEC;
      }
      else
         switch( (long)o )
         {
#if !(defined( ALLOCATE_CONSTANT ))
            case (long)BNIL :
               lstrputs( "()", f, 2 );
               return BNIL;

            case (long)BUNSPEC :
               lstrputs( "#unspecified", f, 12 );
               return BUNSPEC;
            
            case (long)BFALSE :
               lstrputs( "#f", f, 2 );
               return BFALSE;
            
            case (long)BTRUE :
               lstrputs( "#t", f, 2 );
               return BTRUE;

            case (long)BEOF :
               lstrputs( "#<eof-object>", f, 14 );
               return BEOF;
#endif
               
            default :
				   if( CNSTP( o ) )
					{
						char aux[ 7 ];
						
						sprintf( aux, "#<%04x>", (int)CCNST( o ) );
						lstrputs( aux, f, 7 );
						
						return o;
					}
					   
               if( !POINTERP( o ) )
               {
						char aux[ 16 ];
						
						sprintf( aux, "#<???:%08x>", (unsigned)o );
                  strputs( aux, f );
                  return o;
               }
               else
                  switch( HEADER( o ) )
                  {
#if defined( ALLOCATE_CONSTANT )
                     case HEADER_TRUE :
                        lstrputs( "#t", f, 2 );
                        return BTRUE;
                        
                     case HEADER_FALSE :
                        lstrputs( "#f", f, 2 );
                        return BFALSE;
                  
                     case HEADER_NIL :
                        lstrputs( "()", f, 2 );
                        return BNIL;
                  
                     case HEADER_UNDEF :
                        lstrputs( "#unspecified", f, 12 );
                        return BUNSPEC;

                     case HEADER_EOF :
                        lstrputs( "#<eof-object>", f, 14 );
                        return BEOF;
#endif
                     case HEADER_STRING :
                        lstrputs( BSTRING_TO_CSTRING( o ),
										    f,
										    CINT( STRING_LENGTH( o ) ) );
                        return o;
               
                     case HEADER_SYMBOL :
                        strputs( SYMBOL( o ).name, f );
                        return o;
               
                     case HEADER_REAL :
							   {
									char new[ 20 ];
									int i;
									
									memset( new, '0', 20 );
                           sprintf( new, "%#.12g", REAL( o ).real );
									
									for( i = 19;
										  (i > 0) && ((new[ i ] == '0') ||
														  (new[ i ] == '\0'));
										  i-- )
									   new[ i ] = '\0';

									strputs( new, f );
									
                           return o;
								}
								
                     case HEADER_PROCEDURE :
							   {
									char new[ 100 ];

									sprintf( new, "#<procedure:%x.%d>", (unsigned) o,
											   (long)PROCEDURE( o ).arity );
									strputs( new, f );
									
                           return o;
								}
                  
                     case HEADER_OUTPUT_PORT :
							   {
									char new[ 100 ];
									
                           sprintf( new, "#<output_port:%s>",
                                    OUTPUT_PORT( o ).name );
									strputs( new, f );
									
                           return o;
								}

							case HEADER_OUTPUT_STRING_PORT :
                        lstrputs( "#<output_string_port>", f, 21 );
                        return o;
							
                     case HEADER_INPUT_PORT : 
							   {
									char new[ 500 ];
									
                           sprintf( new, "#<input_port:%s.%d>",
                                    INPUT_PORT( o ).name,
                                    (long)INPUT_PORT( o ).bufsiz );
									strputs( new, f );
									
                           return o;
								} 
               
                     case HEADER_BINARY_PORT : 
							   {
									char new[ 500 ];
									
                           sprintf( new, "#<binary_input_port:%s.%s>",
                                    BINARY_PORT( o ).name,
											   BINARY_PORT_INP( o ) ? "in" : "out" );
									strputs( new, f );
									
                           return o;
								} 
               
						   case HEADER_CELL :
						      lstrputs( "#<cell:", f, 7 );
								write_object_s( CELL_REF( o ), f );
								lstrputs( ">", f, 1 );
								
								return o;

						   case HEADER_FOREIGN :
						      lstrputs( "#<type:", f, 7 );
								write_object_s( FOREIGN_ID( o ), f );
								lstrputs( ">", f, 1 );
								
								return o;
			
						   default :
						      {
									char aux[ 20 ];
						
									sprintf( aux, "#<???:%08x>", (unsigned)o );
									strputs( aux, f );
									return o;
								}								
							}
      }
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    write_object_f ...                                               */
/*---------------------------------------------------------------------*/
static obj_t
write_object_f( o ,f )
obj_t o, f;
{
   FILE *fout = OUTPUT_PORT( f ).file;

   if( INTEGERP( o ) )
   {
      fprintf( fout, "%ld", CINT( o ) );
		
      return o;
   }
   else
      if( CHARP( o ) )
      {
         fputc( CCHAR( o ), fout );
			
         return BUNSPEC;
      }
      else
         switch( (long)o )
         {
#if !(defined( ALLOCATE_CONSTANT ))
            case (long)BNIL :
               fputs( "()", fout );
               return BNIL;

            case (long)BUNSPEC :
               fputs( "#unspecified", fout );
               return BUNSPEC;
            
            case (long)BFALSE :
               fputs( "#f", fout );
               return BFALSE;
            
            case (long)BTRUE :
               fputs( "#t", fout );
               return BTRUE;

            case (long)BEOF :
               fputs( "#<eof-object>", fout);
               return BEOF;
#endif
               
            default :
				   if( CNSTP( o ) )
					{
						fprintf( fout, "#<%04x>", (int)CCNST( o ) );
						return o;
					}
					
					if( !POINTERP( o ) )
               {
						fprintf( fout, "#<???:%08x>", (unsigned)o );
                  return o;
               }
               else
                  switch( HEADER( o ) )
                  {
#if defined( ALLOCATE_CONSTANT )
                     case HEADER_TRUE :
                        fputs( "#t", fout );
                        return BTRUE;
                        
                     case HEADER_FALSE :
                        fputs( "#f", fout );
                        return BFALSE;
                  
                     case HEADER_NIL :
                        fputs( "", fout );
                        return BNIL;
                  
                     case HEADER_UNDEF :
                        fputs( "#UNDEF", fout );
                        return BUNSPEC;

                     case HEADER_EOF :
                        fputs( "#<eof-object>", fout);
                        return BEOF;
#endif
                     case HEADER_STRING :
							   {
									int len = CINT( STRING_LENGTH( o ) );
									char *aux = &STRING_REF( o, 0 );

									while( len-- )
									   fputc( *aux++, fout );

                           return o;
							   }
								
                     case HEADER_SYMBOL :
                        fputs( SYMBOL( o ).name, fout );
                        return o;
               
                     case HEADER_REAL :
							   {
								   char new[ 20 ];
									int i;
									
									memset( new, '0', 20 );
                           sprintf( new, "%#.12g", REAL( o ).real );

									for( i = 19;
										  (i > 0) && ((new[ i ] == '0') ||
														  (new[ i ] == '\0'));
										  i-- )
									   new[ i ] = '\0';

									fputs( new, fout );

                           return o;
								}
               
                     case HEADER_PROCEDURE :
                        fprintf( fout, "#<procedure:%x.%d>", (unsigned)o,
                                 (long)PROCEDURE( o ).arity );
                        return o;
                  
                     case HEADER_OUTPUT_PORT :
                        fprintf( fout, "#<output_port:%s>",
                                 OUTPUT_PORT( o ).name );
                        return o;
                     
                     case HEADER_OUTPUT_STRING_PORT :
                        fputs( "#<output_string_port>", fout );
                        return o;
							
                     case HEADER_INPUT_PORT :
                        fprintf( fout, "#<input_port:%s.%d>",
                                 INPUT_PORT( o ).name,
                                 (long)INPUT_PORT( o ).bufsiz );
                        return o;
								
                     case HEADER_BINARY_PORT :
                        fprintf( fout, "#<binary_input_port:%s.%s>",
                                 BINARY_PORT( o ).name,
										   BINARY_PORT_INP( o ) ? "in" : "out" );
                        return o;
               
						   case HEADER_CELL :
							   fputs( "#<cell:", fout );
								write_object_f( CELL_REF( o ), f );
								fputs( ">", fout );
								
								return o;

						   case HEADER_FOREIGN :
							   fputs( "#<type:", fout );
								write_object_f( FOREIGN_ID( o ), f );
								fputs( ">", fout );
								
								return o;
			
						   default :
			               {
									fprintf( fout, "#<???:%08x>", (unsigned)o );
									return o;
								}		
            }
      }
}

/*---------------------------------------------------------------------*/
/*    write_object ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
write_object( o, f )
obj_t o, f;
{
	if( OUTPUT_STRING_PORTP( f ) )
	   return write_object_s( o, f );
	else
	   return write_object_f( o, f );
}

/*---------------------------------------------------------------------*/
/*    write_string_f ...                                               */
/*---------------------------------------------------------------------*/
obj_t
write_string_f( string, port )
obj_t string, port;
{
   FILE *fout = OUTPUT_PORT( port ).file;
   char *aux  = BSTRING_TO_CSTRING( string );
   
   fputc( '"', fout );
   fputs( aux, fout );
   fputc( '"', fout );
   return string;
}

/*---------------------------------------------------------------------*/
/*    write_string_s ...                                               */
/*---------------------------------------------------------------------*/
obj_t
write_string_s( string, port )
obj_t string, port;
{
   char *aux  = BSTRING_TO_CSTRING( string );
   
   strputc( '"', port );
   strputs( aux, port );
   strputc( '"', port );
	
   return string;
}

/*---------------------------------------------------------------------*/
/*    write_string ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
write_string( string, port )
obj_t string, port;
{
	if( OUTPUT_STRING_PORTP( port ) )
	   return write_string_s( string, port );
	else
	   return write_string_f( string, port ); 
}

/*---------------------------------------------------------------------*/
/*    write_char_f ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
write_char_f( c, port )
obj_t c, port;
{
   FILE *f = OUTPUT_PORT( port ).file;
	
   if( (CCHAR( c ) > 0) && (char_name[ CCHAR( c ) ][ 0 ]) )
		fprintf( f, "#\\%s", char_name[ CCHAR( c ) ] );
	else
		fprintf( f, "#a%03d", (unsigned char)(CCHAR( c )) );
   
   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    write_char_s ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
write_char_s( c, port )
obj_t c, port;
{

   if( (CCHAR( c ) > 0) && (char_name[ CCHAR( c ) ][ 0 ]) )
	{
     		
		lstrputs( "#\\", port, 2 );
		strputs( char_name[ CCHAR( c ) ], port );
	}
	else
	{
		char aux[ 10 ];
		
		sprintf( aux, "#a%03d", (unsigned char)(CCHAR( c )) );
		strputs( aux, port );
	}
   
   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    write_char ...                                                   */
/*---------------------------------------------------------------------*/
obj_t
write_char( c, port )
obj_t c, port;
{
	if( OUTPUT_STRING_PORTP( port ) )
	   return write_char_s( c, port );
	else
	   return write_char_f( c, port );
}   

/*---------------------------------------------------------------------*/
/*    ill_char_rep ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
ill_char_rep( c )
obj_t c;
{
   char aux[ 10 ];

   sprintf( aux, "#a%03d", CCHAR( c ) );

   return c_constant_string_to_string( aux );
}
