/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.7/Clib/binary.c ...         */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Jun  7 09:02:35 1994                          */
/*    Last change :  Sat Oct 22 13:23:29 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    La gestion des ports binaire d'entree et de sortie.              */
/*=====================================================================*/
#include <stdio.h>
#include <errno.h>
#if( !(defined( NeXT ) && defined( mc68000 )) )
#   include <termio.h>
#endif
#if( !defined( sony_news ) && !(defined( NeXT ) && defined( mc68000 )) )
#   include <unistd.h>
#endif
#include <sys/file.h>
/*---------------------------------------------------------------------*/
/*    On definit cette macros pour que le fichier `gc_private.h' ne    */
/*    soit pas inclus. Il faut faire ca car ce fichier declare un      */
/*    prototype de `sbrk' qui n'est pas compatible avec le prototype   */
/*    quelque fois present (sur linux, par exemple) dans `unisys.h'    */
/*---------------------------------------------------------------------*/
#if( defined( i386 ) )
#   define GC_PRIVATE_H
#endif
#include <bigloo.h>
#if( defined( sony_news ) || (defined( NeXT ) && defined( mc68000 )) )
#   include <ctype.h>
#endif
#if( defined( i386 ) )
    extern obj_t GC_malloc();
    extern obj_t GC_malloc_atomic();
#endif

/*---------------------------------------------------------------------*/
/*    MAGIC_WORD ...                                                   */
/*---------------------------------------------------------------------*/
#if defined( MAGIC_WORD )
#   undef MAGIC_WORD
#endif

#define MAGIC_WORD "1966"

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern obj_t the_failure();
extern obj_t obj_to_string(), string_to_obj();

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    make_binary_port ...                                             */
/*    -------------------------------------------------------------    */
/*    Cette procedure alloue tous les ports binaires. Qu'ils soient    */
/*    en sortie ou en entree.                                          */
/*---------------------------------------------------------------------*/
static obj_t
make_binary_port( name, file, io )
char   *name;
FILE   *file;
bool_t  io;
{
	obj_t binary_port, aux;

	binary_port = MAKE_OBJECT( BINARY_PORT_SIZE,
									   HEADER_BINARY_PORT, aux );
   
   binary_port->binary_port_t.file = file;
   binary_port->binary_port_t.name = name;
   binary_port->binary_port_t.io   = io;
   
   return BREF( binary_port );
}

/*---------------------------------------------------------------------*/
/*    open_output_binary_file ...                                      */
/*---------------------------------------------------------------------*/
obj_t
open_output_binary_file( name )
obj_t name;
{
   FILE *file;
   
   if( !(file = fopen( BSTRING_TO_CSTRING( name ), "w" )) )
      return BFALSE;

   return make_binary_port( BSTRING_TO_CSTRING( name ),
									 file,
									 BINARY_PORT_OUT );
}

/*---------------------------------------------------------------------*/
/*    append_output_binary_file ...                                    */
/*---------------------------------------------------------------------*/
obj_t
append_output_binary_file( name )
obj_t name;
{
   FILE *file;
   
   if( !(file = fopen( BSTRING_TO_CSTRING( name ), "a+" )) )
      return BFALSE;

   return make_binary_port( BSTRING_TO_CSTRING( name ),
									 file,
									 BINARY_PORT_OUT );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    close_binary_port ...                                            */
/*---------------------------------------------------------------------*/
obj_t
close_binary_port( port )
obj_t port;
{
	fclose( BINARY_PORT( port ).file );

	return port;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    open_input_binary_file ...                                       */
/*---------------------------------------------------------------------*/
obj_t
open_input_binary_file( name )
obj_t name;
{
	FILE *file;
	obj_t binary_port;

	if( !(file = fopen( BSTRING_TO_CSTRING( name ), "r" )) )
      return BFALSE;
      
   { 
      obj_t aux; 

      binary_port = make_binary_port( BSTRING_TO_CSTRING( name ),
												  file,
												  BINARY_PORT_IN );
   }

	return BREF( binary_port );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    output_obj ...                                                   */
/*---------------------------------------------------------------------*/
obj_t
output_obj( port, obj )
obj_t port, obj;
{
	FILE          *file = BINARY_PORT( port ).file;
	obj_t          string;
	unsigned char  slen[ 4 ];
	long           clen;

	/* Le calcul de la chaine a dumper */
	string = obj_to_string( obj );

	/* Le mot magique */
	fwrite( MAGIC_WORD, 4, 1, file );

	/* La longueur de la chaine */
	clen = CINT( STRING_LENGTH( string ) );
	
	slen[ 0 ] = (unsigned char)clen;
	slen[ 1 ] = (unsigned char)(clen>>8);
	slen[ 2 ] = (unsigned char)(clen>>16);
	slen[ 3 ] = (unsigned char)(clen>>24);
	
	fwrite( slen, 4, 1, file );
	
	/* La chaine elle meme */
	fwrite( BSTRING_TO_CSTRING( string ), clen, 1, file );

	return obj;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    input_obj ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
input_obj( port )
obj_t port;
{
	FILE           *file = BINARY_PORT( port ).file;
	unsigned char   slen[ 4 ];
	long            clen;
	char            magic[ 4 ];

	/* la cle magique */
	fread( magic, 4, 1, file );

	if( memcmp( magic, MAGIC_WORD, 4 ) )
	   return the_failure( c_constant_string_to_string( "input_obj" ),
						        c_constant_string_to_string( "corrupted file" ),
						        port );

	/* la longueur */
	fread( slen, 4, 1, file );

	clen = ((long)slen[ 0 ]) + (((long)slen[ 1 ]) << 8) +
          (((long)slen[ 2 ]) << 16) + (((long)slen[ 3 ]) << 24);

	/* On fait deux cas en fonction de la taille de l'objet a lire */
	if( clen < 1024 )
	{
		char  string[ 1024 + STRING_SIZE ];
		obj_t res;

		((obj_t)string)->string_t.header = HEADER_STRING;
		((obj_t)string)->string_t.length = BINT( clen );
		
		fread( BSTRING_TO_CSTRING( (obj_t)string), clen, 1, file );

		res = string_to_obj( (obj_t)string );

		return res;
	}
	else
	{
		char  *string;
		obj_t  res;

		string = (char *)malloc( STRING_SIZE + clen );

		if( !string )
		   return the_failure( c_constant_string_to_string( "input_obj" ),
			   			        c_constant_string_to_string( "can't allocate string" ),
						           port );

		((obj_t)string)->string_t.header = HEADER_STRING;
		((obj_t)string)->string_t.length = BINT( clen );
		
		fread( BSTRING_TO_CSTRING( (obj_t)string), clen, 1, file );

		res = string_to_obj( (obj_t)string );

		free( string );
		
		return res;
	}
}
		

	
