;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/string.scm ...               */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  3 10:18:56 1992                          */
;*    Last change :  Wed Dec 21 12:17:52 1994 (serrano)                */
;*                                                                     */
;*    On test differentes operations sur les chaines de characteres    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module string
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-string)))

;*---------------------------------------------------------------------*/
;*    test-string ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-string)
   (test-module "string" "string.scm" #f)
   (test "string=?" (string=? "toto n'est pas content"
			      "toto n'est pas content")
	 #t)
   (test "string=?" (string=? "ToTo" "tOtO") #f)
   (test "string=?" (let ((s (make-string 3 (integer->char 0))))
		       (string=? s #"\000\000\000"))
	 #t)
   (test "string=?" (let ((s (make-string 3 (integer->char 0))))
		       (string=? s #"\000\001\000"))
	 #f)
   (test "string-length" (string-length "12345") 5)
   (test "string" (equal? "toto n'est pas content" "toto est content")
	 #f)
   (test "make-string" (string-ref (make-string 1 #\a) 0) #\a)
   (test "string-append" (string-append "Toto " "est content")
	 "Toto est content")
   (test "string-append" (string-append "toto" " n'est" " pas" " content")
	 "toto n'est pas content")
   (test "string-upcase" (string-upcase "toto TOTO ToTo") "TOTO TOTO TOTO")
   (test "string-ci=?"     (string-ci=? "Toto" "tOtO") #t)
   (test "string-set"    (let ((s "0123456789"))
			    (string-set! s 0 (string-ref s 1))
			    s)
	 "1123456789")
   (test "list->string" (list->string '(#\t #\o #\t #\o)) "toto")
   (test "string->list" (string->list "toto") '(#\t #\o #\t #\o))
   (test "string->integer" (string->integer "01234") 1234)
   (test "integer->string" (integer->string 1234) "1234")
   (test "string->real" (string->real "1234.25") 1234.25)
   (test "real->string" (real->string 1234.25) "1234.25")
   (test "substring" (substring "0123456789" 1 5) "1234")
   (let ((dst (make-string 10 #\0))
	 (src (make-string 5 #\1)))
      (test "blit-string" (begin (blit-string! src 1 dst 1 3)
				 dst)
	    "0111000000"))
   (test "string<?" (string<? "012345" "123456") #t)
   (test "string<=?" (string<=? "012345" "012345") #t)
   (test "string>?" (string>? "012345" "123456") #f)
   (test "string>=?" (string<=? "012345" "012345") #t)
   (test "string-ci<?" (string-ci<? "abcdef" "ABCDEF") #f)
   (test "string-ci<?" (string-ci<? "abcdef" "ABCDEG") #t)
   (test "string-ci<=?" (string-ci<=? "abcdef" "ABCDEG") #t)
   (test "string-ci<=?" (string-ci<=? "abcdef" "ABCDEG") #t)
   (test "string-ci>?" (string-ci>? "abcdef" "ABCDEG") #f)
   (test "string-ci>?" (string-ci>? "abcdef" "ABCDEG") #f)
   (test "string-ci>=?" (string-ci>=? "abcdef" "ABCDEG") #f)
   (test "string-ci>=?" (string-ci>=? "abcdef" "ABCDEF") #t)
   (test "foreign" (let ((x "\n\t\\\"")) (string->list x)) '(#\n #\t #\\ #\"))
   (test "foreign" (let ((x #"\n\\\"")) (string->list x))
	 '(#\newline #\\ #\"))
   (test "symbol" (symbol->string (string->symbol "tOtO")) "tOtO")
   (test "symbol" (eq? (string->symbol "ToTo") 'toto) #f)
   (test "symbol" (eq? (string->symbol "TOTO") 'toto) #t)
   (test "string-copy" (string-copy "toto n'est pas content")
	 "toto n'est pas content")
   (test "escape" (string-length #"\000") 1)
   (test "escape" (char->integer (string-ref #"\000" 0)) 0)
   (test "escape" (char->integer (string-ref #"\003" 0)) 3))
   
   


	 
