;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Tailrec/tail.scm ...     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 30 11:10:36 1994                          */
;*    Last change :  Tue Dec 13 08:11:36 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On rend des definitions tail-rec                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tailrec_tail
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "Tailrec/rec-info.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    tools_beta
	    heap_abstract
	    scan_lexical)
   (export  (rec-type                  <variable> <formals> <exp>)
	    (cons-rec->tail-cons-rec   <rec-info>)))

;*---------------------------------------------------------------------*/
;*    rec-type ...                                                     */
;*    -------------------------------------------------------------    */
;*    Une fonction f est `rec-cons', si elle possede un appel          */
;*    recursif du style (cons exp (f ...)).                            */
;*---------------------------------------------------------------------*/
(define (rec-type who formals exp)
   ;; pour le moment seule les recursion sur les listes sont faites.
   (cons-rec who formals exp))

;*---------------------------------------------------------------------*/
;*    cons-rec ...                                                     */
;*---------------------------------------------------------------------*/
(define (cons-rec who formals exp)
   (let* ((stop-exp (null-stop formals exp))
	  (the-list (if (pair? stop-exp)
			(cadr (cadr stop-exp)))))
      (trace (tailrec loop) "stop-exp: " (shape stop-exp) #\Newline)
      (cond
	 ((not stop-exp)
	  #f)
	 ((not (only-changing? who formals the-list exp))
	  #f)
	 (else
	  (let ((rec-exp (find-cons-recursion who the-list exp)))
	     (trace (tailrec loop) "cons-rec: " (shape rec-exp) #\Newline)
	     (if rec-exp
		 (rec-info 'rec-cons
			   who
			   the-list
			   exp
			   stop-exp
			   (car rec-exp)
			   (cadr rec-exp)
			   (caddr rec-exp))
		 #f))))))


;*---------------------------------------------------------------------*/
;*    null-stop ...                                                    */
;*    -------------------------------------------------------------    */
;*    Est-ce que le corps de cette fonction ressemble a :              */
;*       `(if (null? l) ...)'                                          */
;*    ou l est un parametre formel ? Si oui, cette fonction retourne l.*/
;*---------------------------------------------------------------------*/
(define (null-stop formals exp)
   (let ((exp (remove-begin exp)))
      (match-case exp
	 ((if (?null ?l) (or ((kwote quote) ())
			     (begin ((kwote quote) ())))
	      ?-)
	  (if (and (abstract? null 'c-null?)
		   (memq l formals))
	      exp
	      #f))
	 (else
	  #f))))

;*---------------------------------------------------------------------*/
;*    remove-begin ...                                                 */
;*---------------------------------------------------------------------*/
(define (remove-begin exp)
   (match-case exp
      ((begin ?exp)
       (remove-begin exp))
      (else
       exp)))

;*---------------------------------------------------------------------*/
;*    find-cons-recursion ...                                          */
;*    -------------------------------------------------------------    */
;*    On recherche dans la definition de la fonction un appel          */
;*    recursif :                                                       */
;*      `(cons (F (car l)) (who (cdr l)))'.                            */
;*    Si on le trouve, on retourne l'expression.                       */
;*---------------------------------------------------------------------*/
(define (find-cons-recursion who the-list exp)
   (trace (tailrec loop) "find-cons-recursion: " (shape exp) #\Newline)
   (match-case exp
      ((atom ?-)
       #f)
      ((quote ?-)
       #f)
      ((pragma . ?-)
       #f)
      ((assert . ?-)
       #f)
      ((begin . ?exps)
       (find-cons-recursion who the-list (car (last-pair exps))))
      ((set! . ?-)
       #f)
      ((let ((?var ?val)) ?var)
       (let ((find (find-cons-recursion who the-list val)))
	  (if find
	      (cons exp (cdr find))
	      #f)))
      ((let ?bindings ?body)
       #f)
      ((labels . ?-)
       #f)
      ((failure . ?-)
       #f)
      ((bind-exit . ?-)
       #f)
      ((apply . ?-)
       #f)
      ((typed-case . ?-)
       #f)
      ((if ?- ?alors ?sinon)
       (or (find-cons-recursion who the-list alors)
	   (find-cons-recursion who the-list sinon)))
      ((?fun ?arg1 ?arg2)
	  (cond
	     ((abstract? fun 'c-cons 'c-inline-cons)
	      (if (and (car-rec-exp? arg1 the-list)
		       (cdr-rec-exp? arg2 who the-list))
		  (list exp arg1 arg2)
		  #f))
	     (else
	      #f)))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    car-rec-exp? ...                                                 */
;*---------------------------------------------------------------------*/
(define (car-rec-exp? exp l)
   (trace (tailrec loop) "car-rec-exp?: " (shape exp) #\Newline)
   (match-case exp
      ((let ((?var ?exp)) ?var)
       (car-rec-exp? exp l))
      ((?fun ?arg)
       (or (car-exp? exp l)
	   (car-exp? arg l)))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    car-exp? ...                                                     */
;*---------------------------------------------------------------------*/
(define (car-exp? exp l)
   (trace (tailrec loop) "car-exp?: " (shape exp) #\Newline)
   (match-case exp
      ((let ((?var (?fun ?arg))) ?var)
       (and (abstract? fun 'c-car)
	    (eq? arg l)))
      ((?fun ?arg)
       (and (abstract? fun 'c-car)
	    (eq? arg l)))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    cdr-rec-exp? ...                                                 */
;*---------------------------------------------------------------------*/
(define (cdr-rec-exp? exp who l)
   (trace (tailrec loop) "cdr-rec-exp?: " (shape exp) #\Newline)
   (match-case exp
      ((let ((?var ?exp)) ?var)
       (cdr-rec-exp? exp who l))
      ((?fun1 . ?exps)
       (and (eq? fun1 who)
	    (let loop ((exps exps))
	       (cond
		  ((null? exps)
		   #f)
		  ((cdr-exp? (car exps) l)
		   #t)
		  (else
		   (loop (cdr exps)))))))
      (else
       #f)))
      
;*---------------------------------------------------------------------*/
;*    cdr-exp? ...                                                     */
;*---------------------------------------------------------------------*/
(define (cdr-exp? exp l)
   (trace (tailrec loop) "cdr-exp?: " (shape exp) #\Newline)
   (match-case exp
      ((let ((?var (?fun ?arg))) ?var)
       (and (abstract? fun 'c-cdr)
	    (eq? arg l)))
      ((?fun ?arg)
       (and (abstract? fun 'c-cdr)
	    (eq? arg l)))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    only-changing? ..                                                */
;*    -------------------------------------------------------------    */
;*    Seul le parametre `the-list' change dans les appels              */
;*    recursifs a `who'.                                               */
;*---------------------------------------------------------------------*/
(define (only-changing? who formals the-list exp)
   (trace (tailrec loop) "only-changing?: " (shape exp) #\Newline)
   (define (only-changing*? exps)
      (cond
	 ((null? exps)
	  #t)
	 ((only-changing? who formals the-list (car exps))
	  (only-changing*? (cdr exps)))
	 (else
	  #f)))
   (match-case exp
      ((atom ?-)
       #t)
      ((quote ?-)
       #t)
      ((pragma . ?exps)
       (only-changing*? exps))
      ((assert . ?exps)
       (only-changing*? exps))
      ((begin . ?exps)
       (only-changing*? exps))
      ((set! . ?-)
       #f)
      ((let ?bindings ?body)
       (let loop ((bindings bindings))
	  (cond
	     ((null? bindings)
	      (only-changing? who formals the-list body))
	     ((only-changing? who formals the-list (cadr (car bindings)))
	      (loop (cdr bindings)))
	     (else
	      #f))))
      ((labels . ?-)
       #f)
      ((failure . ?exps)
       (only-changing*? exps))
      ((bind-exit . ?exps)
       (only-changing*? exps))
      ((apply . ?exps)
       (only-changing*? exps))
      ((typed-case . ?exps)
       #f)
      ((if . ?exps)
       (only-changing*? exps))
      ((?fun . ?args)
       (if (eq? fun who)
	   (let loop ((formals formals)
		      (actuals args))
	      (cond
		 ((null? formals)
		  #t)
		 ((eq? (car formals) the-list)
		  (loop (cdr formals) (cdr actuals)))
		 ((eq? (car actuals) (car formals))
		  (loop (cdr formals) (cdr actuals)))
		 (else
		  #f)))
	   (only-changing*? exp)))))

;*---------------------------------------------------------------------*/
;*    cons-rec->tail-cons-rec ...                                      */
;*    -------------------------------------------------------------    */
;*    Le principe est d'enrober l'ancienne definition dans une         */
;*    nouvelle fonction locale qui contient un parametre               */
;*    supplementaire: l'accumulateur.                                  */
;*---------------------------------------------------------------------*/
(define (cons-rec->tail-cons-rec rec-info)
   (trace tailrec "cons-rec->tail-cons-rec: "
	  (shape (rec-info-function rec-info))
	  #\Newline)
   (trace (tailrec loop) 
	  "   stop-exp: " (shape (rec-info-stop-exp rec-info)) #\Newline
	  "   rec-exp : " (shape (rec-info-rec-exp rec-info))
	  #\Newline)
   (let* ((new-fun      (cdar (allocate-local-functions '(tail-loop))))
	  (the-list     (rec-info-formal rec-info))
	  (accu         (allocate-local-variable (gensym "accu")))
	  (new-list     (allocate-local-variable (gensym "l")))
	  (old-value    (if (local? (rec-info-function rec-info))
			    (local-value (rec-info-function rec-info))
			    (global-value (rec-info-function rec-info))))
	  (old-formals  (function-args old-value))
	  (old-def      (rec-info-definition rec-info))
	  (new-def      `(labels ((,new-fun (,accu ,new-list) ,old-def))
			    (,new-fun ,(abstract-nil) ,the-list))))
      (trace (tailrec loop) "cons-rec->tail-cons-rec (new-def): "
	     (shape new-def) #\Newline)
      (function-arity-set! (local-value new-fun) 2)
      (function-args-set!  (local-value new-fun) (list accu new-list))
      (function-body-set!  (local-value new-fun) new-def)
      ;; il ne reste plus qu'a faire des effets de bords sur les
      ;; expression de fin de recursion et de recursion pour que
      ;; l'affaire soit dans le sac...
      ;; on commence par l'expression de fin de recursion...
      (set-car! (cdr (cadr (rec-info-stop-exp rec-info))) new-list)
      ;; on change la valeur de retour de la fonction
      (set-car! (cddr (rec-info-stop-exp rec-info))
		(abstract 'reverse! accu))
      ;; on fait ensuite la recursion proprement dite
      (let* ((car-exp     (rec-info-car-exp rec-info))
	     (cdr-exp     (rec-info-cdr-exp rec-info))
	     (quoi.par    `((,the-list . ,new-list))))
	 (let ((aux-def (beta-reduce old-def quoi.par)))
	    (set-car! old-def (car aux-def))
	    (set-cdr! old-def (cdr aux-def))
	    (change-recursive-call! old-def
				    (rec-info-function rec-info)
				    new-fun
				    old-formals
				    accu
				    new-list
				    the-list)
	    (trace (tailrec loop)
		   "Apres change-recursive-call!: " (shape old-def) #\Newline)
	    new-def))))
      
;*---------------------------------------------------------------------*/
;*    change-recursive-call! ...                                       */
;*---------------------------------------------------------------------*/
(define (change-recursive-call! exp old-fun new-fun formals
				accu new-list the-list)
   (trace (tailrec loop) "change-recursive-call!: " (shape exp) #\newline)
   (let loop ((exp exp))
      (match-case exp
	 ((atom ?-)
	  exp)
	 ((quote ?-)
	  exp)
	 ((pragma . ?exps)
	  (change-recursive-call*! exps old-fun new-fun
				   formals accu new-list the-list)
	  exp)
	 ((assert . ?exps)
	  (change-recursive-call*! exps old-fun new-fun
				   formals accu new-list the-list)
	  exp)
	 ((begin . ?exps)
	  (change-recursive-call*! exps old-fun new-fun
				   formals accu new-list the-list)
	  exp)
	 ((set! . ?exps)
	  (change-recursive-call*! exps old-fun new-fun
				   formals accu new-list the-list)
	  exp)
	 ((let ?bindings ?body)
	  (let liip ((bindings bindings))
	     (if (null? bindings)
		 (begin
		    (set-car! (cddr exp) (loop body))
		    exp)
		 (let ((binding (car bindings)))
		    (set-car! (cdr binding) (loop (cadr binding)))
		    (liip (cdr bindings))))))
	 ((labels ?bindings ?body)
	  (error "labels"
		 "Illegal expression change-recursive-call!"
		 "internal error"))
	 ((failure . ?exps)
	  (change-recursive-call*! exps old-fun new-fun
				   formals accu new-list the-list)
	  exp)
	 ((bind-exit . ?exps)
	  (change-recursive-call*! exps old-fun new-fun
				   formals accu new-list the-list)
	  exp)
	 ((apply . ?exps)
	  (change-recursive-call*! exps old-fun new-fun
				   formals accu new-list the-list)
	  exp)
	 ((typed-case . ?exps)
	  (error "labels"
		 "Illegal expression change-recursive-call!"
		 "internal error"))
	 ((if . ?exps)
	  (change-recursive-call*! exps old-fun new-fun
				   formals accu new-list the-list)
	  exp)
	 ((?fun . ?args)
	  (if (eq? fun old-fun)
	      (let ((new-exp (cons new-fun
				   (cons accu
					 (let loop ((actuals args)
						    (formals formals))
					    (cond
					       ((null? actuals)
						'())
					       ((eq? (car formals) the-list)
						(list (car actuals)))
					       (else
						(loop (cdr actuals)
						      (cdr formals)))))))))
		 (set-car! exp (car new-exp))
		 (set-cdr! exp (cdr new-exp))
		 new-exp)
	      (begin
		 (change-recursive-call*! exp
					  old-fun
					  new-fun
					  formals
					  accu
					  new-list the-list)
		 exp))))))

;*---------------------------------------------------------------------*/
;*    change-recursive-call*! ...                                      */
;*---------------------------------------------------------------------*/
(define (change-recursive-call*! exps old-fun new-fun formals accu new-list the-list)
   (trace (tailrec loop) "change-recursive-call*!: " (shape exps) #\newline)
   (let loop ((exp* exps))
      (if (null? exp*)
	  exps
	  (begin
	     (set-car! exp*
		       (change-recursive-call! (car exp*)
					       old-fun
					       new-fun
					       formals
					       accu
					       new-list
					       the-list))
	     (loop (cdr exp*))))))
      


