;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Stack/walk.scm ...       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr 27 08:22:03 1994                          */
;*    Last change :  Mon Jul  4 17:35:49 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On transforme des allocations du tas vers des allocations en     */
;*    pile.                                                            */
;*    -------------------------------------------------------------    */
;*    Attention cette passe dans son implementation actuelle doit etre */
;*    juste placee apres Lift car elle utilise le fait que Lift calcule*/
;*    la propriete `kaptured?' pour les variables locales.             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module stack_walk
   (include "Tools/trace.sch"
	    "Var/variable.sch"
	    "Stack/property.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    var_env
	    stack_expression
	    stack_tail)
   (export  (stack-walk tree)))

;*---------------------------------------------------------------------*/
;*    stack-walk ...                                                   */
;*---------------------------------------------------------------------*/
(define (stack-walk tree)
   (verbose "   . Stack" #\Newline)
   (start-partial-error "Stack")
   ;; on reparcours l'arbre pour transformer les allocations
   (for-each (lambda (var)
		(enter-function (shape var))
		(stack-definition! var)
		(leave-function))
	     tree)
   tree)
 
;*---------------------------------------------------------------------*/
;*    stack-definition! ...                                            */
;*---------------------------------------------------------------------*/
(define (stack-definition! var)
   (trace stack
	  "==========================================================="
	  #\newline
	  (shape var) #\Newline
	  "-----------------------------------------------------------"
	  #\newline)
   (let* ((value (cond
		    ((global? var)
		     (global-value var))
		    ((local? var)
		     (local-value var))
		    (else
		     (error "stack-definition!"
			    "Not a variable"
			    (shape var)))))
	  (body (function-body value))
	  (args (function-args value)))
      ;; on memorise la fonction courrante pour `tail'
      (set-current-function! var)
      (reset-stack-statistics!)
      ;; on initialise les champs `info' des arguments.
      (for-each (lambda (arg)
		   (if (not (s-property? (local-info arg)))
		       (local-info-set! arg (default-s-property)))
		   (s-property-depth-set! (local-info arg) 0))
		args)
      ;; on parcours le corps pour transformer les allocations.
      (function-body-set! value (stack-expression! body #t 1))
      ;; un peu de stat
      (trace-stack-statistics)))

      
