;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/bigloo1.7/comptime1.7/Scan/labels.scm ...                */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 22 10:33:20 1993                          */
;*    Last change :  Thu Aug 11 09:43:41 1994 (serrano)                */
;*                                                                     */
;*    On construit les formes `labels'                                 */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module scan_labels
   (include "Var/variable.sch")
   (import  engine_param
	    var_variable
	    scan_lexical
	    heap_abstract
	    scan_tree
	    tools_args)
   (export  (make-labels-tree exp site env)
	    (make-local-tree name tree)
	    (local-debug-name local)))

;*---------------------------------------------------------------------*/
;*    make-labels-tree ...                                             */
;*    -------------------------------------------------------------    */
;*    Attention: Si on apporte des modifs a cette fonction, il faut    */
;*    verifier que la fonction `make-function-casting!' du fichier     */
;*    `foreign/cast.scm' reste correcte.                               */
;*---------------------------------------------------------------------*/
(define (make-labels-tree exp site env)
   (let* ((bindings   (cadr exp))
	  (body       (caddr exp))
	  (body-frame (allocate-local-functions (map car bindings)))
	  (new-env    (append body-frame env)))
      ;; on calcule le body
      (set-car! (cddr exp) (make-expression-tree body site new-env '()))
      ;; on calcule les body de toutes les fonctions locales
      (let loop ((bindings bindings))
	 (if (null? bindings)
	     exp
	     (let* ((local-def      (car bindings))
		    (local-function (cdr (assq (car local-def) new-env)))
		    (local-frame    (allocate-local-variables
				     (cadr local-def))))
		(set-car! local-def local-function)
		(function-arity-set! (local-value local-function)
				     (arity (cadr local-def)))
		(set-car! (cdr local-def) (map cdr local-frame))
		(function-args-set!  (local-value local-function)
				     (cadr local-def))
		(set-car! (cddr local-def) (make-expression-tree
					    (make-local-body
					     (car local-def)
					     (caddr local-def))
					    site
					    (append local-frame new-env)
					    local-function))
		(function-body-set! (local-value local-function)
				    (caddr local-def))
		(set-car! bindings local-def)
		(loop (cdr bindings)))))))
      
;*---------------------------------------------------------------------*/
;*    make-local-body ...                                              */
;*    -------------------------------------------------------------    */
;*    On construit un corps local, c'est a dire qu'on rajoute des      */
;*    traces si on est en mode -g2                                     */
;*---------------------------------------------------------------------*/
(define (make-local-body local body)
   (if *extra-debug*
       `(begin
	   (push-lambda-trace ',(local-debug-name local))
	   (pop-lambda-trace ,body))
       body))

;*---------------------------------------------------------------------*/
;*    make-local-tree ...                                              */
;*    -------------------------------------------------------------    */
;*    On construit un corps local, c'est a dire qu'on rajoute des      */
;*    traces si on est en mode -g2. Cette fonction est la meme que la  */
;*    precedente sauf qu'elle prend un arbre et nom par une s-exp en   */
;*    argument.                                                        */
;*---------------------------------------------------------------------*/
(define (make-local-tree local tree)
   (if *extra-debug*
       `(begin
	   ,(abstract 'push-lambda-trace `',(local-debug-name local))
	   ,(abstract 'pop-lambda-trace tree))
       tree))

;*---------------------------------------------------------------------*/
;*    local-debug-name ...                                             */
;*---------------------------------------------------------------------*/
(define (local-debug-name local)
   (let ((name (local-shape local)))
      (if (string? name)
	  (string->symbol name)
	  name)))
