;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/bigloo1.7/comptime1.7/Scan/alias.scm ...                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Aug 21 11:54:36 1994                          */
;*    Last change :  Sun Aug 21 12:51:26 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La compilation des formes `(define foo bar)'                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module scan_alias
   (include "Var/variable.sch")
   (import  var_env
	    var_declare
	    tools_args
	    scan_definition
	    scan_tree)
   (export  (remember-alias! def tree)
	    (written! var)
	    (fixe-aliases!)))

;*---------------------------------------------------------------------*/
;*    *written* ...                                                    */
;*                                                                     */
;*---------------------------------------------------------------------*/
(define *written*  '())

;*---------------------------------------------------------------------*/
;*    written! ...                                                     */
;*---------------------------------------------------------------------*/
(define (written! var)
   (if (not (memq var *written*))
       (set! *written* (cons var *written*))))

;*---------------------------------------------------------------------*/
;*    *alias* ...                                                      */
;*---------------------------------------------------------------------*/
(define *alias* '())

;*---------------------------------------------------------------------*/
;*    remember-alias! ...                                              */
;*---------------------------------------------------------------------*/
(define (remember-alias! def tree)
   (set! *alias* (cons (cons def tree) *alias*)))

;*---------------------------------------------------------------------*/
;*    fixe-aliases! ...                                                */
;*---------------------------------------------------------------------*/
(define (fixe-aliases!)
   (for-each
    (lambda (def.tree)
       (let* ((def  (car def.tree))
	      (tree (cdr def.tree))
	      (var  (cadr def))
	      (val  (caddr def))
	      (g    (find-in-global-environment val *Genv*))
	      (gd   (find-in-global-environment var *Genv*)))
	  (if (and (eq? (global-class g) 'function)
		   (not (memq var *written*)))
	      ;; voila, c'etait une bonne definition il faut
	      ;; qu'on change le truc
	      (let ((nt (let* ((arity (function-arity (global-value g)))
			       (args  (make-n-proto arity)))
			   (global-class-set! gd 'function)
			   (global-value-set! gd (make-global-function 'normal
								       args))
			   (make-function-tree
			    gd
			    args
			    (if (>=fx arity 0)
				`(begin (,val ,@args))
				`(begin
				    (apply
				     ,val
				     ,(let loop ((args args))
					 (if (not (pair? args))
					     args
					     `(cons ,(car args)
						    ,(loop
						      (cdr args))))))))))))
		 ;; il faut maintenant remplacer physiquement l'ancienne
		 ;; definition par la nouvelle
		 (set-car! tree (car nt))
		 (set-cdr! tree (cdr nt))))))
    *alias*))
		 
		     
   
