;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../parse-args.scm ...                                           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Aug  7 11:47:46 1994                          */
;*    Last change :  Tue Dec 13 08:28:51 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On parse les arguments                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module init_parse-args
   (export  (parse-args args))
   (import  engine_param
	    write_version
	    tools_trace
	    tools_strings
	    tools_speek
	    read_access
	    init_extend))

;*---------------------------------------------------------------------*/
;*    parse-args ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-args args)
   (define extended-done? #f)
   (set! *bigloo-cmd-name* (car args))
   (set! *bigloo-args*     args)
   (let loop ((args (cdr args)))
      (cond
	 ((null? args)
	  (if extended-done?
	      #t
	      (let ((cell (if (not (string? *src*))
			      #f
			      (assoc (suffix *src*) *auto-mode*))))
		 (if cell
		     (loop `("-extend" ,(cdr cell)))
		     #t))))
	 ((not (pair? args))
	  (error "parse-args" "incorrect argument" args))
	 (else
	  (let ((pr (car args)))
	     (cond
;*--- test preliminiaire ----------------------------------------------*/
		((string=? pr "-")
		 (error "parse-args" "incorrect option (use -help)" pr))
;*--- L'aide ----------------------------------------------------------*/
		((or (string=? pr "?") (string=? pr "-help"))
		 ;; L'aide
		 (help))
;*--- la version ------------------------------------------------------*/
		((string=? pr "-version")
		 (short-version)
		 (exit 0))
;*--- query -----------------------------------------------------------*/
		((string=? pr "-query")
		 (query))
;*--- -q --------------------------------------------------------------*/
		((string=? pr "-q")
		 (loop (cdr args)))
;*--- -eval -----------------------------------------------------------*/
		((string=? pr "-eval")
		 (if (null? (cdr args))
		     (error "parse-args"
			    "-eval option require one argument"
			    args)
		     (let ((port (open-input-string (cadr args))))
			(let laap ((exp (read port)))
			   (if (eof-object? exp)
			       (loop (cddr args))
			       (begin
				  (eval exp)
				  (laap (read port))))))))
;*--- le `load-path' --------------------------------------------------*/
		((string=? pr "-I")
		 (if (null? (cdr args))
		     (error "parse-args"
			    "-I option require one argument"
			    args)
		     (begin
			(set! *load-path* (cons (cadr args) *load-path*))
			(loop (cddr args)))))
;*--- Les options de verbosite ----------------------------------------*/
		((string=? pr "-s")
		 ;; Le silence
		 (set! *silent* #t)
		 (set! *verbose* #f)
		 (loop (cdr args)))
		((string=? pr "-v")
		 ;; La verbage
		 (set! *verbose* #t)
		 (loop (cdr args)))
		((string=? pr "-w")
		 ;; les warning
		 (set! *warning* #f)
		 (loop (cdr args)))
;*--- l'option -cc ----------------------------------------------------*/
		((string=? pr "-cc")
		 (if (null? (cdr args))
		     (error "parse-args"
			    "-cc option require one argument"
			    args)
		     (begin
			(set! *cc* (cadr args))
			(loop (cddr args)))))
;*--- -kr-c -----------------------------------------------------------*/
		((string=? pr "-kr-c")
		 (set! *ansi-cc* #f)
		 (loop (cdr args)))
;*--- les options de cc -----------------------------------------------*/
		((string=? pr "-copt")
		 (if (null? (cdr args))
		     (error "parse-args"
			    "-c option require one argument"
			    args)
		     (begin
			(set! *cc-options* (string-append (cadr args)
							  " "
							  *cc-options*))
			(loop (cddr args)))))
;*--- les options de ld -----------------------------------------------*/
		((string=? pr "-ld")
		 (if (null? (cdr args))
		     (error "parse-args"
			    "-ld option require one argument"
			    args)
		     (begin 
			(set! *ld-options* (string-append (cadr args)
							  " "
							  *ld-options*))
			(loop (cddr args)))))
;*--- gcc -------------------------------------------------------------*/
		((string=? pr "-gcc")
		 (set! *gcc* #t)
		 (set! *cc* "gcc")
		 (loop (cdr args)))
;*--- no-inlining -----------------------------------------------------*/
		((string=? pr "-no-inlining")
		 (set! *inlining?* #f)
		 (loop (cdr args)))
;*--- Les options `-f...' ---------------------------------------------*/
		((string=? pr "-farithmetic")
		 (set! *genericity* #f)
		 (loop (cdr args)))
		((string=? pr "-fshared-data")
		 (set! *shared-data* #t)
		 (loop (cdr args)))
		((string=? pr "-fsuperlift")
		 (set! *superlift?* #t)
		 (loop (cdr args)))
		((string=? pr "-fstack")
		 (set! *heap->stack?* #t)
		 (loop (cdr args)))
		((string=? pr "-finline-cons")
		 (set! *optim-cons* #t)
		 (loop (cdr args)))
;*--- La suppression des fichiers C -----------------------------------*/
		((string=? pr "-rm")
		 (set! *rm-c-files* #f)
		 (loop (cdr args)))
		((string=? pr "+rm")
		 (set! *rm-c-files* #t)
		 (loop (cdr args)))
;*--- la sauvegarde d'un environement de compilation ------------------*/
		((string=? pr "-mkheap")
		 (set! *pass* 'make-heap)
		 (loop (cdr args)))
		((string=? pr "+mkheap")
		 (set! *pass* 'make-heap)
		 (set! *heap-append?* #t)
		 (loop (cdr args)))
;*--- call/cc ---------------------------------------------------------*/
		((string=? pr "-call/cc")
		 (set! *call/cc?* #t)
		 (loop (cdr args)))
;*--- char ------------------------------------------------------------*/
		((string=? pr "-char")  
		 (if (null? (cdr args))
		     (error "parse-args"
			    "-char option require one argument"
			    args)
		     (cond
			((string=? (cadr args) "8bit")
			 (set! *rgc-last-char* 255)
			 (loop (cddr args)))
			((string=? (cadr args) "7bit")
			 (set! *rgc-last-char* 127)
			 (loop (cddr args)))
			(else
			 (error "parse-args"
				"illegal argument (see -help)"
				args)))))
;*--- nil -------------------------------------------------------------*/
		((string=? pr "-nil")
		 (set! *nil* #f)
		 (loop (cdr args)))
;*--- -llibrary -------------------------------------------------------*/
		((and (>fx (string-length pr) 2)
		      (string=? (substring pr 0 2) "-l"))
		 (set! *bigloo-user-lib* (cons pr *bigloo-user-lib*))
		 (loop (cdr args)))
;*--- la compilation des modules de librairie -------------------------*/
		((string=? pr "-mklib")
		 (set! *lib-mode* #t)
		 (loop (cdr args)))
;*--- la compilation des modules pour la distribution -----------------*/
		((string=? pr "-mkdistrib")
		 (set! *pass* 'distrib)
		 (loop (cdr args)))
;*--- on change le nom du tas a charger (ou a sauver) -----------------*/
		((string=? pr "-heap")
		 (if (null? (cdr args))
		     (error "parse-args"
			    "-heap option require one argument"
			    args)
		     (begin
			(set! *heap-names* (list (cadr args)))
			(loop (cddr args)))))
;*--- on rajoute un fichier de tas dans ceux qu'on doit charger -------*/
		((string=? pr "+heap")
		 (if (null? (cdr args))
		     (error "parse-args"
			    "+heap option require one argument"
			    args)
		     (begin
			(set! *heap-names* (cons (cadr args) *heap-names*))
			(loop (cddr args)))))
;*--- debug -----------------------------------------------------------*/
		((string=? pr "-g")
		 (set! *debug* #t)
		 (loop (cdr args)))
		((string=? pr "-g2")
		 (set! *debug* #t)
		 (set! *extra-debug* #t)
		 (set! *inlining?* #f)
		 (loop (cdr args)))
		((string=? pr "-g3")
		 (set! *debug* #t)
		 (set! *extra-debug* #t)
		 (set! *assert* #t)
		 (set! *inlining?* #f)
		 (loop (cdr args)))
		((string=? pr "-cg")
		 (set! *rm-c-files* #f)
		 (set! *c-debug* #t)
		 (loop (cdr args)))
;*--- le profiling ----------------------------------------------------*/
		((string=? pr "-pg")
		 (set! *strip* #f)
		 (change-bigloo-lib! "-lbigloo_p")
		 (set! *cc-options* (string-append "-pg " *cc-options*))
		 (loop (cdr args)))
;*--- l'aplha-conversion ----------------------------------------------*/
		((string=? pr "-ALPHA")
		 (set! *alpha* #f)
		 (loop (cdr args)))
		((string=? pr "+ALPHA")
		 (set! *alpha* #t)
		 (loop (cdr args)))
;*--- le mode ERROR ---------------------------------------------------*/
		((string=? pr "-ERROR")
		 (set! *immediat-error* #t)
		 (set! *error-shape* #t)
		 (loop (cdr args)))
;*--- unsafe ----------------------------------------------------------*/
		((and (>fx (string-length pr) 6)
		      (string=? (substring pr 0 7) "-unsafe"))
		 (parse-unsafe-args pr)
		 (loop (cdr args)))
;*--- les optimisations -----------------------------------------------*/
		((and (>fx (string-length pr) 1)
		      (string=? (substring pr 0 2) "-O"))
		 (parse-optim-args pr)
		 (loop (cdr args)))
;*--- les traces inclusives -------------------------------------------*/
		((and (>fx (string-length pr) 1)
		      (string=? (substring pr 0 2) "-t"))
		 (let ((len (string-length pr)))
		    (if (=fx len 2)
			(start-trace 'all 'or)
			(parse-trace-args 'or pr len))
		    (loop (cdr args))))
;*--- les traces exclusives -------------------------------------------*/
		((and (>fx (string-length pr) 1)
		      (string=? (substring pr 0 2) "+t"))
		 (let ((len (string-length pr)))
		    (if (=fx len 2)
			(start-trace 'all 'and)
			(parse-trace-args 'and pr len))
		    (loop (cdr args))))
;*--- Les pass de compilation -----------------------------------------*/
		((string=? pr "-E")
		 ;; on stop apres l'expand
		 (set! *alpha* #f)
		 (set! *pass* 'expand)
		 (loop (cdr args)))
		((string=? pr "-L")
		 ;; on stop apres l'inlining
		 (set! *pass* 'inline)
		 (loop (cdr args)))
		((string=? pr "-U")
		 ;; on stop apres la passe `fuse'
		 (set! *pass* 'fuse)
		 (loop (cdr args)))
		((string=? pr "-USER")
		 ;; on stop apres la passe `user'
		 (set! *pass* 'user)
		 (loop (cdr args)))
		((string=? pr "-T")
		 ;; on stop apres les types
		 (set! *pass* 'type)
		 (loop (cdr args)))
		((string=? pr "-AS")
		 ;; on stop apres les assertions
		 (set! *pass* 'assert)
		 (loop (cdr args)))
		((string=? pr "-0")
		 ;; on stop apres l'analyse de control
		 (set! *pass* '0cfa)
		 (loop (cdr args)))
		((string=? pr "-GS")
		 ;; on stop apres le `superlifting'
		 (set! *pass* 'superlift)
		 (loop (cdr args)))
		((string=? pr "-G")
		 ;; on stop apres le `lambda-lifting'
		 (set! *pass* 'lift)
		 (loop (cdr args)))
		((string=? pr "-K")
		 ;; on stop apres l'allocation des constantes
		 (set! *pass* 'cnst)
		 (loop (cdr args)))
		((string=? pr "-S")
		 ;; on stop apres la transformation heap -> stack
		 (set! *pass* 'stack)
		 (loop (cdr args)))
		((string=? pr "-H")
		 ;; on stop apres la passe de failure.
		 (set! *pass* 'hoist)
		 (loop (cdr args)))
		((string=? pr "-R")
		 ;; on stop apres la passe de common
		 (set! *pass* 'cse)
		 (loop (cdr args)))
		((string=? pr "-B")
		 ;; on stop apres la passe de beta-reduction
		 (set! *pass* 'beta)
		 (loop (cdr args)))
		((string=? pr "-C-")
		 ;; on stop apres l'integration
		 (set! *pass* 'integ)
		 (loop (cdr args)))
		((string=? pr "-C")
		 ;; on stop apres la generation du code C
		 (set! *pass* 'cgen)
		 (loop (cdr args)))
		((string=? pr "-C+")
		 ;; on stop apres l'indentation du code C
		 (set! *pass* 'cindent)
		 (loop (cdr args)))
		((or (string=? pr "-A")
		     (string=? pr "-c"))
		 ;; on stop apres cc
		 (set! *pass* 'cc)
		 (loop (cdr args)))
;*--- L'interprete ----------------------------------------------------*/
		((string=? pr "-i")
		 (set! *interpreter* #t)
		 (loop (cdr args)))
;*--- Le nom du fichier d'access --------------------------------------*/
		((string=? pr "-afile")
		 (if (pair? (cdr args))
		     (begin
			(set! *access-file* (cadr args))
			(loop (cddr args)))
		     (error "parse-args"
			    "one argument required for -afile option"
			    args)))
;*--- Un access -------------------------------------------------------*/
		((string=? pr "-access")
		 (if (and (pair? (cdr args)) (pair? (cddr args)))
		     (begin
			(add-access! (upper-string->symbol (cadr args))
				     (caddr args))
			(loop (cdddr args)))
		     (error "parse-args"
			    "two arguements required for -access option"
			    args)))
;*--- Le nom du module ------------------------------------------------*/
		((string=? pr "-m")
		 (if (pair? (cdr args))
		     (begin
			(set! *module-name* (upper-string->symbol (cadr args)))
			(loop (cddr args)))
		     (error "parse-args"
			    "one argument require for -m option"
			    args)))
;*--- Le nom du main --------------------------------------------------*/
		((string=? pr "-main")
		 (if (pair? (cdr args))
		     (begin
			(set! *main* (upper-string->symbol (cadr args)))
			(loop (cddr args)))
		     (error "parse-args"
			    "one argument require for -main option"
			    args)))
;*--- Le nom du resultat ----------------------------------------------*/
		((string=? pr "-o")
		 (if (null? (cdr args))
		     (error "parse-args"
			    "one argument require for -o option" "")
		     (begin
			(set! *dest* (cadr args))
			(loop (cddr args)))))
;*--- L'extension du compilateur --------------------------------------*/
		((string=? pr "-extend")
		 (set! extended-done? #t)
		 (if (null? (cdr args))
		     (error "parse-args"
			    "one argument require for -o option" "")
		     (begin
			(load-extend (cadr args))
			(if (procedure? *extend-entry*)
			    (loop (*extend-entry* (cddr args)))
			    (loop (cddr args))))))
;*--- les sources -----------------------------------------------------*/
		(else
		 (if (eq? (string-ref pr 0) #\-)
		     (error "parse-args" "Incorrect argument" pr)
		     (let ((len (string-length pr)))
			(if (and (>fx len 2)
				 (eq? (string-ref pr (-fx len 2)) #\.)
				 (eq? (string-ref pr (-fx len 1)) #\o))
			    (begin
			       (set! *o-files*  (cons pr *o-files*))
			       (loop (cdr args)))
			    (if *src*
				(if *interpreter*
				    (loop (cdr args))
				    (begin
				       (set! *rest-args*
					     (cons (car args) *rest-args*))))
				(begin
				   (set! *src* pr)
				   (loop (cdr args))))))))))))))

;*---------------------------------------------------------------------*/
;*    parse-unsafe-args ...                                            */
;*---------------------------------------------------------------------*/
(define (parse-unsafe-args string)
   (let ((len (string-length string)))
      (if (=fx len 7)
	  (begin
	     (change-bigloo-lib! "-lbigloo_u")
	     (set! *strip*          #t)
	     (set! *unsafe-arity*   #t)
	     (set! *unsafe-type*    #t)
	     (set! *unsafe-struct*  #t)
	     (set! *unsafe-range*   #t)
	     (set! *unsafe-version* #t)) 
	  (let liip ((i 7))
	     (if (=fx i len)
		 'done
		 (begin
		    (case (string-ref string i)
		       ((#\r)
			(set! *unsafe-range* #t))
		       ((#\a)
			(set! *unsafe-arity* #t))
		       ((#\t)
			(set! *unsafe-type* #t))
		       ((#\s)
			(set! *unsafe-struct* #t))
		       ((#\v)
			(set! *unsafe-version* #t))
		       (else
			(error "parse-arg" "Illegal -unsafe option" string)))
		    (liip (+fx i 1))))))))

;*---------------------------------------------------------------------*/
;*    change-bigloo-lib! ...                                           */
;*---------------------------------------------------------------------*/
(define (change-bigloo-lib! for)
   (let loop ((lib *bigloo-lib*))
      (cond
	 ((null? lib)
	  'done)
	 ((string=? (car lib) "-lbigloo_p")
	  'done)
	 ((string=? (car lib) "-lbigloo")
	  (set-car! lib for)
	  'done)
	 (else
	  (loop (cdr lib))))))
	 
;*---------------------------------------------------------------------*/
;*    parse-optim-args ...                                             */
;*---------------------------------------------------------------------*/
(define (parse-optim-args string)
   (set! *optim* 1)
   (set! *rgc-compact* 25)
   (if (> (string-length string) 2)
       (case (string-ref string 2)
	  ((#\2)
	   (if (not *c-debug*)
	       (set! *cc-options* (string-append "-O2 " *cc-options*)))
	   (set! *rgc-compact* 0)
	   (set! *optim* 2))
	  ((#\3)
	   (if (not *c-debug*)
	       (set! *cc-options* (string-append "-O2 " *cc-options*)))
	   (set! *optim* 3))
	  ((#\4)
	   (if (not *c-debug*)
	       (set! *cc-options* (string-append "-O2 " *cc-options*)))
	   (set! *optim-cons* #t)
	   (set! *optim* 4))
	  (else
	   (error "parse-arg" "Illegal -O option" string)))
       (if (not *c-debug*)
	   (set! *cc-options* (string-append "-O " *cc-options*)))))

;*---------------------------------------------------------------------*/
;*    parse-trace-args ...                                             */
;*---------------------------------------------------------------------*/
(define (parse-trace-args mode string len)
   (start-trace 'nothing mode)
   (let liip ((i 2))
      (if (=fx i len)
	  'done
	  (begin
	     (case (string-ref string i)
		((#\r)
		 (add-trace-mask 'read))
		((#\e)
		 (set! *pp-env-mode* 'short)
		 (add-trace-mask 'env))
		((#\E)
		 (if (eq? *pp-env-mode* 'long)
		     (set! *pp-env-mode* 'extra-long)
		     (set! *pp-env-mode* 'long))
		 (add-trace-mask 'env))
		((#\i)
		 (add-trace-mask 'init))
		((#\x)
		 (add-trace-mask 'eps))
		((#\l)
		 (add-trace-mask 'inline))
		((#\h)
		 (add-trace-mask 'hoist))
		((#\s)
		 (add-trace-mask 'remove))
		((#\t)
		 (add-trace-mask 'type))
		((#\g)
		 (add-trace-mask 'lift))
		((#\G)
		 (add-trace-mask 'lift)
		 (add-trace-mask 'loop))
		((#\k)
		 (add-trace-mask 'cnst))
		((#\c)
		 (add-trace-mask 'integ))
		((#\C)
		 (add-trace-mask 'cgen))
		((#\o)
		 (add-trace-mask 'other))
		((#\b)
		 (add-trace-mask 'beta))
		((#\w)
		 (add-trace-mask 'effect))
		((#\0)
		 (add-trace-mask '0cfa))
		((#\a)
		 (add-trace-mask 'assert))
		((#\S)
		 (add-trace-mask 'stack))
		(else
		 (error "parse-arg" (if (eq? mode 'or)
					"Illegal -t option"
					"Illegal +t option")
			string)))
	     (liip (+fx i 1))))))

;*---------------------------------------------------------------------*/
;*    query ...                                                        */
;*---------------------------------------------------------------------*/
(define (query)
   (version)
   (newline)
   (print "setups:")
   (newline)
   (print "*cc*                   : " *cc*)
   (print "*cc-options*           : " *cc-options*)
   (print "*ld-options*           : " *ld-options*)
   (print "*bigloo-lib*           : " *bigloo-lib*)
   (print "*bigloo-user-lib*      : " *bigloo-user-lib*)
   (print "*bigloo-user-includes* : " *bigloo-user-includes*)
   (print "*lib-dir*              : " *lib-dir*)
   (print "*include-dir*          : " *include-dir*)
   (print "*include-foreign*      : " *include-foreign*)
   (print "*heap-names*           : " *heap-names*)
   (exit 0))
   
;*---------------------------------------------------------------------*/
;*    help ...                                                         */
;*---------------------------------------------------------------------*/
(define (help)
   (version)
   (print "usage: bigloo [options] [src_name]")
   (newline)
   (print "   src_name         --  The name of the source file")
   (print "   -o <name>        --  Name the output file <name>")
   (print "   -m <name>        --  Set name of current module")
   (print "   -q               --  Do not load an rc file")
   (print "   -I <name>        --  Add <name> to the load path")
   (print "   -s               --  Be silent")
   (print "   -v               --  Be verbose")
   (print "   -i               --  Don't compile but interprete a src-file")
   (print "   -E               --  Stop after the preprocessing stage")
   (print "   -USER            --  Stop after the user pass")
   (print "   -L               --  Stop after the inlining stage")
   (print "   -U               --  Stop after the fuse stage")
   (print "   -T               --  Stop after the type stage")
   (print "   -AS              --  Stop after the assertions stage")
   (print "   -0               --  Stop after the 0cfa stage (+)")
   (print "   -GS              --  Stop after the superlift stage")
   (print "   -G               --  Stop after the lambda-lifting stage")
   (print "   -K               --  Stop after the constant allocation")
   (print "   -S               --  Stop after the stack stage")
   (print "   -H               --  Stop after the hoisting stage")
   (print "   -R               --  Stop after the cse stage")
   (print "   -B               --  Stop after the beta-reduction stage")
   (print "   -C-              --  Stop after the integration stage")
   (print "   -C               --  Do not C compile and produce a .c file")
   (print "   -C+              --  Produce an indented .c file")
   (print "   -[cA]            --  Suppress linking and produce a .o file")
   (print "   -g[23]           --  Produce Bigloo debug informations")
   (print "   -cg              --  Compile C files with debug option")
   (print "   -pg              --  Compile files with profiling option (+)")
   (print " <-/+>ALPHA         --  Don't do or force alpha-conversion")
   (print "   -ERROR           --  Some debugging tools")
   (print "   -unsafe[atrsv]   --  Don't check [type/arity/range/struct/version] at runtime")
   (print "   -O[234]          --  Optimization modes") 
   (print "   -char <7/8>bit   --  The char's size (7 bit or 8 bit)")
   (print "   -nil             --  Evaluate '() as #f in `if' expression")
   (print "   -w               --  Inhibit all warning messages")
   (print "   -copt <string>   --  Invoke cc with <string>")
   (print "   -ld <string>     --  Invoke ld with <string>")
   (print "   -no-inlining     --  Don't inline function")
   (print "   -farithmetic     --  Suppress genericity of arithmetic operators")
   (print "   -fshared-data    --  Attempt to share constant data")
   (print "   -fsuperlift      --  Optimization when producing C code")
   (print "   -fstack          --  Transform heap to stack allocations")
   (print "   -finline-cons    --  full inlining of the `cons' primop (.)")
   (print "   -cc <compiler>   --  Specify the C compiler")
   (print "   -gcc             --  Generate gcc C code (obsolte)")
   (print "   -kr-c            --  Generate `Kernighan & Ritchie' C code")
   (print " <-/+>rm            --  Don't or force removing C file")
   (print "   -afile <f>       --  Set name of the access file")
   (print "   -access <m> <f>  --  Set access between module and file")
   (print "   -llibrary        --  Link with object library")
   (print " <-/+>t<trace-flag> --  Generate a trace file (*)")
   (print "       i : init         e : env          E : env (long)")
   (print "       r : read         x : eps          l : inline")
   (print "       h : hoist        s : remove       t : type")
   (print "       g : lift         G : lift+loop    k : cnst")
   (print "       c : integ        C : cgen         o : other")
   (print "       b : beta         w : effet        0 : 0cfa")
   (print "       a : assert       S : Stack")
   (print "   -call/cc         --  Enable call/cc function")
   (print "   -mklib           --  Compile a library module")
   (print "   -mkheap          --  Build an heap file")
   (print "   +mkheap          --  Append to an heap file")
   (print "   -mkdistrib       --  Compile a main file for a distribution")
   (print "   -heap <name>     --  Specify an heap file")
   (print "   +heap <name>     --  Add an heap file")
   (print "   -eval <string>   --  Evaluate <string>")
   (print "   -query           --  dump the current configuration")
   (print "   -extend <name>   --  Extend the compiler")
   (print "   -version         --  The current release")
   (newline)
   (print " * : only available in developing mode")
   (print " + : not always available")
   (print " . : option enabled in -O3 mode")
   (newline)
   (newline)
   (print "Shell Variables:")
   (print "   - TMPDIR         --  tmp directory (default \"/tmp\")")
   (print "   - BIGLOOLIB      --  libraries' directory")
   (print "   - BIGLOOINCLUDE  --  includes' directory")
   (print "   - BIGLOOHEAP     --  the initial heap size in megabytes (4 Mo by default)")
   (exit 0))
		
	  
	      


