;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/bigloo1.7/comptime1.7/Foreign/declare.scm ...            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jan  3 14:53:55 1994                          */
;*    Last change :  Thu Aug 11 14:09:37 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On declare les types                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module foreign_declare
   (include "Foreign/type.sch"
	    "Tools/trace.sch")
   (import  foreign_tools
	    foreign_atomic
	    tools_args
	    tools_error)
   (export  (declare-integer        id name exp)
	    (declare-char           id name exp)
	    (declare-float          id name exp)
	    (declare-alias          id alias)
	    (declare-pointer        id of)
	    (declare-bound-array    id of min max)
	    (declare-unbound-array  id of)
	    (declare-function       id to-id from-id*)
	    (declare-function/types id to from)
	    (declare-subtype        id name from from->to to->from)
	    (declare-struct/union   id slot name)
	    (all-type-used-defined?)
	    (missing-foreign-type)))

;*---------------------------------------------------------------------*/
;*    declare-integer ...                                              */
;*---------------------------------------------------------------------*/
(define (declare-integer id name exp)
   (trace type "declare-integer: " id " " name " " exp #\Newline)
   (define-subtype (list *long* *foreign*) id (type-name *long*) *long* exp))

;*---------------------------------------------------------------------*/
;*    declare-char ...                                                 */
;*---------------------------------------------------------------------*/
(define (declare-char id name exp)
   (define-subtype (list *char* *foreign*) id (type-name *char*) *char* exp))

;*---------------------------------------------------------------------*/
;*    declare-float ...                                                */
;*---------------------------------------------------------------------*/
(define (declare-float id name exp)
   (define-subtype (list *double* *foreign*) id (type-name *double*) *double* exp))

;*---------------------------------------------------------------------*/
;*    declare-alias ...                                                */
;*---------------------------------------------------------------------*/
(define (declare-alias id exp)
   (trace type "declare-alias: " id " " exp #\Newline)
   (use-type! exp)
   (define-subtype (list (get-type exp) *foreign*) id
      (type-name (get-type exp)) 'alias exp))

;*---------------------------------------------------------------------*/
;*    declare-pointer ...                                              */
;*---------------------------------------------------------------------*/
(define (declare-pointer id of)
   (let ((tof (get-type of)))
      (if (eq? (type-type tof) 'c-foreign-struct)
	  (declare-struct/union* id of)
	  (let* ((c-type (define-subtype (list *foreign*) id
			    (string-append (type-name tof) " *")
			    'c-foreign-pointer
			    tof))
		 (b-type (define-subtype (list *bobj*) (symbol-append 'b id)
			    "obj_t"
			    'b-foreign-pointer
			    c-type)))
	     (type-btype-set! c-type b-type)
	     'done))))

;*---------------------------------------------------------------------*/
;*    declare-unbound-array ...                                        */
;*---------------------------------------------------------------------*/
(define (declare-unbound-array id of)
   (let* ((tof    (get-type of))
	  (c-type (define-subtype (list *foreign*) id
		     (string-append (type-name tof) " *")
		     'c-foreign-unbound-array
		     tof))
	  (b-type (define-subtype (list *bobj*) (symbol-append 'b id)
		     "obj_t"
		     'b-foreign-unbound-array
		     c-type)))
      (type-btype-set! c-type b-type)
      'done))
   
;*---------------------------------------------------------------------*/
;*    declare-bound-array ...                                          */
;*---------------------------------------------------------------------*/
(define (declare-bound-array id of min max)
   (let* ((tof    (get-type of))
	  (c-type (define-subtype (list *foreign*) id
		     (string-append (type-name tof) " *")
		     'c-foreign-bound-array
		     (list tof min max)))
	  (b-type (define-subtype (list *bobj*) (symbol-append 'b id)
		     "obj_t"
		     'b-foreign-bound-array
		     c-type)))
      (type-btype-set! c-type b-type)
      'done))

;*---------------------------------------------------------------------*/
;*    declare-struct/union* ...                                        */
;*---------------------------------------------------------------------*/
(define (declare-struct/union* id of)
   (let* ((c-type  (get-type of))
	  (c-*type (define-subtype (list *foreign*) id
		      (string-append (type-name c-type) " *")
		      'c-foreign-struct*
		      (type-exp c-type)))
	  (b-type  (type-btype c-type)))
      (type-btype-set!  c-*type b-type)
      (type-ptypes-set! c-type  (cons c-*type (type-ptypes c-type)))
      c-*type))

;*---------------------------------------------------------------------*/
;*    declare-struct/union ...                                         */
;*    -------------------------------------------------------------    */
;*    Cette fonction creee trois types, la structure C, la structure   */
;*    Bigloo et *obligatoirement*, un pointer sur la structure.        */
;*---------------------------------------------------------------------*/
(define (declare-struct/union id slot name)
   (let* ((c-type  (define-subtype (list *foreign*) id
		      name
		      'c-foreign-struct
		      slot))
	  (b-type  (define-subtype (list *bobj*) (symbol-append 'b id)
		      "obj_t"
		      'b-foreign-struct
		      c-type)))
      (declare-struct/union* (symbol-append id '*) id)
      (type-btype-set! c-type b-type)
      (let loop ((slot slot))
	 (cond
	    ((null? slot)
	     'done)
	    (else
	     (match-case (car slot)
		((?type (and (? string?) ?name))
		 (use-type! type)
		 (loop (cdr slot)))
		(else
		 (partial-error "parse-type"
				"Illegal type expession"
				slot))))))))

;*---------------------------------------------------------------------*/
;*    declare-function ...                                             */
;*---------------------------------------------------------------------*/
(define (declare-function id to-id from-id*)
   (let* ((to   (get-type to-id))
	  (from (map-on-args! get-type from-id*)))
      (declare-function/types id to from)
      'done))

;*---------------------------------------------------------------------*/
;*    declare-function/types ...                                       */
;*---------------------------------------------------------------------*/
(define (declare-function/types id to from)
   (define-subtype (list *foreign*) id (type-name to)
      'function (cons to from)))

;*---------------------------------------------------------------------*/
;*    declare-subtype ...                                              */
;*---------------------------------------------------------------------*/
(define (declare-subtype id name from from->to to->from)
   (define-subtype (list from) id name 'subtype
      (list from from->to to->from)))

;*---------------------------------------------------------------------*/
;*    *used-type*                                                      */
;*---------------------------------------------------------------------*/
(define *used-type* '())

;*---------------------------------------------------------------------*/
;*    use-type! ...                                                    */
;*---------------------------------------------------------------------*/
(define (use-type! id)
   (if (and (not (type-exists? id))
	    (not (memq id *used-type*)))
       (set! *used-type* (cons id *used-type*))))

;*---------------------------------------------------------------------*/
;*    all-type-used-defined? ...                                       */
;*---------------------------------------------------------------------*/
(define (all-type-used-defined?)
   (let loop ((u *used-type*))
      (cond
	 ((null? u)
	  #t)
	 ((type-exists? (car u))
	  (loop (cdr u)))
	 (else
	  #f))))

;*---------------------------------------------------------------------*/
;*    missing-foreign-type ...                                         */
;*---------------------------------------------------------------------*/
(define (missing-foreign-type)
   (let loop ((u    *used-type*)
	      (res '()))
      (cond
	 ((null? u)
	  res)
	 ((type-exists? (car u))
	  (loop (cdr u) res))
	 (else
	  (loop (cdr u) (cons (car u) res))))))

