;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Type/cast.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 25 08:19:55 1993                          */
;*    Last change :  Tue Jan  4 10:37:38 1994 (serrano)                */
;*                                                                     */
;*    Les fonctions de casting                                         */
;*    -------------------------------------------------------------    */
;*    Ce module se contente de faire les conversion de type. Il ne     */
;*    se preocupe pas de verifier que les types sont correctes. Cette  */
;*    tache est faite ailleurs. Ici, on cast seulement.                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module type_cast
   (include "Tools/trace.sch"
	    "Foreign/type.sch")
   (import  heap_abstract
	    tools_speek
	    tools_error
	    tools_shape
	    foreign_tools
	    type_enforce)
   (export  (cast exp from to)))

;*---------------------------------------------------------------------*/
;*    cast ...                                                         */
;*---------------------------------------------------------------------*/
(define (cast exp from to)
   (trace type "cast: " (type-id from) " -> " (type-id to) " : "
	  (shape exp) #\Newline)
   (if (eq? from to)
       ;; cas simplissime, on ne tortille pas inutilement
       exp
       (let ((casting (find-casting to (type-cast-to from))))
	  (if (not (casting? casting))
	      ;; on ne peut pas faire ce casting c'est donc une erreur
	      (begin
		 (partial-error "cast"
				"Illegal cast"
				(symbol-append (type-id from)
					       '->
					       (type-id to)))
		 exp)
	      ;; oui, on peut faire le casting
	      (let ((check-op (casting-check-op casting))
		    (cast-op  (casting-cast-op  casting)))
		 (cast-op (check-op exp)))))))

