;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Inline/walk.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 22 16:09:58 1993                          */
;*    Last change :  Wed Nov 10 11:45:57 1993 (serrano)                */
;*                                                                     */
;*    On inline l'arbre de syntaxe abstraite                           */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module inline_walk
   (include "Tools/trace.sch"
	    "Var/variable.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    tools_progn
	    inline_call)
   (export  (inline-walk tree)
	    (do-inline   exp level stack)))

;*---------------------------------------------------------------------*/
;*    inline-walk ...                                                  */
;*---------------------------------------------------------------------*/
(define (inline-walk tree)
    (verbose "   . Inline" #\Newline)
    (start-partial-error "Inline")
    (let loop ((walk tree))
       (if (null? walk)
	   (begin
	      (fail-if-partial-error)
	      tree)
	   (let ((var (car walk)))
	      (enter-function (shape var))
	      (function-body-set! (global-value var)
				  (do-inline (function-body (global-value var))
					     0
					     (list var)))
	      (leave-function)
	      (loop (cdr walk))))))

;*---------------------------------------------------------------------*/
;*    do-inline ...                                                    */
;*---------------------------------------------------------------------*/
(define (do-inline exp level stack)
   (trace inline "inline: " (shape exp) #\Newline "level: " level #\Newline)
   (match-case exp
;*--- nil -------------------------------------------------------------*/
      (()
       exp)
;*--- atom ------------------------------------------------------------*/
      ((atom ?atom)
       exp)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       exp)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       exp)
;*--- assert ----------------------------------------------------------*/
      ((assert ?- ?- ?body)
       (set-car! (cdddr exp) (do-inline body level stack))
       exp)
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (let loop ((hook body))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (do-inline (car hook) level stack))
		 (loop (cdr hook))))))
;*--- set! ------------------------------------------------------------*/
      ((set! ?var ?val)
       (set-car! (cddr exp) (do-inline val level stack))
       exp)
;*--- let -------------------------------------------------------------*/
      (((or let letrec) ?bindings ?body)
       (trace inline "let : ... ")
       (let loop ((hook bindings))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (do-inline body level stack))
		 exp)
	      (begin      
		 (set-car! (cdar hook) (do-inline (cadr (car hook)) level stack))
		 (loop (cdr hook))))))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (let loop ((hook bindings))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (do-inline body level stack))
		 exp)
	      (begin
		 (set-car! (cddar hook) (do-inline (caddr (car hook))
						   level stack))
		 (loop (cdr hook))))))
;*--- failure ---------------------------------------------------------*/
      ((failure ?proc ?msg ?obj)
       (set-car! (cdr exp) (do-inline proc level stack))
       (set-car! (cddr exp) (do-inline msg level stack))
       (set-car! (cdddr exp) (do-inline obj level stack))
       exp)
;*--- bind-exit -------------------------------------------------------*/
      ((bind-exit (?-) ?body)
       (set-car! (cddr exp) (do-inline body level stack))
       exp)
;*--- apply -----------------------------------------------------------*/
      ((apply ?proc ?arg)
       (set-car! (cdr exp) (do-inline proc level stack))
       (set-car! (cddr exp) (do-inline arg level stack))
       exp)
;*--- case ------------------------------------------------------------*/
      ((case ?test . ?clauses)
       (set-car! (cdr exp) (do-inline test level stack))
       (let loop ((hook clauses))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! (cdr (car hook)) (do-inline (cadr (car hook))
						       level stack))
		 (loop (cdr hook))))))
;*--- if --------------------------------------------------------------*/
      ((if ?si ?alors ?sinon)
       (set-car! (cdr exp) (do-inline si level stack))
       (set-car! (cddr exp) (do-inline alors level stack))
       (set-car! (cdddr exp) (do-inline sinon level stack))
       exp)
;*--- atom-application ------------------------------------------------*/
      (((atom ?function) . ?args)
       (if (inline-function? function level stack)
	   (inline-call exp level stack)
	   (let loop ((hook args))
	      (if (null? hook)
		  exp
		  (begin
		     (set-car! hook (do-inline (car hook) level stack))
		     (loop (cdr hook)))))))
;*--- application -----------------------------------------------------*/
      (else
       (let loop ((hook exp))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (do-inline (car hook) level stack))
		 (loop (cdr hook))))))))

