;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Expand/case.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul  3 10:13:16 1992                          */
;*    Last change :  Tue Dec 14 16:35:59 1993 (serrano)                */
;*                                                                     */
;*    On macro-expanse ce satane-case                                  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_case
   (import  tools_progn
	    tools_error
	    engine_param
	    foreign_atomic)
   (export  (expand-case x e)))
	   
;*---------------------------------------------------------------------*/
;*    expand-case ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-case x e)
   (match-case x
      ((?- ?value . ?clauses)
       (case (case-type clauses)
	  ((integer)
	   (do-typed-case *int* value clauses e))
	  ((char)
	   (do-typed-case *char* value clauses e))
	  (else
	   (do-generic-case value clauses e))))
   (else
    (partial-error "case" "Illegal `case' form" x))))

;*---------------------------------------------------------------------*/
;*    case-type ...                                                    */
;*    < datum+ x sexp+ >+ --> integer @ char @ symbol @ etherogeneous  */
;*    -------------------------------------------------------------    */
;*    On cherche a savoir si on va poouvoir coder ce case comme un     */
;*    `switch' ou s'il va falloir le coder comme un `if'. On ne peut   */
;*    utiliser un `switch' que si tous les datums sont des constantes. */
;*    -------------------------------------------------------------    */
;*    On profite de cette fonction pour s'assurer que chacune des      */
;*    clauses a la bonne syntaxe.                                      */
;*---------------------------------------------------------------------*/
(define (case-type clauses)
   (labels ((type-match? (type1 type2) (or (null? type1)
					   (null? type2)
					   (and (not (eq? type1 'fail-type))
						(eq? type1 type2))))
	    (one-type    (datum) (cond
				    ((integer? datum)
				     'integer)
				    ((char? datum)
				     'char)
				    ((symbol? datum)
				     'symbol)
				    (else
				     'fail-type)))
	    (datum-type  (datums) (let loop ((datums datums)
					     (type   '()))
				     (cond
					((null? datums)
					 type)
					((not (pair? datums))
					 (partial-error "case"
							"Illegal `case' form"
							clauses)
					 #f)
					(else
					 (let ((dtype (one-type (car datums))))
					    (if (type-match? dtype type)
						(loop (cdr datums)
						      dtype)
						'fail-type)))))))
      (let loop ((clauses clauses)
		 (type    '()))
	 (if (null? clauses)
	     type
	     (match-case (car clauses)
		((else . ?exps)
		 (if (not (null? (cdr clauses)))
		     (partial-error "case" "Illegal `case' form" clauses)
		     type))
		(((and (not ()) ?datum) . ?exps)
		 (let ((dtype (datum-type datum)))
		    (if (type-match? dtype type)
			(loop (cdr clauses) dtype)
			'etherogeneous)))
		(else
		 (partial-error "case" "Illegal `case' form" clauses)))))))

;*---------------------------------------------------------------------*/
;*    do-typed-case ...                                                */
;*    type x sexp x < datum+ x sexp+ >+ x (sexp x sexp --> sexp)       */    
;*---------------------------------------------------------------------*/
(define (do-typed-case type value clauses e)
   (let* ((else-body (let loop ((clauses clauses))
			(if (null? clauses)
			    #f
			    (match-case (car clauses)
					(()
					 #f)
					((else . ?body)
					 (e (normalize-progn body) e))
					(else
					 (loop (cdr clauses)))))))
	  (else-name (gensym "case-else")))
      (let ((case `(typed-case
		    ,type
		    aux
		    ,@(let loop ((clauses clauses))
			 (if (null? clauses)
			     (begin
				`((else ,#f)))
			     (match-case (car clauses)
				(() 
				 `((else #f)))
				((else . ?body)
				 `((else ,(if *unsafe-type*
					      else-body
					      `(,else-name)))))
				((?datums . ?body)
				 (cons `(,datums ,(e (normalize-progn body) e))
				       (loop (cdr clauses))))
				(else
				 (partial-error "case"
						"Illegal `case' form"
						clauses))))))))
	 (type-test type value case else-body else-name e))))

;*---------------------------------------------------------------------*/
;*    type-test ...                                                    */
;*---------------------------------------------------------------------*/
(define (type-test type value case else-body else-name e)
   (if *unsafe-type*
       `(let ((aux ,(e value e)))
	   ,case)
       (cond
	  ((eq? type *char*)
	   `(labels ((,else-name () ,else-body))
		    (let ((aux ,value))
		       (if (char? aux)
			   ,case
			   (,else-name)))))
	  ((eq? type *int*)
	   `(labels ((,else-name () ,else-body))
		    (let ((aux ,value))
		       (if (integer? aux)
			   ,case
			   (,else-name)))))
	  (else
	   (error "type-test" "Unknown `case' type" type)))))

;*---------------------------------------------------------------------*/
;*    do-generic-case ...                                              */
;*    sexp x < datum+ x sexp+ >+ x (sexp x sexp --> sexp)              */  
;*---------------------------------------------------------------------*/
(define (do-generic-case value clauses e)
   (e `(let ((case-value ,value))
	  ,(let loop ((clauses clauses))
	      (if (null? clauses)
		  #f
		  (match-case (car clauses)
		     (()
		      #f)
		     ((else . ?body)
		      (normalize-progn body))
		     (((and ?datums (?- . (?- ???-))) . ?body)
		      `(if (memq case-value ',datums)
			   ,(normalize-progn body)
			   ,(loop (cdr clauses))))
		     (((?datums) . ?body)
		      `(if (eq? case-value ',datums)
			   ,(normalize-progn body)
			   ,(loop (cdr clauses))))))))
      e))



	  
