;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/work/Pp/Pp/pp.scm ...                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Nov 27 14:10:31 1993                          */
;*    Last change :  Mon Dec  6 08:25:49 1993 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On imprime une representation                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __pp
   (import (__pp-find-rep "Pp/find-rep.scm")
	   (__pp-make-rep "Pp/make-rep.scm"))
   (export (pp exp . port)
	   *pp-width*
	   *pp-case*
	   *pp-optimize*))
 
;*---------------------------------------------------------------------*/
;*    the *pp-case* ...                                                */
;*---------------------------------------------------------------------*/
(define *pp-case* 'respect)

;*---------------------------------------------------------------------*/
;*    *pp-width* ...                                                   */
;*---------------------------------------------------------------------*/
(define *pp-width* 80)

;*---------------------------------------------------------------------*/
;*    *pp-optimize* ...                                                */
;*---------------------------------------------------------------------*/
(define *pp-optimize* 0)

;*---------------------------------------------------------------------*/
;*    pp ...                                                           */
;*---------------------------------------------------------------------*/
(define (pp exp . port)
   (let ((port (if (null? port)
		   (current-output-port)
		   (let ((port (car port)))
		      (if (not (output-port? port))
			  (error "pp" "not an input-port" port)
			  port)))))
      (output-rep (find-rep (make-rep exp)) port)))

;*---------------------------------------------------------------------*/
;*    output-rep ...                                                   */
;*---------------------------------------------------------------------*/
(define (output-rep rep port)
   (define (output-tab old-col indent-col)
      (newline port)
      (display (make-string (+fx old-col indent-col) #\space) port)
      (+fx old-col indent-col))
   (let loop ((rep    (reverse rep))
	      (indent (list 0))
	      (cursor 0))
      (match-case rep
	 (()
	  'done)
	 ((#\( . ?-)
	  (write-char (car rep) port)
	  (loop (cdr rep)
		(cons cursor indent)
		(+fx cursor 1)))
	 ((#\) . ?-)
	  (write-char (car rep) port)
	  (loop (cdr rep)
		(cdr indent)
		(+fx cursor 1)))
	 (((? char?) . ?-)
	  (write-char (car rep) port)
	  (loop (cdr rep)
		indent
		(+fx cursor 1)))
	 (((char ?c) . ?-)
	  (write c port)
	  (loop (cdr rep)
		indent
		(+fx cursor 3)))
	 (((? string?) . ?-)
	  (display (car rep) port)
	  (loop (cdr rep)
		indent
		(+fx (string-length (car rep)) cursor)))
	 (((comment ?str) . ?rest)
	  (display str port)
	  (loop (match-case rest
		   (((tab ?-) . ?-)
		    (cdr rep))
		   (else
		    (cons '(tab 0) (cdr rep))))
		indent
		(+fx (string-length str) cursor)))
	 (((mark-tab) . ?-)
	  (set-car! indent cursor)
	  (loop (cdr rep)
		indent
		cursor))
	 (((tab ?n) . ?-)
	  (loop (cdr rep)
		indent
		(output-tab (car indent) n)))
	 (else
	  (error "output-rep" "Illegal form" rep)))))
	  
       
