;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../expd-define.scm ...                                          */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jan  4 17:14:30 1993                          */
;*    Last change :  Fri Sep 24 12:03:28 1993 (serrano)                */
;*                                                                     */
;*    Les expanseurs des formes `define's et `lambda'                  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_define
   (import (__expander "Llib/expander.scm"))
   (export (expand-eval-lambda x e)
	   (expand-eval-define x e)
	   (expand-eval-define-inline x e)))

;*---------------------------------------------------------------------*/
;*    expand-eval-lambda ...                                           */
;*---------------------------------------------------------------------*/
(define (expand-eval-lambda x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let ((res (match-case x
		    ((?- ?args . ?body)
		     (let ((e (internal-begin-expander e)))
			`(lambda ,args
			    ,(e (normalize-progn body) e))))
		    (else
		     (error "lambda" "Illegal form" x)))))
	 (set! internal-definition? old-internal)
	 res)))

;*---------------------------------------------------------------------*/
;*    internal-definition? ...                                         */
;*---------------------------------------------------------------------*/
(define internal-definition? #f)

;*---------------------------------------------------------------------*/
;*    expand-eval-define ...                                           */
;*    -------------------------------------------------------------    */
;*    on divise en deux sous:                                          */
;*       1- on define une lambda.                                      */
;*       2- on define une valeur (autre qu'un lambda).                 */
;*---------------------------------------------------------------------*/
(define (expand-eval-define x e)
   (if internal-definition?
       (expand-eval-internal-define x e)
       (expand-eval-external-define x e)))

;*---------------------------------------------------------------------*/
;*    expand-eval-internal-define ...                                  */
;*---------------------------------------------------------------------*/
(define (expand-eval-internal-define x e)
      (match-case x
      ;; 1- on definit une lambda typee
      ((?- ((?type ?name) . ?args) . ?body)
       `(define (,type ,name) (lambda ,args ,(e (normalize-progn body)
						e))))
      ;; 1- on definit une lambda non typee
      ((or (?- (?name . ?args) . ?body)
	   (?- ?name (lambda ?args . ?body)))
       `(define ,name (lambda ,args ,(e (normalize-progn body)
					e))))
      ;; 2- on definit une valeur non typee
      ((?- ?name . (?value . ()))
      `(define ,name ,(e value e)))
      ;; 2b- on definit une valeur typee
      (else
       (error "define" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    internal-begin-expander ...                                      */
;*---------------------------------------------------------------------*/
(define (internal-begin-expander old-expander)
   (lambda (expr expander)
      (match-case expr
	 ((begin)
	  (error 'begin "Illegal form" expr))
	 ((begin . ?rest)
	  `(begin ,@(lambda-defines
		     (map (lambda (x) (expander x expander))
			  rest))))
	 (else
	  (old-expander expr expander)))))
				 
;*---------------------------------------------------------------------*/
;*    lambda-defines ...                                               */
;*---------------------------------------------------------------------*/
(define (lambda-defines body)
    (let loop ((oldforms  body)
	       (newforms '())
	       (vars     '())
	       (sets     '()))
       (if (pair? oldforms)
	   (let ((form (car oldforms)))
	      (cond ((or (not (pair? form))
			 (not (eq? (car form) 'define)))
		     (loop (cdr oldforms)
			   (cons form newforms)
			   vars sets))
		    (else
		     (loop (cdr oldforms) newforms
			   (cons (cadr form) vars)
			   (cons `(set! ,(cadr form) ,(caddr form))
				 sets)))))
	   (if (not (null? vars))
	       `(((lambda ,vars (begin ,@(reverse sets) ,@(reverse newforms)))
		  ,@(vector->list (make-vector (length vars) 0))))
	       body))))

;*---------------------------------------------------------------------*/
;*    expand-eval-external-define ...                                  */
;*---------------------------------------------------------------------*/
(define (expand-eval-external-define x e)
   (set! internal-definition? #t)
   (let ((e (internal-begin-expander e)))
      (let ((res  (if (and (pair? x) (pair? (cdr x)) (pair? (cddr x)))
		      (let ((type (cadr x)))
			 (if (pair? type)
			     `(define ,(car type)
				 (lambda ,(cdr type)
				    ,(e (normalize-progn (cddr x)) e)))
			     `(define ,type
				 ,(e (normalize-progn (cddr x)) e))))
		      (error "define" "Illegal form" x))))
	 (set! internal-definition? #f)
	 res)))

;*---------------------------------------------------------------------*/
;*    expand-eval-define-inline ...                                    */
;*---------------------------------------------------------------------*/
(define (expand-eval-define-inline x e)
   (match-case x
      ((?- (?fun . ?formals) . ?body)
       `(define ,fun
	   (lambda ,formals ,(e (normalize-progn body) e))))
      (else
       (error "define-inline" "Illegal form" x))))

