/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.6/Clib/control.c ...        */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Mon Apr  5 19:00:50 1993                          */
/*    Last change :  Mon May 16 16:27:19 1994 (serrano)                */
/*                                                                     */
/*    La manipulation des fermetures (allocation, application) ...     */
/*=====================================================================*/
#include <bigloo.h>
#include <varargs.h>

/*---------------------------------------------------------------------*/
/*    make_fx_procedure ...                                            */
/*---------------------------------------------------------------------*/
obj_t
make_fx_procedure( entry, arity, size )
obj_t (*entry)();
long arity, size;
{
   obj_t a_procedure, aux;

   a_procedure = MAKE_OBJECT( PROCEDURE_SIZE + ((size - 1) * OBJ_SIZE),
                              HEADER_PROCEDURE, aux );

   a_procedure->procedure_t.entry = entry;
   a_procedure->procedure_t.arity = arity;
   return BREF( a_procedure );
}

/*---------------------------------------------------------------------*/
/*    make_procedure ...                                               */
/*---------------------------------------------------------------------*/
obj_t
make_procedure( entry, arity, size )
obj_t (*entry)();
obj_t arity, size;
{
   return make_fx_procedure( entry, CINT( arity ), CINT( size ) );
}

/*---------------------------------------------------------------------*/
/*    make_light_procedure ...                                         */
/*---------------------------------------------------------------------*/
obj_t
make_light_procedure( entry, size )
obj_t (*entry)();
long size;
{
   obj_t a_procedure;

   a_procedure = ALLOCATE( PROCEDURE_LIGHT_SIZE + ((size - 1)*OBJ_SIZE) );

   a_procedure->procedure_light_t.entry = entry;

   return BLIGHT( a_procedure );
}

/*---------------------------------------------------------------------*/
/*    make_extra_light_procedure ...                                   */
/*---------------------------------------------------------------------*/
obj_t
make_extra_light_procedure( size )
long size;
{
   obj_t a_procedure;

   a_procedure = ALLOCATE( PROCEDURE_EXTRA_LIGHT_SIZE+((size - 1)*OBJ_SIZE) );

   /* on decale toute la structure afin de pouvoir avoir */
   /* la compatibilite avec les procedures normales.     */
   return a_procedure;
}

/*---------------------------------------------------------------------*/
/*    va_generic_entry ...                                             */
/*    -------------------------------------------------------------    */
/*    Tous les tests d'arite ont ete expanses `inline'. On n'a plus    */
/*    qu'a faire l'appel.                                              */
/*---------------------------------------------------------------------*/
obj_t
va_generic_entry( va_alist )
va_dcl
{
   va_list argl;
   obj_t   proc;
   long    arity;
   long    require;
   obj_t   arg[ 16 ];
   obj_t   optional;
   obj_t   runner;
   long    i;
      
   va_start( argl );
   
   proc   = va_arg( argl, obj_t );
   arity  = PROCEDURE_ARITY( proc );
   require = -arity - 1;
   
   for( i = 0; i < require; i++ )
      arg[ i ] = va_arg( argl, obj_t );

   if( (runner = va_arg( argl, obj_t )) != BEOA )
   {
      obj_t tail;
      
      optional = tail = MAKE_PAIR( runner, BNIL );
      
      while( (runner = va_arg( argl, obj_t )) != BEOA )
      {
         SET_CDR( tail, MAKE_PAIR( runner, BNIL ) );
         tail = CDR( tail );
      }
   }
   else
      optional = BNIL;

   va_end( argl );
   
#define CALL( proc ) ((obj_t (*)())PROCEDURE_VA_ENTRY( proc ))      
   switch( arity )
   {
      case -1  : return CALL( proc )(proc, optional);
      case -2  : return CALL( proc )(proc, arg[ 0 ], optional);
      case -3  : return CALL( proc )(proc, arg[ 0 ], arg[ 1 ], optional);
      case -4  : return CALL( proc )(proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                      optional);
      case -5  : return CALL( proc )(proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], optional);
      case -6  : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], optional);
      case -7  : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     optional);
      case -8  : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], optional);
      case -9  : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], optional);
      case -10 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     optional);
      case -11 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], optional);
      case -12 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], arg[ 10 ], optional);
      case -13 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], arg[ 10 ], arg[ 11 ],
                                     optional);
      case -14 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], arg[ 10 ], arg[ 11 ],
                                     arg[ 12 ], optional);
      case -15 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], arg[ 10 ], arg[ 11 ],
                                     arg[ 12 ], arg[ 13 ], optional);
      case -16 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], arg[ 10 ], arg[ 11 ],
                                     arg[ 12 ], arg[ 13 ], arg[ 14 ],
                                     optional);
      case -17 : return CALL( proc )( proc, arg[ 0 ], arg[ 1 ], arg[ 2 ],
                                     arg[ 3 ], arg[ 4 ], arg[ 5 ],
                                     arg[ 6 ], arg[ 7 ], arg[ 8 ],
                                     arg[ 9 ], arg[ 10 ], arg[ 11 ],
                                     arg[ 12 ], arg[ 13 ], arg[ 14 ],
                                     arg[ 15 ], optional);
      
      default: c_error( "too many arguments provided in funcall",
                            "",
                            ETARGS );
   }
   return BNIL;
}
   
/*---------------------------------------------------------------------*/
/*    make_va_procedure ...                                            */
/*---------------------------------------------------------------------*/
obj_t
make_va_procedure( entry, arity, size )
obj_t (*entry)();
long arity, size;
{
   obj_t a_procedure, aux;

   a_procedure = MAKE_OBJECT( PROCEDURE_SIZE + ((size - 1) * OBJ_SIZE),
                              HEADER_PROCEDURE, aux );

   a_procedure->procedure_t.entry    = va_generic_entry; 
   a_procedure->procedure_t.va_entry = entry;
   a_procedure->procedure_t.arity    = arity;
   return BREF( a_procedure );
}

