;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/vital.scm ...                */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Nov  2 17:35:36 1992                          */
;*    Last change :  Tue Jan 11 09:29:40 1994 (serrano)                */
;*                                                                     */
;*    On tests les choses qui sont vraiment vital et sans lesquelles   */
;*    on ne peut rien faire du tout.                                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module vital
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-vital))
   (static  var))

;*---------------------------------------------------------------------*/
;*    var ...                                                          */
;*---------------------------------------------------------------------*/
(define var var)

;*---------------------------------------------------------------------*/
;*    bar ...                                                          */
;*---------------------------------------------------------------------*/
(define (bar . l)
   l)

(set! bar 'toto)

;*---------------------------------------------------------------------*/
;*    foo ...                                                          */
;*---------------------------------------------------------------------*/
(define (foo x)
   (if (integer? x)
       (begin
	  (set! x #f)
	  (integer? x))
       #t))
 
;*---------------------------------------------------------------------*/
;*    test-vital ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-vital)
   (test-module "vital" "vital.scm" #f)
   (test "true" #t (not #f))
   (test "true" #t (not (not 4)))
   (test "true" (not (eq? #t #f)) (not #f))
   (test "false" #f (not #t))
   (test "begin" (begin 4 5) 5)
   (test "eq?" 1 1)
   (test "< 0" -1 -1)
   (test "-" (- 2) -2)
   (test "*" (* 2 -1) -2)
   (test "eq? char" (eq? #\a #\a) #t)
   (test "eq? char" (eq? #\a #\A) #F)
   (test "eq? char" (char->integer #\') 39)
   (test "eq? symbol" (eq? 'a 'a) #t)
   (test "eq? symbol" (eq? 'a 'A) #t)
   (test "eq? symbol" (eq? 'a 'b) #f)
   (test "define" bar 'toto)
   (test "application" ((lambda args 2)) 2)
   (test "application" ((lambda args 2) 1 2 3 4) 2)
   (test "set!" (foo 5) #f)
   (test "set!" (let ((v (integer? var))) (set! var 4) v) #f)
   (test "symbol" 't (string->symbol "T")))


	 



 
