;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Var/variable.sch ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 09:23:41 1993                          */
;*    Last change :  Tue May 31 18:00:12 1994 (serrano)                */
;*                                                                     */
;*    Les structures des variables utilisees pendant toutes les        */
;*    passes d'une compilation                                         */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Il existe plusieurs types de variables:                          */
;*       - Les variables `global'                                      */
;*       - Les variables `local'                                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    global ...                                                       */
;*---------------------------------------------------------------------*/
(define-struct global
   name          ;; symbol      : le nom de la variable sans pretty-print
   module        ;; symbol      : le nom du module d'appartenance.
   c-name        ;; string      : le nom C de la variable.
   import        ;; { static, export, import, top-level, foreign }
   class         ;; { variable, function, foreign }
   library?      ;; { t, f }    : est-ce une fonction de la librairie ?
   value         ;; ???         : la valeur des constantes
   pragma        ;; ???         : des info pour les fonction de la lib.
   info)         ;; ???         : ce champs est utilise par toutes les passes

;*---------------------------------------------------------------------*/
;*    local ...                                                        */
;*---------------------------------------------------------------------*/
(define-struct local
   name          ;; symbol      : le nom de la variable sans pretty-print
   key           ;; integer     : une cle d'identification
   class         ;; { variable, function, return }
   value         ;; ???         : la valeur des constantes
   info          ;; ???         : ce champs est utilise par toutes les passes
   access        ;; { read, write }
   type)         ;; type        : le type des variables (defaut: *bobj*)
   
;*---------------------------------------------------------------------*/
;*    Les constantes peuvent avoir plusieurs valeurs:                  */
;*       - `function'                                                  */
;*       - `macro'                                                     */
;*       - `foreign'                                                   */
;*       - `return'                                                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    function ...                                                     */
;*    -------------------------------------------------------------    */
;*    Remarque: le champs `invocations' compte le nombre de fois       */
;*    qu'une fonction est appellee. Ce nombre est ajuste dans la       */
;*    passe `Scan' et il est utilise par les passes `Inline' et        */
;*    `Superlift'. La passe `Inline' ne le decremente pas quand        */
;*    une fonction est inlinee sur une invocation.                     */
;*---------------------------------------------------------------------*/
(define-struct function
   inline?       ;; { t, f }    : est-ce une inline ?
   property      ;; property*   : une liste de propriete
   arity         ;; integer     : l'arite de la fonction
   args          ;; local*      : les arguments d'une fonction
   body          ;; s-exp       : le corps.
   info          ;; ???         : des infos, pass dependant.
   escape?       ;; { t, f }    : cette fonction s'enfuie-t-elle ?
   the-closure   ;; variable    : la variable fermeture
   type-res      ;; type        : le type du resultat (defaut: *bobj*)
   invocations)  ;; integer     : le nombre d'invocation

;*---------------------------------------------------------------------*/
;*    return ...                                                       */
;*---------------------------------------------------------------------*/
(define-struct return
   args          ;; local*      : les arguments d'un return
   body          ;; s-exp       : le corps.
   escape?       ;; { t, f }    : ce return s'enfuie-t-il ?
   the-continue) ;; variable    : la variable de continuation

;*---------------------------------------------------------------------*/
;*    foreign ...                                                      */
;*---------------------------------------------------------------------*/
(define-struct foreign
   class         ;; { function, variable, macro-function, macro-cnst }
   type)         ;; type        : le type de cette foreign
   
