;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Var/env.scm ...          */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jun 15 08:35:31 1992                          */
;*    Last change :  Fri Mar 19 09:45:11 1993  (serrano)               */
;*                                                                     */
;*    La creation des environments locaux et globaux                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    L'utilsation des environment se fait comme suit:                 */
;*       - Les variables globales sont rangees dans un environment:    */
;*         Genv                                                        */
;*       - Chaque variable globale qui est une fonction possede un     */
;*         pointeur sur un environement local: Lenv                    */
;*         Les Lenv sont representes par des listes                    */
;*                                                                     */
;*     Genv:                                                           */
;*     +-----------------------------------------------------------+   */
;*     |Var X|     |Var Y|     |  . . . .  |Var Z|     |     |     |   */
;*     +-----------------------------------------------------------+   */
;*        |           |                       |                        */
;*        v           v                       |                        */
;*     +-----+     +-----+                    v                        */
;*     |Lenv |     |Lenv |                                             */
;*     |-----|     |-----|                                             */
;*     .     .     .     .                                             */
;*     |     |     |     |                                             */
;*     +-----+     +-----+                                             */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module var_env
   (import  tools_hash
	    var_variable
	    expand_expander)
   (include "Var/variable.sch"
	    "Expand/expander.sch")
   (export  *Genv*
	    *Menv*
	    *Oenv*
	    (init-global-environment!)
	    (pp-global-environment port env)
	    (bind-in-global-environment! name Genv)
	    (find-in-global-environment  name Genv)
	    (unbind-in-global-environment! name Genv)))

;*---------------------------------------------------------------------*/
;*    Les trois environement globaux utilises lors de toute la         */
;*    compilation. Voici a quoi ils servent:                           */
;*       . *Genv* : environement dans lequel on range toutes les       */
;*                  variables globales scheme.                         */
;*       . *Menv* : environement dans lequel on range les macros.      */
;*       . *Oenv* : enviroenment dans lequel on range les macros       */
;*                  ecrasables (voir Expand/eps.scm).                  */
;*---------------------------------------------------------------------*/
(define *Genv* '())
(define *Menv* '())
(define *Oenv* '())

;*---------------------------------------------------------------------*/
;*    init-global-environment! ...                                     */
;*---------------------------------------------------------------------*/
(define (init-global-environment!)
   (set! *Menv* (make-macro-environment))
   (set! *Oenv* (make-macro-environment))
   (set! *Genv* (make-global-environment)))

;*---------------------------------------------------------------------*/
;*    make-macro-environment ...                                       */
;*---------------------------------------------------------------------*/
(define (make-macro-environment)
   (let ((env (make-hash-table 'Genv
			       'symbol
			       expander-create
			       expander-name
			       expander-pp)))
      (if (not (hashtable? env 'Genv))
	  (error "make-Genv" "Can't build Genv" env)
	  env)))

;*---------------------------------------------------------------------*/
;*    make-global-environment ...                                      */
;*---------------------------------------------------------------------*/
(define (make-global-environment)
   (let ((env (make-hash-table 'Genv
			       'symbol
			       global-create
			       global-name
			       global-pp)))
      (if (not (hashtable? env 'Genv))
	  (error "make-Genv" "Can't build Genv" env)
	  env)))
 
;*---------------------------------------------------------------------*/
;*    pp-global-environment ...                                        */
;*---------------------------------------------------------------------*/
(define (pp-global-environment port env)
   (pp-hashtable port env 'Genv))

;*---------------------------------------------------------------------*/
;*    bind-in-global-environment! ...                                  */
;*---------------------------------------------------------------------*/
(define (bind-in-global-environment! name Genv)
   (bind-object! name Genv 'Genv))

;*---------------------------------------------------------------------*/
;*    find-in-global-environment ...                                   */
;*---------------------------------------------------------------------*/
(define (find-in-global-environment name Genv)
   (find-object name Genv 'Genv))

;*---------------------------------------------------------------------*/
;*    unbind-in-global-environment! ...                                */
;*---------------------------------------------------------------------*/
(define (unbind-in-global-environment! name Genv)
   (unbind-object! name Genv 'Genv))
