;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../foreign.scm ...                                              */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 23 18:22:35 1992                          */
;*    Last change :  Thu Feb  3 17:50:28 1994 (serrano)                */
;*                                                                     */
;*    On parse les clauses foreigns                                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module parse_foreign
   (include "Foreign/type.sch")
   (import  engine_param
	    var_declare
	    tools_args
	    foreign_parse
	    foreign_tools
	    foreign_export)
   (export  (parse-foreign foreigns import/export)))

;*---------------------------------------------------------------------*/
;*    parse-foreign ...                                                */
;*---------------------------------------------------------------------*/
(define (parse-foreign foreigns import/export)
   (let loop ((foreigns foreigns))
      (if (null? foreigns)
	  'done
	  (begin
	     (foreign-parser (car foreigns) import/export)
	     (loop (cdr foreigns))))))
   
;*---------------------------------------------------------------------*/
;*    foreign-parser ...                                               */
;*---------------------------------------------------------------------*/
(define (foreign-parser foreign import/export)
   (match-case foreign
      ((include ?string)
       (if (not (string? string))
	   (error "foreign-parser" "Illegal `#include' form" foreign)
	   (if (not (member string *include-foreign*))
	       (set! *include-foreign* (cons string *include-foreign*)))))
      ((type . ?-)
       (parse-type foreign))
      ((define ?type ?l-name ?proto ?c-name)
       (if (not (and (string? c-name)
		     (symbol? type)
		     (symbol? l-name)))
	   (error "foreign-parser" "Illegal `define' form" foreign)
	   (let* ((of   (get-type type))
		  (from (map-on-args! get-type proto))
		  (type (make/get-function-type! of from)))
	      (declare-global-foreign! l-name
				       c-name
				       type
				       'macro-function))))
      ((define ?type ?l-name ?c-name)
       (if (not (and (string? c-name)
		     (symbol? type)
		     (symbol? l-name)))
	   (error "foreign-parser" "Illegal `define' form" foreign)
	   (declare-global-foreign! l-name
				    c-name
				    (get-type type)
				    'macro-cnst)))
      ((export (and (? symbol?) ?type-res)
	       (and (? symbol?) ?b-name)
	       (and (? list?) ?args)
	       (and (? string?) ?c-name))
       (remember-exported-bigloo-function! type-res b-name args c-name
					   import/export))
      ((export (and (? symbol?) ?type-res)
	       (and (? symbol?) ?b-name)
	       (and (? string?) ?c-name))
       (remember-exported-bigloo-variable! type-res b-name c-name
					   import/export))
      ((?type ?l-name ?proto ?c-name)
       (if (not (and (string? c-name)
		     (symbol? type)
		     (symbol? l-name)))
	   (error "foreign-parser" "Illegal foreign function form" foreign)
	   (let* ((of   (get-type type))
		  (from (map-on-args! get-type proto))
		  (type (make/get-function-type! of from)))
	      (declare-global-foreign! l-name
				       c-name
				       type
				       'function))))
      ((?type ?l-name ?c-name)
       (if (not (and (string? c-name)
		     (symbol? l-name)))
	   (error "foreign-parser" "Illegal foreign variable form" foreign)
	   (let ((type (get-type type)))
	      (if (eq? (type-type type) 'function)
		  (declare-global-foreign! l-name
					   c-name
					   type
					   'function)
		  (declare-global-foreign! l-name
					   c-name
					   type
					   'variable)))))
      (else
       (error "foreign-parser" "Illegal foreign form" foreign))))


       
