;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../export.scm ...                                               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jan 19 10:34:15 1994                          */
;*    Last change :  Thu Jan 20 11:33:21 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'exportation des fonctions vers un monde exterieur              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module foreign_export
   (include "Var/variable.sch"
	    "Expand/expander.sch"
	    "Foreign/type.sch")
   (import  var_env
	    var_declare
	    foreign_tools
	    tools_error
	    tools_shape
	    engine_param)
   (export  (remember-exported-bigloo-function! tres bname targs cname ie)
	    (remember-exported-bigloo-variable! type bname cname ie) 
	    (make-foreign-exported-body!)
	    (ajust-foreign-exported-types!)))

;*---------------------------------------------------------------------*/
;*    decl ...                                                         */
;*---------------------------------------------------------------------*/
(define-struct decl function? bname cname tres targs global)

;*---------------------------------------------------------------------*/
;*    create-decl ...                                                  */
;*---------------------------------------------------------------------*/
(define (create-decl function? bname cname tres targs)
   (let ((new (make-decl)))
      (decl-function?-set! new function?)
      (decl-bname-set!     new bname)
      (decl-cname-set!     new cname)
      (decl-tres-set!      new tres)
      (decl-targs-set!     new targs)
      new))

;*---------------------------------------------------------------------*/
;*    *export-exported* ...                                            */
;*---------------------------------------------------------------------*/
(define *export-exported* '())

;*---------------------------------------------------------------------*/
;*    *import-exported* ...                                            */
;*---------------------------------------------------------------------*/
(define *import-exported* '())

;*---------------------------------------------------------------------*/
;*    *to-be-ajusted-exported* ...                                     */
;*---------------------------------------------------------------------*/
(define *to-be-ajusted-exported* '())

;*---------------------------------------------------------------------*/
;*    remember-exported-bigloo-function! ...                           */
;*    -------------------------------------------------------------    */
;*    Il existe plusieurs cas:                                         */
;*       1- on est en train de faire un export                         */
;*       2- on est en train de faire un import                         */
;*---------------------------------------------------------------------*/
(define (remember-exported-bigloo-function! tres bname targs cname ie)
   (if (eq? ie 'import)
       (set! *import-exported* (cons (create-decl #t bname cname tres targs)
				     *import-exported*))
       (set! *export-exported* (cons (create-decl #t bname cname tres targs)
				     *export-exported*))))

;*---------------------------------------------------------------------*/
;*    remember-exported-bigloo-variable! ...                           */
;*---------------------------------------------------------------------*/
(define (remember-exported-bigloo-variable! type bname cname ie)
   (if (eq? ie 'import)
       (set! *import-exported* (cons (create-decl #f bname cname type '())
				     *import-exported*))
       (set! *export-exported* (cons (create-decl #f bname cname type '())
				     *export-exported*))))

;*---------------------------------------------------------------------*/
;*    all-bigloo-types? ...                                            */
;*---------------------------------------------------------------------*/
(define (all-bigloo-types? decl)
   (let loop ((types (cons (decl-tres decl) (decl-targs decl))))
      (if (null? types)
	  #t
	  (let ((type (get-type (car types))))
	     (if (not (type? type))
		 (error "foreign" "Unbound type" (shape type))
		 (if (bigloo-type? type)
		     (loop (cdr types))
		     #f))))))

;*---------------------------------------------------------------------*/
;*    make-foreign-exported-body! ...                                  */
;*    -------------------------------------------------------------    */
;*    Non seulement, on genere du code mais en plus on change          */
;*    eventuellement les definitions deja vues (pour les definitions   */
;*    importees).                                                      */
;*---------------------------------------------------------------------*/
(define (make-foreign-exported-body!)
   (update-import-foreign-exported-body!)
   (make-export-foreign-exported-body!))

;*---------------------------------------------------------------------*/
;*    update-import-foreign-exported-body! ...                         */
;*---------------------------------------------------------------------*/
(define (update-import-foreign-exported-body!)
   (for-each (lambda (decl)
		(if (all-bigloo-types? decl)
		    (let* ((name (decl-bname decl))
			   (v    (find-in-global-environment name *Genv*)))
		       (if (not (global? v))
			   (error "foreign"
				  "Unbound (foreign) imported variable"
				  name)
			   ;; tous les types sont des types bigloo, la seule
			   ;; on essaye donc de changer le nom de la fonction
			   (global-c-name-set! v (decl-cname decl))))))
	     *import-exported*))

;*---------------------------------------------------------------------*/
;*    make-export-foreign-exported-body! ...                           */
;*    -------------------------------------------------------------    */
;*    Ici, on se contente d'ajuster les noms des fonctions.            */
;*    C'est apres avoir construit l'arbre qu'on ajustera les types     */
;*    des variables.                                                   */
;*---------------------------------------------------------------------*/
(define (make-export-foreign-exported-body!)
   (let loop ((decls *export-exported*)
	      (res   '()))
      (if (null? decls)
	  res
	  (let* ((decl (car decls))
		 (v    (find-in-global-environment (decl-bname decl)
						   *Genv*)))
	     (cond
		((not (global? v))
		 ;; la variable n'est pas definie donc pas exportees,
		 ;; on l'exporte.
		 (error "foreign"
			"Unbound (foreign) exported variable"
			(decl-bname decl))
		 '())
		((all-bigloo-types? decl)
		 ;; tres facile, on change juste le nom C
		 (global-c-name-set! v (decl-cname decl))
		 (loop (cdr decls)
		       res))
		((not (decl-function? decl))
		 (error "foreign"
			"A variable can't be exported with a non bigloo type"
			(decl-bname decl)))
		(else
		 ;; voila, c'est le cas embettant, il faut generer un peu
		 ;; de code.
		 (let* ((name (gensym (decl-bname decl)))
			(args (decl-targs decl))
			(v    (declare-global-procedure! name
							 args
							 *module-name*
							 'export)))
		    ;; on ajuste le nom
		    (global-c-name-set! v (decl-cname decl))
		    ;; on memorise la variable pour ne pas avoir a aller
		    ;; la rechercher par la suite.
		    (decl-global-set! decl v)
		    (set! *to-be-ajusted-exported*
			  (cons decl *to-be-ajusted-exported*))
		    (loop (cdr decls)
			  (cons `(define (,name ,@args)
				    (,(decl-bname decl) ,@args))
				res)))))))))
 
;*---------------------------------------------------------------------*/
;*    ajust-foreign-exported-types! ...                                */
;*---------------------------------------------------------------------*/
(define (ajust-foreign-exported-types!)
   (for-each (lambda (decl)
		(let* ((v        (decl-global decl))
		       (function (global-value v)))
		   ;; on ajuste le type du resultat
		   (function-type-res-set! function
					   (get-type (decl-tres decl)))
		   ;; on ajuste les types des parametres formels
		   (for-each (lambda (arg type)
				(local-type-set! arg (get-type type)))
			     (function-args function)
			     (decl-targs decl))))
	     *to-be-ajusted-exported*))
 
