;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Expand/kwote.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun 17 18:28:53 1992                          */
;*    Last change :  Tue Dec 14 16:38:08 1993 (serrano)                */
;*                                                                     */
;*    Les quasiquotations ...                                          */
;*    Ce code provient du compilateur de Joel Bartlett. Le fichier     */
;*    source est: scqquote.sc                                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_kwote
   (export (quasiquotation x e))
   (import tools_error))
	   
;*---------------------------------------------------------------------*/
;*    quasiquotation ...                                               */
;*---------------------------------------------------------------------*/
(define (quasiquotation d exp)
    (if (and (pair? exp) (pair? (cdr exp)) (null? (cddr exp)))
	(template d (cadr exp))
	(partial-error "quasiquotation" "illegal `quasiquote' form" exp)))

;*---------------------------------------------------------------------*/
;*    template ...                                                     */
;*---------------------------------------------------------------------*/
(define (template d exp)
    (cond ((=fx d 0)
	   exp)
	  ((and (pair? exp) (eq? (car exp) 'unquote))
	   (if (and (pair? exp) (pair? (cdr exp)) (null? (cddr exp)))
	       (if (eq? d 1)
		   (template (-fx d 1) (cadr exp))
		   (list 'list ''unquote (template (-fx d 1) (cadr exp))))
	       (partial-error "unquote" "Illegal `unquote' form" (cadr exp))))
	  ((vector? exp)
	   (vector-template d exp))
	  ((pair? exp)
	   (list-template d exp))
	  ((or (char? exp) (integer? exp) (string? exp))
	   exp)
	  (else
	   (list 'quote exp))))

;*---------------------------------------------------------------------*/
;*    list-template ...                                                */
;*---------------------------------------------------------------------*/
(define (list-template d exp)
    (cond ((and (and (pair? exp) (pair? (cdr exp)) (null? (cddr exp)))
		(eq? (car exp) 'quote) (pair? (cadr exp))
		(eq? (car (cadr exp)) 'quasiquote))
	   (quasiquotation d (cadr exp)))
	  ((eq? (car exp) 'quasiquote)
	   (if (eq? d 0)
	       (quasiquotation (+fx d 1) exp)
	       (list 'list ''quasiquote (quasiquotation (+fx d 1) exp))))
	  (else (cons 'cons* (template-or-splice-list d exp)))))

;*---------------------------------------------------------------------*/
;*    vector-template ...                                              */
;*---------------------------------------------------------------------*/
(define (vector-template d exp)
    (list 'list->vector
	  (cons 'cons* (template-or-splice-list d (vector->list exp)))))

;*---------------------------------------------------------------------*/
;*    template-or-splice-list ...                                      */
;*---------------------------------------------------------------------*/
(define (template-or-splice-list d exp)
    (cond ((null? exp) '('()))
	  ((pair? exp)
	   (cond ((eq? (car exp) 'unquote)
		  (list (template d exp)))
		 ((and (pair? (car exp)) (eq? (car (car exp))
					      'unquote-splicing))
		  (list (list 'append
			      (template-or-splice d (car exp))
			      (cons 'cons*
				    (template-or-splice-list d (cdr exp))))))
		 (else (cons (template-or-splice d (car exp))
			     (template-or-splice-list d (cdr exp))))))
	  (else (list (template-or-splice d exp)))))

;*---------------------------------------------------------------------*/
;*    template-or-splice ...                                           */
;*---------------------------------------------------------------------*/
(define (template-or-splice d exp)
    (if (and (pair? exp) (eq? (car exp) 'unquote-splicing))
	(if (and (pair? exp) (pair? (cdr exp)) (null? (cddr exp)))
	    (if (eq? d 1)
		(template (-fx d 1) (cadr exp))
		(list 'list (list 'list ''unquote-splicing
				  (template (-fx d 1) (cadr exp)))))
	    (partial-error "unquote-splicing"
			   "Illegal `unquote-splicing' form"
			   exp))
	(template d exp)))

