;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.6/Curry/let.scm ...        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 12 11:28:33 1993                          */
;*    Last change :  Wed Jan  5 10:41:49 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La de-curriyfication des trois formes de liaisons lexicales      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    le module                                                        */
;*---------------------------------------------------------------------*/
(module curry_let
   (include "Curry/curry.sch"
	    "Var/variable.sch")
   (import  curry_exp
	    curry_walk
	    tools_beta
	    tools_shape
	    scan_lexical)
   (export  (curry-let    exp)
	    (curry-labels exp)))

;*---------------------------------------------------------------------*/
;*    curry-let ...                                                    */
;*---------------------------------------------------------------------*/
(define (curry-let exp)
   (let ((bindings (cadr exp))
	 (body     (caddr exp)))
      ;; on trippote les liaisons
      (for-each (lambda (bindings)
		   (set-car! (cdr bindings)
			     (curry-expression (cadr bindings))))
		bindings)
      (set-car! (cddr exp) (curry-expression body))
      exp))

;*---------------------------------------------------------------------*/
;*    curry-labels ...                                                 */
;*    -------------------------------------------------------------    */
;*    Le procede est presque le meme que pour les fonctions globales,  */
;*    on commence par faire une passe ou on construit les nouvelles    */
;*    fonctions, ensuite, on calcule les nouveaux corps.               */
;*---------------------------------------------------------------------*/
(define (curry-labels exp)
   (let* ((bindings     (cadr exp))
	  (body         (caddr exp))
	  (new-vars     (let loop ((walk bindings)
				   (res  '()))
			   (if (null? walk)
			       res
			       (let* ((binding (car walk))
				      (var     (car binding))
				      (args    (cadr binding))
				      (body    (caddr binding)))
				  ;; on remet le code car il y a eu des
				  ;; modifs (beta-reduction)
				  (function-body-set!  (local-value var) body)
				  (function-args-set!  (local-value var) args)
				  (let ((new-exps (curry-scan-local-var var)))
				     (loop (cdr walk)
					   (append new-exps res))))))))
      ;; pour toutes les liaisons, si elles ne sont deja curryfiees, on
      ;; calcule leur nouveau corps.
      (for-each (lambda (var)
		   (if (not (curry? (local-info var)))
		       (let ((new-body (curry-expression
					(function-body (local-value var)))))
			  (function-body-set! (local-value var) new-body))))
		new-vars)
      ;; on plug les nouvelles liaisons (attention, cela veut dire que les
      ;; champs function-args et function-body sont bien mis a jour).
      (set-car! (cdr exp) (map (lambda (var)
				  (let ((value (local-value var)))
				     (list var
					   (function-args value)
					   (function-body value))))
			       new-vars))
      ;; on plug le nouveau body
      (set-car! (cddr exp) (curry-expression body))
      exp))

;*---------------------------------------------------------------------*/
;*    curry-scan-local-var ...                                         */
;*    -------------------------------------------------------------    */
;*    Cette fonction est presque la meme que celle definie dans le     */
;*    module `curry_walk' aux differences pres qu'il s'agit ici de     */
;*    fonctions locales et qu'on n'a pas besoin de les chainer.        */
;*---------------------------------------------------------------------*/
(define (curry-scan-local-var var)
   (let* ((function (local-value var))
	  (args     (function-args function))
	  (body     (function-body function)))
      (if (not (=fx (function-arity function) 1))
	  (list var)
	  (let ((curry (find-curry-depth (function-arity function)
					 (car args) body)))
	     (if (not (curry? curry))
		 (list var)
		 (let* ((new-fun-name (make-curry-function-name
				       (local-name var)
				       (curry-depth curry)))
			(new-args     (map (lambda (v)
					      (allocate-local-variable
					       (local-name v)))
					   (curry-args curry)))
			(new-fun      (cdar (allocate-local-functions
					     (list new-fun-name)))))
		    (curry-new-fun-set! curry new-fun)
		    ;; on fait une copie du cons car on le ...
		    (function-body-set! (local-value new-fun)
					(beta-reduce
					 (cons (car (curry-body curry))
					       (cdr (curry-body curry)))
					 (map cons
					      (curry-args curry)
					      new-args)))
		    (function-args-set!  (local-value new-fun) new-args)
		    (function-arity-set! (local-value new-fun)
					 (curry-depth curry))
		    ;; ... detruit ici
		    (set-car! (curry-body curry) new-fun)
		    (set-cdr! (curry-body curry)
			      (reverse (reverse! (curry-args curry))))
		    (local-info-set! var curry)
		    (list var new-fun)))))))



