;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.6/0cfa/0cfa.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed May  5 15:43:49 1993                          */
;*    Last change :  Thu May 19 14:03:28 1994 (serrano)                */
;*                                                                     */
;*    Ce module fait l'analyse de control a proprement parle.          */
;*    On annote l'arbre de syntaxe abstraite.                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module 0cfa_0cfa
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "0cfa/0cfa.sch"
	    "0cfa/app.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    heap_abstract
	    0cfa_application
	    0cfa_foreign)
   (export  (0cfa! tree)
	    (get-global-lambda! exp)
	    (set-bottom! v)
	    (set-formal-approx! v a parent)
	    (create-lambda! exp root)
	    (create-variable! exp)
	    (cleanup-variables!)
	    (0cfa-exp! exp)
	    (union exp1 exp2)
	    *continue-0cfa?*
	    *time-stamp*
	    *0cfa-global-light-lambda*))
 
;*---------------------------------------------------------------------*/
;*    *0cfa-global-light-lambda* ...                                   */
;*---------------------------------------------------------------------*/
(define *0cfa-global-light-lambda* '())

;*---------------------------------------------------------------------*/
;*    Les variables de l'iterations ...                                */
;*---------------------------------------------------------------------*/
(define *continue-0cfa?* #t)
(define *time-stamp*     -1)
(define *union-added*    #f)

;*---------------------------------------------------------------------*/
;*    0cfa! ...                                                        */
;*---------------------------------------------------------------------*/
(define (0cfa! tree)
   ;; On commence par marquer que toutes les fonctions exportees on
   ;; des arguments dont on ne connait pas la valeur
   (for-each (lambda (var)
		(if (eq? (global-import var) 'export)
		    (for-each (lambda (v)
				 (set-bottom! (list v)))
			      (function-args (global-value var)))))
	     tree)
   ;; on commence l'iteration de point fixe
   (let loop ()
      (if *continue-0cfa?*
	  (begin
	     (new-0cfa-iteration tree)
	     (loop))
	  (begin
	     (verbose #\Newline)
	     (trace-0cfa)
	     tree))))

;*---------------------------------------------------------------------*/
;*    new-0cfa-iteration ...                                           */
;*---------------------------------------------------------------------*/
(define (new-0cfa-iteration tree)
   (set! *continue-0cfa?* #f)
   ;; on efface ce qui traine
   (set! *time-stamp*     (+fx 1 *time-stamp*))
   (verbose (make-string (let loop ((stamp *time-stamp*)
				    (res   2))
			    (if (>=fx stamp 10)
				(loop (/fx stamp 10)
				      (+fx res 1))
				res))
			 (integer->char 8)))
   (verbose (+fx 1 *time-stamp*) ")")
   (trace 0cfa
	  #\Newline
	  "***************************************************************"
	  #\newline
	  "                    Iteration No: " (+fx 1 *time-stamp*) #\Newline
	  #\Newline)
   (for-each (lambda (var)
		(trace 0cfa
		       "     ------------------------------------------"
		       #\Newline
		       "            *** " (shape var) " ***" #\Newline)
		(enter-function (shape var))
		(if (eq? (global-import var) 'export)
		    ;; on ne scan que les fonctions exportees, les autres
		    ;; seront vues par appels successifs.
		    (set-bottom!
		     (0cfa-exp! (function-body (global-value var)))))
		(leave-function))
	     tree))

;*---------------------------------------------------------------------*/
;*    0cfa-exp! ...                                                    */
;*---------------------------------------------------------------------*/
(define (0cfa-exp! exp) 
   (let ((g (gensym)))
      (trace (0cfa loop) "-> " g " : " (shape exp) #\Newline)
      (let ((res (.0cfa-exp! exp)))
	 (trace (0cfa loop) "<- " g " : " (shape res) #\Newline)
	 res)))
      
;*---------------------------------------------------------------------*/
;*    .0cfa-exp! ...                                                   */
;*---------------------------------------------------------------------*/
(define (.0cfa-exp! exp)
   (match-case exp
;*--- () --------------------------------------------------------------*/
      (() 
       '(nil))
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       (cond
	  ((local? exp)
	   (local-A* exp))
	  ((global? exp)
	   (get-global-A*! exp))
	  ((integer? exp)
	   '(bint))
	  ((char? exp)
	   '(bchar))
	  ((string? exp)
	   '(bstring))
	  ((boolean? exp)
	   `(,exp))
	  ((symbol? exp)
	   '(bsymbol))
	  ((boolean? exp)
	   '(bbool))
	  (else
	   '(bottom))))
;*--- quote -----------------------------------------------------------*/
      ((quote ?exp)
       (0cfa-quote! exp))
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       exp)
;*--- function --------------------------------------------------------*/
      ((function ?fun)
       (cond
	  ((global? fun)
	   ;; on n'initialise les fonctions globales que quand on tombe
	   ;; dessus (comme pour les variables globales).
	   (get-global-lambda! fun)
	   (global-E?-set! fun #t))
	  ((local? fun)
	   (local-E?-set! fun #t)))
       `(,fun))
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       (0cfa-exp*! (cdr exp))
       ;; une erreur ne permet aucune approximation
       '())
;*--- cif -------------------------------------------------------------*/
      ((cif ?si ?alors ?sinon)
       (0cfa-exp! si)
       (union (0cfa-exp! alors) (0cfa-exp! sinon)))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (0cfa-exp! test)
       (union* (map (lambda (clause) (0cfa-exp! (cadr clause)))
		    clauses)))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?-)
       (0cfa-exp*! (cdr exp)))
;*--- set! ------------------------------------------------------------*/
      ((set! ?var ?val)
       (cond
	  ((local? var)
	   (local-A*-set! var (union (local-A* var) (0cfa-exp! val)))
	   '(bottom))
	  ((global? var)
	   (let ((A* (get-global-A*! var)))
	      (global-A*-set! var (union A* (0cfa-exp! val)))
	      (set-bottom! (global-A* var))
	      '(bottom)))))
;*--- let -------------------------------------------------------------*/
      ((let ?bindings ?body)
       ;; on scan toutes les expressions locales
       (for-each (lambda (b)
		    (set-local-approx! (car b) (0cfa-exp! (cadr b))))
		 bindings)
       ;; on scan le corps
       (0cfa-exp! body))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       ;; on ne scan pas les corps locaux. Il n'est utile de le faire
       ;; que quand la fonction est appellee.
       ;; on scan le corps du labels
       (0cfa-exp! body))
;*--- block -----------------------------------------------------------*/
      ((block ?var ?body)
       (0cfa-exp! body))
;*--- return-from -----------------------------------------------------*/
      ((return-from ?app-info ?escape ?value)
       (set-bottom! (0cfa-exp! value))
       '(bottom))
;*--- apply -----------------------------------------------------------*/
      ((apply ?app-info ?fun ?args)
       (0cfa-apply exp app-info fun (0cfa-exp! args)))
;*--- funcall ---------------------------------------------------------*/
      ((funcall ?app-info ?fun . ?args)
       ;; il ne faut pas oublier de retirer le `EOA' de marquage de fin
       ;; d'argument.
       (let loop ((args    args)
		  (args-A* '()))
	  (if (null? (cdr args))
	      (0cfa-unknown-application! exp app-info fun (reverse args-A*))
	      (loop (cdr args) (cons (0cfa-exp! (car args)) args-A*)))))
;*--- application -----------------------------------------------------*/
      ((?fun ?app-info . ?args)
       (let* ((args-A* (map 0cfa-exp! args))
	      (res-A*  (0cfa-known-application! exp app-info fun args-A*)))
	  res-A*))))

;*---------------------------------------------------------------------*/
;*    0cfa-exp*! ...                                                   */
;*    -------------------------------------------------------------    */
;*    On evalue toutes les expressions et on retourne le resultat de   */
;*    la derniere                                                      */
;*---------------------------------------------------------------------*/
(define (0cfa-exp*! exp)
   (let loop ((exp   exp)
	      (last '(bottom)))
      (if (null? exp)
	  last
	  (loop (cdr exp) (0cfa-exp! (car exp))))))

;*---------------------------------------------------------------------*/
;*    0cfa-quote! ...                                                  */
;*---------------------------------------------------------------------*/
(define (0cfa-quote! exp)
   (cond
      ((null? exp)
       '(nil))
      ((symbol? exp)
       '(bsymbol))
      ((boolean? exp)
       '(bbool))
      ((string? exp)
       '(bstring))
      ((char? exp)
       '(bchar))
      ((pair? exp)
       (0cfa-list! exp))
      ((vector? exp)
       (0cfa-vector! exp))
      (else
       '(bottom))))

;*---------------------------------------------------------------------*/
;*    0cfa-list! ...                                                   */
;*---------------------------------------------------------------------*/
(define (0cfa-list! l)
   '(bpair))

;*---------------------------------------------------------------------*/
;*    0cfa-vector! ...                                                 */
;*---------------------------------------------------------------------*/
(define (0cfa-vector! vector)
   '(bvector))

;*---------------------------------------------------------------------*/
;*    set-bottom! ...                                                  */
;*    -------------------------------------------------------------    */
;*    Pour ne pas avoir de pbms avec des prgms du genre:               */
;*                                                                     */
;*    (define (foo x)                                                  */
;*       (let ((l (cons 1 2)))                                         */
;*          (let ((y (car l)))                                         */
;*             (set-car! l '()))))                                     */
;*                                                                     */
;*    Il faut, quand on rend 'bottom une paire, remplacer son approx   */
;*    par `bottom'.                                                    */
;*---------------------------------------------------------------------*/
(define (set-bottom! v)
   (trace (0cfa loop) "set-bottom!: " (shape v) #\Newline)
   (let ((bottom? #f))
      (define (set-one-bottom! v l)
	 (match-case v
	    ((atom ?-)
	     (cond
		((local? v)
		 (if (eq? (local-class v) 'function)
		     (set-bottom-function! v (local-value v) (local-info v))
		     (begin
			(local-A*-set! v (union '(bottom) (local-A* v)))
			(local-A* v))))
		((and (global? v)
		      (memq (global-import v) '(static export)))
		 (if (eq? (global-class v) 'function)
		     (set-bottom-function! v
					   (global-value v)
					   (get-global-lambda! v))
		     (begin
			(global-A*-set! v (union '(bottom) (get-global-A*! v)))
			(global-A* v))))
		((eq? v 'bottom)
		 (set! bottom? #t)
		 '(bottom))
		(else
		 '(bottom))))
	    ((?fun ?app . ?-)
	     (if (or (pair-approx? v)
		     (pair-O3-approx? v))
		 (let ((old (app-args* app)))
		    (app-args*-set! app (map (lambda (x) '(bottom)) old))
		    (for-each set-bottom! old)
		    (if (not bottom?)
			(begin
			   (set-cdr! l (cons (car l) (cdr l)))
			   (set-car! l 'bottom)
			   (set! bottom? #t))))
		 (error "set-one-bottom!" "Unknown approximation" (shape v))))
	    (else
	     (error "set-one-bottom!" "Unknown approximation" (shape v)))))
   (let loop ((v v))
      (if (null? v)
	  '(bottom)
	  (let ((to-loop (cdr v)))
	     (set-one-bottom! (car v) v)
	     (loop to-loop))))))

;*---------------------------------------------------------------------*/
;*    set-bottom-function! ...                                         */
;*    -------------------------------------------------------------    */
;*    Je ne suis pas completement sur qu'on ait le droit de faire      */
;*    l'optime sur `_lambda-bottomed?', a surveiller.                  */
;*---------------------------------------------------------------------*/
(define (set-bottom-function! fun value _lambda)
   (if (and #f (not (null? (_lambda-bottomed? _lambda))))
       ;; cette fonction a deja est bottomisee
       '(bottom)
       (begin
	  ;; quand une fonction part dans les choux, tous ses parametres 
	  ;; formles en font de meme. Deplus, cette fonction ne verifie plus
	  ;; le critere d'unicite.
	  (for-each (lambda (v) (set-bottom! (list v))) (function-args value))
	  (_lambda-strength-set! _lambda 'strong)
	  ;; il ne faut pas oublier de dire que le resultat du corps de la
	  ;; fonction est lui meme inconnue.
	  (if (not (eq? (_lambda-stamp _lambda) *time-stamp*))
	      (begin
;* 		 (_lambda-stamp-set! _lambda *time-stamp*)  */
		 (set-bottom! (0cfa-function-body! fun value))))
	  '(bottom))))

;*---------------------------------------------------------------------*/
;*    set-local-approx! ...                                            */
;*---------------------------------------------------------------------*/
(define (set-local-approx! l A*)
   (trace (0cfa loop) "set-local-approx!: " (shape l) " " (shape A*) #\Newline)
   (local-A*-set! l (union A* (local-A* l)))
   (if *union-added*
       (set! *continue-0cfa?* #t))
   (local-A* l))

;*---------------------------------------------------------------------*/
;*    set-formal-approx! ...                                           */
;*---------------------------------------------------------------------*/
(define (set-formal-approx! v A* parent)
   (trace (0cfa loop) "set-formal-approx!: " (shape v) " " (shape A*)
	  " " (shape parent) #\Newline)
   (let ((info (if (local? parent)
		   (local-info parent)
		   (get-global-lambda! parent))))
      (set-local-approx! v A*)
      (local-A* v))) 

;*---------------------------------------------------------------------*/
;*    union ...                                                        */
;*    -------------------------------------------------------------    */
;*    On fait une union bestial, peut-etre faudra-t-il ameliorer       */
;*    cette fonction. On verra plus tard.                              */
;*---------------------------------------------------------------------*/
(define (union exp1 exp2)
   (trace (0cfa loop) "union: " (shape exp1) " " (shape exp2) #\Newline)
   (set! *union-added* #f)
   (let ((true  #f)
	 (false #f))
      (define (mark-approx! a val)
	 (match-case a
	    ((atom ?-)
	     (cond
		((boolean? a)
		 (if a (set! true #t) (set! false #t)))
		((local? a)
		 (local-tag-set! a val))
		((global? a)
		 (global-tag-set! a val))
		(else
		 (putprop! a '0cfa-tag val))))
	    ((?- ?app-info . ?-)
	     (app-tag-set! app-info val))
	    (else
	     (error "union" "Unknown approximation type" (shape a)))))
      (define (approx-marked? a)
	 (match-case a
	    ((atom ?-)
	     (cond
		((boolean? a)
		 (if a true false))
		((local? a)
		 (eq? (local-tag a) #t))
		((global? a)
		 (eq? (global-tag a) #t))
		(else
		 (let ((tag (getprop a '0cfa-tag)))
		    (and tag (eq? tag #t))))))
	    ((?- ?app-info . ?-)
	     (eq? (app-tag app-info) #t))
	    (else
	     (error "union" "Unknown approximation type" (shape a)))))
      (cond
	 ((null? exp2)
	  ;; les cas degeneres (1)
	  (if (null? exp1)
	      '()
	      (begin
		 (set! *union-added* #t)
		 exp1)))
	 ((null? exp1)
	  ;; les cas degeneres (2)
	  exp2)
	 (else
	  ;; on marque toutes les approximations de exp2
	  (for-each (lambda (a) (mark-approx! a #t)) exp2)
	  ;; on marque toutes les approximations de exp1 en rammassant
	  (let loop ((exp1 exp1)
		     (res  exp2))
	     (if (null? exp1)
		 ;; on efface les tags et on retourne
		 (begin
		    (for-each (lambda (a) (mark-approx! a '())) res)
		    res)
		 (let ((a (car exp1)))
		    (if (approx-marked? a)
			(loop (cdr exp1) res)
			(begin
			   (set! *union-added* #t)
			   (loop (cdr exp1) (cons a res)))))))))))
;*---------------------------------------------------------------------*/
;*    Le precedent code, optimise celui-la                             */
;*---------------------------------------------------------------------*/
;*    (if (null? exp2)  */
;*        (if (null? exp1)  */
;* 	   '()  */
;* 	   (begin  */
;* 	      (set! *union-added* #t)  */
;* 	      exp1))  */
;*        (let loop ((exp1 exp1)  */
;* 		  (res  exp2))  */
;* 	  (trace (0cfa loop) "union: " (shape exp1) " " (shape res) #\Newline)  */
;* 	  (cond  */
;* 	     ((null? exp1)  */
;* 	      res)  */
;* 	     (else  */
;* 	      (match-case (car exp1)  */
;* 		 (()  */
;* 		  (loop (cdr exp1) res))  */
;* 		 (else  */
;* 		  (if (memq (car exp1) res)  */
;* 		      (loop (cdr exp1) res)  */
;* 		      (begin  */
;* 			 (set! *union-added* #t)  */
;* 			 (loop (cdr exp1) (cons (car exp1) res)))))))))))  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    union* ...                                                       */
;*---------------------------------------------------------------------*/
(define (union* exps)
   (cond
      ((null? exps)
       '())
      ((null? (cdr exps))
       (car exps))
      (else
       (let loop ((exps (cdr exps))
		  (res  (car exps)))
	  (if (null? exps)
	      res
	      (loop (cdr exps)
		    (union (car exps) res)))))))
	      
;*---------------------------------------------------------------------*/
;*    Des variables pour pouvoir faire des traces ...                  */
;*---------------------------------------------------------------------*/
(define *all-local-variables*  '(dummy))
(define *all-global-variables* '())
(define *all-local-lambdas*    '(dummy))
(define *all-global-lambdas*   '())

;*---------------------------------------------------------------------*/
;*    create-variable! ...                                             */
;*---------------------------------------------------------------------*/
(define (create-variable! var)
   (let ((new (make-_variable)))
      (if (local? var)
	  (begin
	     (local-info-set! var new)
	     (insort! var *all-local-variables*))
	  (begin
	     (global-info-set! var new)
	     (set! *all-global-variables*
		   (cons var *all-global-variables*))))
      new))

;*---------------------------------------------------------------------*/
;*    create-lambda! ...                                               */
;*---------------------------------------------------------------------*/
(define (create-lambda! var root)
   (let ((new (make-_lambda)))
      ;; on ne sait pas encore si cette fonction s'enfuie
      (_lambda-E?-set! new #f)
      (_lambda-stamp-set! new -1)
      ;; on position le champ root (ce champs n'est utile que pour
      ;; l'interface entre la `0cfa' et la passe `Lift').
      (_lambda-root-set! new root)
      ;; toutes les lambda sont par defaut `extra-light'
      (_lambda-strength-set! new 'extra-light)
      (if (local? var)
	  (begin
	     (local-info-set! var new)
	     (insort! var *all-local-lambdas*)))
      new))

;*---------------------------------------------------------------------*/
;*    insort! ...                                                      */
;*---------------------------------------------------------------------*/
(define (insort! var list)
   (let ((key (local-key var)))
      (if (null? (cdr list))
	  (set-cdr! list (cons var '()))
	  (let loop ((place list)
		     (tail  (cdr list)))
	     (cond
		((null? tail)
		 (set-cdr! place (cons var '())))
		((>fx (local-key (car tail)) key)
		 (set-cdr! place (cons var tail)))
		(else
		 (loop (cdr place) (cdr tail))))))))

;*---------------------------------------------------------------------*/
;*    get-global-A*! ...                                               */
;*---------------------------------------------------------------------*/
(define (get-global-A*! exp)
   ;; pour le moment toutes les variables globales qui ne sont
   ;; pas liees a des lambda sont bottom (pbm du (define foo foo))
   (cond
      ((_variable? (global-info exp))
       (global-A* exp))
      ((abstract? exp '__nil__)
       (let ((new (create-variable! exp)))
	  (_variable-A*-set! new '(nil))
	  '(nil)))
      ((abstract? exp 'c-current-input-port)
       (let ((new (create-variable! exp)))
	  (_variable-A*-set! new '(binput-port))
	  '(binput-port)))
      ((abstract? exp 'c-current-output-port 'c-current-error-port)
       (let ((new (create-variable! exp)))
	  (_variable-A*-set! new '(boutput-port))
	  '(boutput-port)))
      (else
       (let ((new (create-variable! exp)))
	  (_variable-A*-set! new '(bottom))
	  '(bottom)))))
 
;*---------------------------------------------------------------------*/
;*    get-global-lambda! ...                                           */
;*---------------------------------------------------------------------*/
(define (get-global-lambda! exp)
   (if (_lambda? (global-info exp))
       (global-info exp)
       (let ((new (create-lambda! exp exp)))
	  (set! *all-global-lambdas* (cons exp *all-global-lambdas*))
	  (global-info-set! exp new)
	  (if (not (eq? (global-import exp) 'static))
	      (begin
		 (global-site*-set! exp '(bottom))
		 (_lambda-strength-set! (global-info exp) 'strong))
	      (_lambda-strength-set! (global-info exp) 'light))
	  new))) 

;*---------------------------------------------------------------------*/
;*    trace-0cfa ...                                                   */
;*---------------------------------------------------------------------*/
(define (trace-0cfa)
   (when-trace
    '(0cfa)
    (lambda ()
       (fprint *trace-port*
	"***************************************************************"
	#\Newline
	"                          Resultats")
       (fprint *trace-port* "========== local variables ==========")
       (for-each (lambda (variable)
		    (fprint *trace-port*
			    (shape variable) ": " 
			    (shape (local-A* variable))
			    #\Newline))
		 (cdr *all-local-variables*))
       (fprint *trace-port* "========== global variables =========")
       (for-each (lambda (variable)
		    (fprint *trace-port*
			    (shape variable) ": " 
			    (shape (global-A* variable))
			    #\Newline))
		 *all-global-variables*)
       (fprint *trace-port* "========== local lambdas ============")
       (for-each (lambda (function)
		    (fprint *trace-port*
			    (shape function) ": "
			    (if (local? function)
				(if (local-E? function)
				    "[E] "
				    "[nE] ")
				(if (global-E? function)
				    "[E] "
				    "[nE] "))
			    (if (local? function)
				(local-strength function)
				(global-strength function))
			    "  ["
			    (if (local? function)
				(length (local-site* function))
				(length (global-site* function)))
			    "]  "
			    (if (local? function)
				(shape (local-body-A* function))
				(shape (global-body-A* function)))))
		 (cdr *all-local-lambdas*))
       (fprint *trace-port* "========== global lambdas ===========")
       (for-each (lambda (function)
		    (fprint *trace-port*
			    (shape function) ": "
			    (if (global-E? function)
				"[E] "
				"[nE] ")
			    (global-strength function)
			    "  ["
			    (length (global-site* function))
			    "]  "
			    (shape (global-body-A* function))))
		 *all-global-lambdas*))))
			       
;*---------------------------------------------------------------------*/
;*    cleanup-variables ...                                            */
;*    -------------------------------------------------------------    */
;*    On nettoie tous les champs `info'                                */
;*---------------------------------------------------------------------*/
(define (cleanup-variables!)
   (for-each (lambda (variable)
		(local-info-set! variable '()))
	     (cdr *all-local-variables*))
   (for-each (lambda (variable)
		(global-info-set! variable '()))
	     *all-global-variables*)
   (for-each (lambda (g)
		(if (not (eq? (_lambda-strength (global-info g)) 'strong))
		    (set! *0cfa-global-light-lambda*
			  (cons g *0cfa-global-light-lambda*))))
	     *all-global-lambdas*)
   (for-each (lambda (f)
		(cond
		   ((local? f)
		    (local-info-set! f '()))
		   ((global? f)
		    (global-info-set! f '()))))
	     (cdr *all-local-lambdas*)))
			      
