;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/runtime0.1/Llib/bstring.scm ...                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 13 10:02:24 1993                          */
;*    Last change :  Fri Apr  1 16:53:43 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La manipulation des strings                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_bstring
   (foreign (bbool is_printable (bchar) "is_printable")
	    (obj   blit_string (obj obj obj obj obj) "blit_string")
	    (obj   fill_string (obj obj obj obj)     "fill_string")
	    (obj   c-compare_strings (obj obj)       "compare_strings"))
   (export  (inline string_length s)
	    (inline create_string len)
	    (inline compare_strings s1 s2)))

;*---------------------------------------------------------------------*/
;*    string_length ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (string_length s)
   (string-length s))

;*---------------------------------------------------------------------*/
;*    create_string ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (create_string len)
   (make-string len))

;*---------------------------------------------------------------------*/
;*    compare_strings ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (compare_strings s1 s2)
   (c-compare_strings s1 s2))

 
