;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/runtime0.0/Llib/bint.scm ...                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 12 14:31:42 1993                          */
;*    Last change :  Mon Mar 14 08:56:11 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La manipulation des ints                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_bint
   (foreign (obj format_int (obj obj)   "format_int")
	    (obj c-int_of_string (obj)  "int_of_string"))
   (export  (inline int_of_string s)
	    (inline int_of_char char)
	    (inline char_of_int int)))

;*---------------------------------------------------------------------*/
;*    int_of_string ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (int_of_string s)
   (c-int_of_string s))
   
;*---------------------------------------------------------------------*/
;*    int_of_char ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (int_of_char x)
   (char->integer x))

;*---------------------------------------------------------------------*/
;*    char_of_int ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (char_of_int x)
   (integer->char x))

