/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/ml/camloo/runtime0.0/Clib/alloc.c ...                    */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Thu Dec 16 13:53:16 1993                          */
/*    Last change :  Fri Feb 11 19:48:05 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Ma version du fichier alloc.c                                    */
/*=====================================================================*/
#include <bigloo.h>
#include <caml-bigloo.h> 
#include <value-bigloo.h> 

/*---------------------------------------------------------------------*/
/*    Les externes                                                     */
/*---------------------------------------------------------------------*/
extern obj_t make_vector();

/*---------------------------------------------------------------------*/
/*    value                                                            */
/*    copy_string_array ...                                            */
/*---------------------------------------------------------------------*/
value
copy_string_array( arr )
char **arr;
{
	int   nbr = 0, i;
	obj_t res;
	
	while( arr[ nbr ] )
	   nbr++;

	res = make_vector( BINT( nbr ), BUNSPEC );

	for( i = 0; i < nbr; i ++ )
	   VECTOR_SET( res, BINT( i ), c_string_to_string( arr[ i ] ) );

	return res;
}

/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    convert_flag_list ...                                            */
/*---------------------------------------------------------------------*/
int
convert_flag_list( list, flags )
value  list;
int   *flags;
{
  int res; 
  res = 0;
  
  while( !NULLP( list ) )
  {
    res |= flags[ Tag_val( Field( list, 0 ) ) ];
    list = Field( list, 1 );
  }
  
  return res;
}
