/* The "get_next_char" routine for lexers generated by camllex. */

#include "mlvalues.h"
#include "stacks.h"
#include "str.h"

struct lexer_buffer {
#if( defined( BIGLOO_H ) )
	header_t        header;   
	union object   *length;
#endif	
	value refill_buff;
	value lex_buffer;
	value lex_abs_pos;
	value lex_start_pos;
	value lex_curr_pos;
	value lex_last_pos;
	value lex_last_action;
};

value get_next_char(lexbuf)     /* ML */
     struct lexer_buffer * lexbuf;
{
  mlsize_t buffer_len, curr_pos;
  
  buffer_len = string_length(lexbuf->lex_buffer);
  curr_pos = Long_val(lexbuf->lex_curr_pos);
  if (curr_pos >= buffer_len) {
    Push_roots (r, 1);
#if( !defined( BIGLOO_H ) )	 
    r[0] = (value) lexbuf;
#endif	 
    callback(lexbuf->refill_buff, (value) lexbuf);
#if( !defined( BIGLOO_H ) )	 
    lexbuf = (struct lexer_buffer *) r[0];
#endif	 
    curr_pos = Long_val(lexbuf->lex_curr_pos);
    Pop_roots ();
  }
#if( defined( BIGLOO_H ) )
  lexbuf->lex_curr_pos = ADD_I( lexbuf->lex_curr_pos, BINT( 1 ) );
#else
  lexbuf->lex_curr_pos += 2;
#endif
  
#if( !defined( BIGLOO_H ) )  
  return Val_int(Byte_u(lexbuf->lex_buffer, curr_pos));
#else
  {
	  obj_t res;

	  res = BCHAR( Byte_u(lexbuf->lex_buffer, curr_pos) );
	  
	  return res;
  }
#endif BIGLOO_H  
}

