/*=====================================================================*/
/*    serrano/ml/camloo/runtime0.0/Include/caml-bigloo.h ...           */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec  7 08:13:51 1993                          */
/*    Last change :  Mon Mar  7 16:45:11 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Les nouvelles structures (et macro) pour la compilation de       */
/*    camllight                                                        */
/*=====================================================================*/
#ifndef CAML_BIGLOO_H
#define CAML_BIGLOO_H

#include <globals-bigloo.h>

/*---------------------------------------------------------------------*/
/*    Les `setjmp/longjmp' des `try/raise'                             */
/*---------------------------------------------------------------------*/
#if defined( SPARC ) || defined( sparc )
#   undef SETJMP
#   undef LONGJMP
#   define SETJMP __setjmp
#   define LONGJMP __longjmp
#endif

/*---------------------------------------------------------------------*/
/*    Est-ce que camlc a ete patche pour Bigloo ?                      */
/*---------------------------------------------------------------------*/
#define CAMLC_PATCHED

/*---------------------------------------------------------------------*/
/*    Is_block ...                                                     */
/*---------------------------------------------------------------------*/
#define Is_block( x ) \
   ( PAIRP( x ) || VECTORP( x ) || STRINGP( x ) || REALP( x ) )

/*---------------------------------------------------------------------*/
/*    Il existe plusieurs sortes de constructeurs. Chacun a un         */
/*    codage differents. Voyons au cas par cas comme les codages:      */
/*                                                                     */
/*       1) Les constructeurs constants: Ils sont mappes sur les       */
/*          constantes (macro BCNST) ce sont des valeurs immediates.   */
/*                                                                     */
/*       2) Les constructeurs non constants et non extensibles: Ils    */
/*          sont mappes sur les vecteurs. Leurs tags sont ranges dans  */
/*          les 8 bits de poids forts (inutilises) du mot contenant    */
/*          les tailles des dits vecteurs.                             */
/*                                                                     */
/*            +--------+--------+--------+--------+                    */
/*            |tt..signed fixed point value.....??|                    */
/*            +--------+--------+--------+--------+                    */
/*                                                                     */
/*          `tt' designe le tag, `??' est le tag des vecteurs.         */
/*                                                                     */
/*       3) Les constructeurs extensibles sont des vecteurs. Les 8     */
/*          de tags sont mis a une valeur particuliere, le vrai tag    */
/*          est range dans le dernier slot du vecteur.                 */
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    CAML_MAKE_TAG                                                    */
/*    -------------------------------------------------------------    */
/*    Attention, il y a sur le calcul des tag une grosse magouille:    */
/*    QUand je les calcules avec cette macro `CAML_MAKE_TAG' je les    */
/*    construit comme etant des constantes or quand je les range       */
/*    dans les constructeurs non constants, je les cast en entier.     */
/*    Ceci est fait dans les macros `VECTOR_TAG_SET' et                */
/*    `VECTOR_TAG_REF'.                                                */
/*---------------------------------------------------------------------*/
#define CAML_MAKE_TAG( slot, length ) BCNST( slot + 1 )
#define STATIC_CAML_MAKE_TAG( slot, length ) BINT( slot + 1 )

/*---------------------------------------------------------------------*/
/*    CAML_ExTENSIBLE_TAG                                              */
/*---------------------------------------------------------------------*/
#define CAML_EXTENSIBLE_TAG BINT( 0 )

/*---------------------------------------------------------------------*/
/*    CAML_CONS_TAG                                                    */
/*---------------------------------------------------------------------*/
#define CAML_CONS_TAG BINT( 1 )

/*---------------------------------------------------------------------*/
/*    Des predicats                                                    */
/*---------------------------------------------------------------------*/
#define CAML_CONSTANT_CONSTRP( c )   \
   CNSTP( c )

#define CAML_CONS_CONSTRP( c )       \
   PAIRP( c )

#define CAML_REGULAR_CONSTRP( c )    \
   ( !CAML_CONSTANT_CONSTRP( c ) &&  \
	  !CAML_CONS_CONSTRP( c ) &&      \
	  (CAML_REGULAR_CONSTR_TAG( c ) != CAML_EXTENSIBLE_TAG) )

#define MAY_BE_AN_CAML_EXTENSIBLE_CONSTRP( c ) \
   ( SYMBOLP( c ) || VECTORP( c ) )

#define CAML_EXTENSIBLE_CONSTRP( c ) \
   ( !CAML_CONSTANT_CONSTRP( c ) &&  \
	  !CAML_CONS_CONSTRP( c ) &&      \
	  ( SYMBOLP( c ) ||               \
		 (CAML_REGULAR_CONSTR_TAG( c ) == CAML_EXTENSIBLE_TAG) ) )

/*---------------------------------------------------------------------*/
/*    CAML_CONSTR_TAG ...                                              */
/*---------------------------------------------------------------------*/
#if( defined( CAMLC_PATCHED ) )

#   define CAML_CONSTR_TAG( _caml_c_ )                   \
       ( CAML_REGULAR_CONSTRP( _caml_c_ ) ?              \
         CAML_REGULAR_CONSTR_TAG( _caml_c_ ) :           \
		   ( CAML_CONS_CONSTRP( _caml_c_ ) ?               \
			  CAML_CONS_CONSTR_TAG( _caml_c_ ) :            \
		     CAML_EXTENSIBLE_CONSTR_TAG( _caml_c_ ) ) )

#   define CAML_CONSTANT_CONSTR_TAG( _caml_c_ )          \
       _caml_c_

#   define CAML_CONS_CONSTR_TAG( _caml_c_ )              \
       CAML_CONS_TAG

#   define CAML_REGULAR_CONSTR_TAG( _caml_c_ )           \
       VECTOR_TAG( _caml_c_ )

#   define CAML_EXTENSIBLE_CONSTR_TAG( _caml_c_ )        \
       ( SYMBOLP( _caml_c_ ) ?                           \
		   _caml_c_ :                                      \
         VECTOR_REF( _caml_c_, SUB_I( VECTOR_LENGTH( _caml_c_ ), \
												  BINT( 1 ) ) ) )
          
#else CAMLC_PATCHED

#   define CAML_CONSTR_TAG( _caml_c_ )                   \
       ( CAML_CONSTANT_CONSTRP( _caml_c_ ) ?             \
            CAML_CONSTANT_CONSTR_TAG( _caml_c_ ) :       \
            ( CAML_REGULAR_CONSTRP( _caml_c_ ) ?         \
              CAML_REGULAR_CONSTR_TAG( _caml_c_ ) :      \
		        CAML_EXTENSIBLE_CONSTR_TAG( _caml_c_ ) ) )

#   define CAML_CONSTANT_CONSTR_TAG( _caml_c_ )          \
       _caml_c_

#   define CAML_REGULAR_CONSTR_TAG( _caml_c_ )           \
       ( CAML_CONSTANT_CONSTRP( _caml_c_ ) ?             \
            CAML_CONSTANT_CONSTR_TAG( _caml_c_ ) :       \
            VECTOR_TAG( _caml_c_ ) )

#   define CAML_EXTENSIBLE_CONSTR_TAG( _caml_c_ )        \
       ( CAML_CONSTANT_CONSTRP( _caml_c_ ) ?             \
            CAML_CONSTANT_CONSTR_TAG( _caml_c_ ) :       \
  	         VECTOR_REF( _caml_c_,                        \
							   SUB_I( VECTOR_LENGTH( _caml_c_ ),\
										 BINT( 1 ) ) ) )

#endif CAMLC_PATCHED

/*---------------------------------------------------------------------*/
/*    CAML_CONSTR_LENGTH                                               */
/*---------------------------------------------------------------------*/
#define CAML_CONSTR_LENGTH( _caml_c_ )                   \
    ( CAML_CONSTANT_CONSTRP( _caml_c_ ) ?                \
	   CAML_CONSTANT_CONSTR_LENGTH( _caml_c_ ) :          \
	   ( CAML_CONS_CONSTRP( _caml_c_ ) ?                  \
		  CAML_CONS_CONSTR_LENGTH( _caml_c_ ) :            \
	     ( CAML_REGULAR_CONSTRP( _caml_c_ ) ?             \
	       CAML_REGULAR_CONSTR_LENGTH( _caml_c_ ) :       \
		    CAML_EXTENSIBLE_CONSTR_LENGTH( _caml_c_ ) ) ) )

#define CAML_CONSTANT_CONSTR_LENGTH( _caml_c_ )          \
   BINT( 0 )

#define CAML_CONS_CONSTR_LENGTH( _caml_c_ )              \
   BINT( 2 )

#define CAML_REGULAR_CONSTR_LENGTH( _caml_c_ )           \
   ( VECTOR_LENGTH( _caml_c_ ) )

#define CAML_EXTENSIBLE_CONSTR_LENGTH( _caml_c_ )        \
   ( SUB_I( VECTOR_LENGTH( _caml_c_ ), BINT( 1 ) ) )

/*---------------------------------------------------------------------*/
/*    CAML_REGULAR_CONSTR_REPLACE_TAG                                  */
/*---------------------------------------------------------------------*/
#define VECTOR_REPLACE_TAG( c1, c2 )                  \
    ( VECTOR( c1 ).length = VECTOR( c2 ).length )
/* on garde cette definition car je ne sais pas si on peut la virer */
/* ...a suivre                                                      */
#define CAML_REGULAR_CONSTR_REPLACE_TAG VECTOR_REPLACE_TAG

#define CAML_REGULAR_CONSTR_SET_TAG( obj, tag )       \
    ( VECTOR_TAG_SET( obj, tag ) )

/*---------------------------------------------------------------------*/
/*    Les acces aux champs                                             */
/*---------------------------------------------------------------------*/	
#define CAML_CONSTR_GET_FIELD( _caml_c_, i )          \
   VECTOR_REF( _caml_c_, i )

#define CAML_CONSTR_SET_FIELD( _caml_c_, i, v )       \
   VECTOR_SET( _caml_c_, i, v )

/*---------------------------------------------------------------------*/
/*    Les acces aux constructeurs constants                            */
/*---------------------------------------------------------------------*/
#define _CAML_CNST_CONSTR_TAG( _caml_c_ ) BINT( _caml_c_ )

/*---------------------------------------------------------------------*/
/*    Les acces aux constructeurs non constants et non extensibles     */
/*---------------------------------------------------------------------*/
#define CAML_REGULAR_CONSTR_SIZE  VECTOR_SIZE

#define CAML_ALLOCATE_REGULAR_CONSTR( size )          \
   (obj_t)make_vector( size, BUNSPEC )

/*---------------------------------------------------------------------*/
/*    Les constructeurs extensibles                                    */
/*---------------------------------------------------------------------*/
#define CAML_EXTENSIBLE_CONSTR_SIZE  VECTOR_SIZE 

/*---------------------------------------------------------------------*/
/*    Les manipulation des handlers                                    */
/*---------------------------------------------------------------------*/
extern obj_t continuation_value;
extern obj_t current_handler;

#define GET_THE_CONTINUATION( _res_ )                               \
	jmp_buf jmpbuf;                                                  \
	int     value;                                                   \
	value = SETJMP( jmpbuf );                                        \
   value ? (current_handler = continuation_value, _res_ = BFALSE) : \
           (current_handler = (obj_t)jmpbuf, _res_ = BTRUE )

#define INVOKE_CONTINUATION( _val_ )                                \
   continuation_value = _val_, LONGJMP( (JMP_BUF *)current_handler, 1 )
      

#endif CAML_BIGLOO_H
