;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/comptime0.2/Camloo/module.scm ...              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec  1 09:31:46 1993                          */
;*    Last change :  Wed Apr 27 16:34:47 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La reconstruction des modules pour Bigloo                        */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module module
   (import init)
   (export (get-imported-modules)
	   (module-shape             prefix module)
	   (remember-module!         module . name)
	   (mark-as-remember-module! module)))

;*---------------------------------------------------------------------*/
;*    Quelques variables pour se souvenir de tout.                     */
;*---------------------------------------------------------------------*/
(define *modules* '())

;*---------------------------------------------------------------------*/
;*    module-shape ...                                                 */
;*---------------------------------------------------------------------*/
(define (module-shape prefix module)
   (string-append prefix module))

;*---------------------------------------------------------------------*/
;*    get-importer-modules ...                                         */
;*---------------------------------------------------------------------*/
(define (get-imported-modules)
   *modules*)

;*---------------------------------------------------------------------*/
;*    remember-module! ...                                             */
;*---------------------------------------------------------------------*/
(define (remember-module! module . mname)
   (let ((smodule (string->symbol (string-upcase module))))
      (if (pair? mname)
	  (putprop! smodule 'file-name (car mname)))
      (if (getprop smodule 'remember)
	  'done
	  (begin
	     (putprop! smodule 'remember #t)
	     (set! *modules* (cons module *modules*))))))

;*---------------------------------------------------------------------*/
;*   mark-as-remember-module! ...                                      */
;*---------------------------------------------------------------------*/
(define (mark-as-remember-module! module)
   (let ((smodule (string->symbol (string-upcase module))))
      (putprop! smodule 'remember #t)))

