;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/comptime0.2/Camloo/lprim.scm ...               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec  1 10:55:09 1993                          */
;*    Last change :  Thu Jun  2 10:49:45 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La compilation des formes Lprim                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module Lprim
   (include "Camloo/var.sch")
   (import  llambda
	    var
	    lconst
	    ldefine
	    module
	    misc
	    generate)
   (export  (Lprim exp tl? cp)))

;*---------------------------------------------------------------------*/
;*    is-function? ...                                                 */
;*---------------------------------------------------------------------*/
(define (is-function? exp)
   (match-case exp
      ((lshared ?exp ?-)
       (is-function? exp))
      ((lfunction . ?-)
       #t)
      ((Lletrec ?- ?body)
       (is-function? body))
      ((Llet ?- ?body)
       (is-function? body))
      (else
       #f)))
       
;*---------------------------------------------------------------------*/
;*    Lprim ...                                                        */
;*---------------------------------------------------------------------*/
(define (Lprim exp tl? cp)
   (match-case (cdr exp)
      ((Pidentity (?rest))
       (llambda rest tl? cp #f))
      (((Pset_global (qualifiedident ?module ?name)) (?value))
       (Pset_global exp tl? cp))
      (((Pget_global (qualifiedident ?module ?name)) ())
       (remember-module! module)
       (get-global name module))
      (((Pdummy . ?rest) ())
       (match-case rest
	  ((and (? integer?) ?int)
	   ;; pour etre compatible avec la version qui n'a pas l'optime
	   ;; des dummy on a rajoute ce filtre.
	   `(caml-allocate-regular-constr ,int))
	  ((vector ?int)
	   `(make-vector ,int))
	  (((or tuple record) ?int)
	   `(caml-allocate-regular-constr ,int))
	  (((or stream parser))
	   '(caml-allocate-regular-constr 2))
	  ((function)
	   '(unspecified))
	  (((?- (?- ?module ?name) . ?-) ?int)
	   (cond
	      ((and (string=? module "builtin")
		    (string=? name "::"))
	       '(cons (unspecified) (unspecified)))
	      (else
	       `(caml-allocate-regular-constr ,int))))
	  (else
	   (error "Lprim" "Illegal Pdummy form" (shape (cdr exp))))))
      ((Pupdate (?exp1 ?exp2))
       (if (is-function? exp2)
	   ;; cas bizzare qui semble etre genere pour les streams
	   `(set! ,(llambda exp1 #f cp #f) ,(llambda exp2 #f cp #f))
	   `(caml-constr-update! ,(llambda exp1 #f cp #f)
				 ,(llambda exp2 #f cp #f))))
      (((Ptest ?test) (?e1 ?e2))
       `(,(Ptest test) ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      (((Pmakeblock ?constr) ?values)
       (Pmakeblock constr values cp))
      ((Ptag-of (?e))
       `(tag-of ,(llambda e #f cp #f)))
      (((Pfield ?int) (?e))
       (Pfield int e cp))
      (((Psetfield ?int) (?exp ?value))
       (Psetfield int exp value cp))
      (((Pccall ?call ?n) ?args)
       (case call
	  ((cell-ref)
	   `(cell-ref ,(llambda (car args) #f cp #t)))
	  ((cell-set!)
	   `(cell-set! ,(llambda (car args) #f cp #t)
		       ,(llambda (cadr args) #f cp #f)))
	  (else
	   `(,call ,@(map (lambda (v) (llambda v #f cp #f))
			  args)))))
      ((Praise (?value))
       `(raise ,(llambda value #f cp #f)))
      ((Pnot (?e))
       `(not ,(llambda e #f cp #f)))
      ((Pnegint (?e))
       `(negfx ,(llambda e #f cp #f)))
      ((Psuccint (?e))
       `(+fx ,(llambda e #f cp #f) 1))
      ((Ppredint (?e))
       `(-fx ,(llambda e #f cp #f) 1))
      ((Paddint (?e1 ?e2))
       `(+fx ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Psubint (?e1 ?e2))
       `(-fx ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Pmulint (?e1 ?e2))
       `(*fx ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Pdivint (?e1 ?e2))
       `(/fx ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Pmodint (?e1 ?e2))
       `(modulo ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Pandint (?e1 ?e2))
       `(bit-and ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Porint (?e1 ?e2))
       `(bit-or ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Pxorint (?e1 ?e2))
       `(bit-xor ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Pshiftleftint (?e1 ?e2))
       `(bit-lsh ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Pshiftrightintsigned (?e1 ?e2))
       `(bit-rsh ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Pshiftrightintunsigned (?e1 ?e2))
       `(bit-ursh ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Pincr (?e))
       (let ((var (llambda e #f cp #t)))
	  (if (and (not (local? var))
		   (not (global? var)))
	      (let ((local (make-local-variable "aux")))
		 (exit-lexical-block!)
		 `(let ((,local ,var))
		     (cell-set! ,local (+fx (cell-ref ,local) 1))))
	      `(cell-set! ,var (+fx (cell-ref ,var) 1)))))
      ((Pdecr (?e))
       (let ((var (llambda e #f cp #t)))
	  (if (and (not (local? var))
		   (not (global? var)))
	      (let ((local (make-local-variable "aux")))
		 (exit-lexical-block!)
		 `(let ((,local ,var))
		     (cell-set! ,local (+fx (cell-ref ,local) 1))))
	      `(cell-set! ,var (-fx (cell-ref ,var) 1)))))
      ((Pintoffloat (?e))
       `(flonum->fixnum ,(llambda e #f cp #f)))
      (((Pfloatprim ?f) ?e)
       `(,(Pfloatprim f) ,@(map (lambda (v) (llambda v #f cp #f)) e)))
      ((Pstringlength (?e))
       `(string-length ,(llambda e #f cp #f)))
      ((Pgetstringchar (?e1 ?e2))
       `(string-ref ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Psetstringchar (?e1 ?e2 ?e3))
       `(string-set! ,(llambda e1 #f cp #f)
		     ,(llambda e2 #f cp #f)
		     ,(llambda e3 #f cp #f)))
      ((Pmakevector (?e1 ?e2))
       `(make-vector ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Pvectlength (?e))
       (let ((v (gensym)))
	  `(let ((,v ,(llambda e #f cp #f)))
	      (if ,v
		  (vector-length ,v)
		  0))))
      ((Pgetvectitem (?e1 ?e2))
       `(vector-ref ,(llambda e1 #f cp #f) ,(llambda e2 #f cp #f)))
      ((Psetvectitem (?e1 ?e2 ?e3))
       `(vector-set! ,(llambda e1 #f cp #f)
		     ,(llambda e2 #f cp #f)
		     ,(llambda e3 #f cp #f)))
      (else
       (error "lprim" "Unknow primitives" exp))))

;*---------------------------------------------------------------------*/
;*    Pmakeblock ...                                                   */
;*    -------------------------------------------------------------    */
;*    Il faut faire attention au cas particulier des `cons'. Ce        */
;*    n'est pas tres joli mais on recupere ce cas a la vollee.         */
;*---------------------------------------------------------------------*/
(define (Pmakeblock constr values cp)
   (match-case constr
      ((ConstrRegular (qualifiedident ?module ?name) ?- ?-)
       (cond
	  ((and (string=? module "builtin")
		(string=? name "::"))
	   `(cons ,@(map (lambda (v) (llambda v #f cp #f)) values)))
	  ((and (string=? module "ref")
		(string=? name "ref"))
	   `(make-cell ,(llambda (car values) #f cp #f)))
	  (else
	   `(,(if (ConstrExtensible? constr)
		  'caml-make-extensible
		  'caml-make-regular)
	     ,(constr-tag constr)
	     ,(length values)
	     ,@(map (lambda (v) (llambda v #f cp #f))
		    values)))))
      (else
       `(,(if (ConstrExtensible? constr)
	      'caml-make-extensible
	      'caml-make-regular)
	 ,(constr-tag constr)
	 ,(length values)
	 ,@(map (lambda (v) (llambda v #f cp #f))
		values)))))

;*---------------------------------------------------------------------*/
;*    Pfield ...                                                       */
;*    -------------------------------------------------------------    */
;*    Il existe plusieurs facons de faire un `Pfield'. Le chois        */
;*    de la methode depend des proprietes eventuelles de               */
;*    l'expression qu'on dereference.                                  */
;*    -------------------------------------------------------------    */
;*    Jusqu'a present il y a trois cas:                                */
;*       - les variables servant d'indice aux boucles `for'            */
;*       - les constructeurs constants qui ont ete alloues dans des    */
;*         `cons'                                                      */
;*       - tous les autres                                             */
;*---------------------------------------------------------------------*/
(define (Pfield int e cp)
   (let* ((be   (llambda e #f cp #t))
	  (prop (get-constr-prop be cp)))
      (case prop
	 ((for-indice)
	  be)
	 ((::)
	  (if (=fx int 0)
	      `(car ,be)
	      `(cdr ,be)))
	 ((ref)
	  `(cell-ref ,be))
	 (else
	  `(caml-constr-get-field ,be ,int)))))

;*---------------------------------------------------------------------*/
;*    Psetfield ...                                                    */
;*    -------------------------------------------------------------    */
;*    Meme remarque que pour la precedente fonction.                   */
;*---------------------------------------------------------------------*/
(define (Psetfield int exp value cp)
   (let* ((be   (llambda exp #f cp #t))
	  (prop (get-constr-prop be cp))
	  (ve   (llambda value #f cp #f)))
      (case prop
	 ((for-indice)
	  `(set! ,be ,ve))
	 ((::)
	  `(,(if (=fx int 0) 'set-car! 'set-cdr!) ,be ,ve))
	 ((ref)
	  `(cell-set! ,be ,ve))
	 (else
	  `(caml-constr-set-field! ,be ,int ,ve)))))

;*---------------------------------------------------------------------*/
;*    Ptest ...                                                        */
;*---------------------------------------------------------------------*/
(define (Ptest test)
   (match-case test
      (Peq
       'eq?)
      (Pnoteq_test
       '(lambda (x y) (not (eq? x y))))
      ((Pint_test ?op)
       (Pint_test op))
      ((Pfloat_test ?op)
       (Pfloat_test op))
      ((Pstring_test ?op)
       (Pstring_test op))
      (else
       `(todo-Ptest ,test))))

;*---------------------------------------------------------------------*/
;*    Pint_test ...                                                    */
;*---------------------------------------------------------------------*/
(define (Pint_test op)
   (case op
      ((PTeq)               '=fx)
      ((PTnoteq PTnoteqimm) '(lambda (x y) (not (=fx x y))))
      ((PTlt)               '<fx)
      ((PTle)               '<=fx)
      ((PTgt)               '>fx)
      ((PTge)               '>=fx)))

;*---------------------------------------------------------------------*/
;*    Pfloat_test ...                                                  */
;*---------------------------------------------------------------------*/
(define (Pfloat_test op)
   (case op
      ((PTeq)               '=fl)
      ((PTnoteq PTnoteqimm) '(lambda (x y) (not (=fl x y))))
      ((PTlt)               '<fl)
      ((PTle)               '<=fl)
      ((PTgt)               '>fl)
      ((PTge)               '>=fl)))

;*---------------------------------------------------------------------*/
;*    Pstring_test ...                                                 */
;*---------------------------------------------------------------------*/
(define (Pstring_test op)
   (case op
      ((PTeq)               'string=?)
      ((PTnoteq PTnoteqimm) '(lambda (x y) (not (string=? x y))))
      ((PTlt)               'string<?)
      ((PTle)               'string<=?)
      ((PTgt)               'string>?)
      ((PTge)               'string>=?)))

;*---------------------------------------------------------------------*/
;*    Pfloatprim ...                                                   */
;*---------------------------------------------------------------------*/
(define (Pfloatprim f)
   (case f
      ((Pfloatofint)
       'fixnum->flonum)
      ((Pnegfloat)
       'negfl)
      ((Paddfloat)
       '+fl)
      ((Psubfloat)
       '-fl)
      ((Pmulfloat)
       '*fl)
      ((Pdivfloat)
       '/fl)))

      
   
