;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/comptime0.2/Camloo/llambda.scm ...             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec  1 08:48:45 1993                          */
;*    Last change :  Thu Jun  2 16:27:08 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On compile expression par expression. On ne fait pas ici une     */
;*    compilation globale.                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module llambda
   (include "Camloo/trace.sch"
	    "Camloo/var.sch")
   (import  misc
	    module
	    Lprim
	    Lconst
	    Lswitch
	    var)
   (export  (llambda exp tl? cp rw-ref?)
	    (make-local-variable . name)
	    (exit-lexical-block!)
	    (Lstaticfail exp cp)))

;*---------------------------------------------------------------------*/
;*    llambda ...                                                      */
;*    -------------------------------------------------------------    */
;*       - exp est l'expression a compiler                             */
;*       - tl? est un flag indiquant si on se trouve au niveau du      */
;*         top-level                                                   */
;*       - cp est une aliste de description des constructeurs.         */
;*       - rw-ref? est on en train de faire un ref ?                   */
;*---------------------------------------------------------------------*/
(define (llambda exp tl? cp rw-ref?)
   (trace 1 "llambda   : " (shape exp)
	  #\newline
	  "top-level?  : " tl?
	  #\Newline
	  "cp          : " (shape cp)
	  #\Newline
	  "rw-ref?     : " rw-ref?)
   (if (not (pair? exp))
       exp
       (case (car exp)
	  ((import)
	   (remember-module! (symbol->string (cadr exp)) (prefix (caddr exp)))
	   '(unspecified))
	  ((Lvar)
	   (Lvar exp rw-ref?))
	  ((Lconst)
	   (Lconst (cadr exp)))
	  ((Lapply)
	   (Lapply exp cp))
	  ((Lprim)
	   (Lprim exp tl? cp))
	  ((Lcond)
	   (Lcond exp cp))
	  ((Lswitch)
	   (Lswitch exp cp))
	  ((Lshared)
	   (Lshared exp tl? cp))
	  ((Lfunction)
	   (Lfunction exp cp))
	  ((Llet)
	   (Llet exp tl? cp))
	  ((Lletrec)
	   (Lletrec exp tl? cp))
	  ((Lifthenelse)
	   (Lifthenelse exp cp))
	  ((Lsequor)
	   (Lsequor exp cp))
	  ((Lsequand)
	   (Lsequand exp cp))
	  ((Lsequence)
	   (Lsequence exp tl? cp))
	  ((Lwhile exp)
	   (Lwhile exp cp))
	  ((Lfor exp)
	   (Lfor exp tl? cp))
	  ((Lstatichandle)
	   (Lstatichandle exp cp))
	  ((Lstaticfail)
	   (Lstaticfail exp cp))
	  ((Lhandle)
	   (Lhandle exp cp))
	  (else
	   (error "Llambda" "Illegal form" exp)))))

;*---------------------------------------------------------------------*/
;*    Lvar ...                                                         */
;*---------------------------------------------------------------------*/
(define (Lvar exp rw-ref?)
   (trace 11 "Lvar: " exp #\newline
	  *lexical-stack*)
   (define (nth n l)
      (if (=fx n 0)
	  (car l)
	  (nth (-fx n 1) (cdr l))))
   (let ((var (nth (cadr exp) *lexical-stack*)))
      (local-occur-set! var (+fx 1 (local-occur var)))
      (if (and (not rw-ref?) (local? var))
	  (local-value?-set! var #t))
      var))

;*---------------------------------------------------------------------*/
;*    Lapply ...                                                       */
;*---------------------------------------------------------------------*/
(define (Lapply exp cp)
   (let loop ((args (caddr exp))
	      (res  (llambda (cadr exp) #f cp #f)))
      (if (null? args)
	  res
	  (loop (cdr args)
		(list res (llambda (car args) #f cp #f))))))

;*---------------------------------------------------------------------*/
;*    Lshared ...                                                      */
;*---------------------------------------------------------------------*/
(define (Lshared exp tl? cp)
   (match-case exp
      ((Lshared ?body -1)
       (llambda body tl? cp #f))
      (else
       exp)))

;*---------------------------------------------------------------------*/
;*    Lfunction ...                                                    */
;*---------------------------------------------------------------------*/
(define (Lfunction exp cp)
   (let ((var (make-local-variable)))
      (local-value?-set! var #t)
      (let ((res `(lambda (,var)
		     ,(llambda (cadr exp) #f cp #f))))
	 (exit-lexical-block!)
	 res)))
  
;*---------------------------------------------------------------------*/
;*    Llet ...                                                         */
;*    -------------------------------------------------------------    */
;*    A cause de la mauvaise compilation du `let .. and ..' je suis    */
;*    oblige de tester en permanance si on n'est pas en train de       */
;*    definir des variables globales                                   */
;*---------------------------------------------------------------------*/
(define (Llet exp tl? cp)
   (match-case exp
      ((?- () ?body)
       (llambda body tl? cp #f))
      ((?- ?vals ?body)
       (if (let-and? vals body)
	   (Llet-and-global vals body tl? cp)
;*---------------------------------------------------------------------*/
;*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
;*    -------------------------------------------------------------    */
;*    Attention cette fonction ne marche que parce que la fonction     */
;*    `map' est gauche->droite.                                        */
;*---------------------------------------------------------------------*/
	   (let* ((vv  (map (lambda (val)
				(let* ((val (llambda val #f cp #f))
				       (new (make-local-variable)))
				   (match-case val
				      ((not (make-cell ?-))
				       (local-value?-set! new #t)))
				   (list new val)))
			     vals))
		  (res `(let ,vv ,(llambda body #f cp #f))))
	      (let loop ((i (length vals)))
		 (if (=fx i 0)
		     'done
		     (begin
			(exit-lexical-block!)
			(loop (-fx i 1)))))
	      res)))))
 
;*---------------------------------------------------------------------*/
;*    let-and? ...                                                     */
;*---------------------------------------------------------------------*/
(define (let-and? vals body)
   (match-case body
      ((lshared ?body -1)
       (let loop ((body body) 
		  (len  (-fx (length vals) 1)))
	  (match-case body
	     (()
	      #f)
	     ((lprim (pset_global (qualifiedident ?- ?-)) ((lvar ?num)))
	      (=fx num len))
	     ((lsequence ?body1 ?body2)
	      (if (loop body1 len)
		  (loop body2 (-fx len 1))
		  #f))
	     (else
	      #f))))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    Llet-and-global ...                                              */
;*---------------------------------------------------------------------*/
(define (Llet-and-global vals _body tl? cp)
   (let loop ((vals     vals)
	      (body     (cadr _body)))
      (if (null? vals)
	  'done
	  (match-case body
	     ((lsequence ?exp1 (lsequence . ?-))
	      (set-car! (cdr body) (loop vals exp1))
	      (loop (cdr vals) (caddr body)))
	     ((lsequence ?exp1 ?exp2)
	      (set-car! (cdr body) (loop vals exp1))
	      (set-car! (cddr body) (loop (cdr vals) exp2)))
	     ((lprim ?- ?-)
	      (set-car! (cddr body) (list (car vals)))
	      body))))
   (llambda (cadr _body) tl? cp #f))

;*---------------------------------------------------------------------*/
;*    dummy-llambda ...                                                */
;*---------------------------------------------------------------------*/
(define (dummy-llambda exp dummy-size var-name tl? cp)
   (let ((cexp (llambda exp tl? cp #f)))
      (match-case dummy-size
	 ((vector ?int) 
	  `(let ((,var-name (make-vector ,int)))
	      (caml-constr-update! ,var-name ,cexp)
	      ,var-name))
	 (((or tuple record) ?int)
	  `(let ((,var-name (caml-allocate-regular-constr ,int)))
	      (caml-constr-update! ,var-name ,cexp)
	      ,var-name))
	 ((stream)
	  `(let ((,var-name (caml-allocate-regular-constr 2)))
	      (caml-constr-update! ,var-name ,cexp)
	      ,var-name))
	 ((or (function) (parser))
	  cexp)
	 (((?- (?- ?module ?name) . ?-) ?int)
	  (cond
	     ((and (string=? module "builtin")
		   (string=? name "::"))
	      `(let ((,var-name (cons (unspecified) (unspecified))))
		  (caml-constr-update! ,var-name ,cexp)
		  ,var-name))
	     (else
	      `(let ((,var-name (caml-allocate-regular-constr ,int)))
		  (caml-constr-update! ,var-name ,cexp)
		  ,var-name))))
	 (else
	  (error "dummy-llambda" "Illegal expression" (shape exp))))))
	 
;*---------------------------------------------------------------------*/
;*    Lletrec ...                                                      */
;*---------------------------------------------------------------------*/
(define (Lletrec exp tl? cp)
   (let ((res (Lletrec-unoptimized exp tl? cp)))
      (match-case res
	 ((letrec ((?var (and ?lam (lambda (?arg) . ?-))))
	     ?var)
	  ;; on fait l'optim de eta-conversion car visiblement c'est
	  ;; le truc a la mode de programmer comme ca !!!
	  (let ((new-local (local (local-name arg) '() #f 1)))
	     `(lambda (,new-local)
		 (letrec ((,var ,lam))
		    (,var ,new-local)))))
	 (else
	  res))))

;*---------------------------------------------------------------------*/
;*    Lletrec-unoptimized ...                                          */
;*---------------------------------------------------------------------*/
(define (Lletrec-unoptimized exp tl? cp)
   (match-case exp
      ((?- () ?body)
       (llambda body tl? cp #f))
      ((?- ?vals ?body)
       (let* ((vars (map (lambda (val)
			    (make-local-variable))
			 vals))
	      (res `(letrec ,(map (lambda (var val)
				     `(,var ,(dummy-llambda (car val)
							    (cadr val)
							    var
							    #f
							    cp)))
			       vars vals)
		       ,(llambda body #f cp #f))))
	  (let loop ((i (length vals)))
	     (if (=fx i 0)
		 'done
		 (begin
		    (exit-lexical-block!)
		    (loop (-fx i 1)))))
	  res))))

;*---------------------------------------------------------------------*/
;*    Les variables locales                                            */
;*---------------------------------------------------------------------*/
(define *lexical-offset* 0)
(define *lexical-stack*  '())

;*---------------------------------------------------------------------*/
;*    make-local-variable ...                                          */
;*---------------------------------------------------------------------*/
(define (make-local-variable . name)
   (set! *lexical-offset* (+fx 1 *lexical-offset*))
   (let* ((new (string->symbol (string-append (if (null? name)
						  "x"
						  (car name))
					      (integer->string
					       *lexical-offset*))))
	  (local (local new '() #f 0)))
      (trace 11 "make-local-variable: " new #\Newline
	     *lexical-stack*) 
      (set! *lexical-stack* (cons local *lexical-stack*))
      local))

;*---------------------------------------------------------------------*/
;*    exit-lexical-block! ...                                          */
;*---------------------------------------------------------------------*/
(define (exit-lexical-block!)
   (set! *lexical-stack* (cdr *lexical-stack*))
   (set! *lexical-offset* (-fx *lexical-offset* 1)))

;*---------------------------------------------------------------------*/
;*    Lifthenelse ...                                                  */
;*---------------------------------------------------------------------*/
(define (Lifthenelse exp cp)
   (let* ((si (llambda (cadr exp) #f cp #f))
	  (alors (llambda (caddr exp) #f cp #f))
	  (sinon (llambda (cadddr exp) #f cp #f)))
      `(if ,si ,alors ,sinon)))

;*---------------------------------------------------------------------*/
;*    Lsequor ...                                                      */
;*---------------------------------------------------------------------*/
(define (Lsequor exp cp)
   (let* ((exp1 (llambda (cadr exp) #f cp #f))
	  (exp2 (llambda (caddr exp) #f cp #f)))
      `(or ,exp1 ,exp2)))

;*---------------------------------------------------------------------*/
;*    Lsequand ...                                                     */
;*---------------------------------------------------------------------*/
(define (Lsequand exp cp)
   (let* ((exp1 (llambda (cadr exp) #f cp #f))
	  (exp2 (llambda (caddr exp) #f cp #f)))
      `(and ,exp1 ,exp2)))

;*---------------------------------------------------------------------*/
;*    Lsequence ...                                                    */
;*---------------------------------------------------------------------*/
(define (Lsequence exp tl? cp)
   ;; si on est au top-level, on commence par traite le cas
   ;; possible de redefinition de fonction global.
   (if tl?
       (overwrite-global-definition! exp))
   (let* ((exp1 (llambda (cadr exp) tl? cp #f))
	  (exp2 (llambda (caddr exp) tl? cp #f)))
      `(begin ,exp1 ,exp2)))

;*---------------------------------------------------------------------*/
;*    Lwhile ...                                                       */
;*---------------------------------------------------------------------*/
(define (Lwhile exp cp)
   (let* ((loop (gensym))
	  (test (llambda (cadr exp) #f cp #f))
	  (body (llambda (caddr exp) #f cp #f)))
      `(let ,loop ()
	  (if ,test
	      (begin
		 ,body
		 (,loop))
	      '()))))

;*---------------------------------------------------------------------*/
;*    Lfor ...                                                         */
;*    -------------------------------------------------------------    */
;*    On fait un peu un hack pour bien compiler les `for'. On marque   */
;*    la variable qu'on est en train d'introduire avec la propriete    */
;*    `for-indice', dans la compilation des accesseurs et des setters, */
;*    on utilisera cette marque.                                       */
;*---------------------------------------------------------------------*/
(define (Lfor exp tl? cp)
   (match-case exp
      ((?- ?init ?stop ?way ?body)
       (let* ((test      (if way '<=fx '>=fx))
	      (incr      (if way '+fx '-fx))
	      (new-cp    (unspecified))
	      (indice    (let ((indice (make-local-variable "i")))
			    (set! new-cp (set-constr-prop! indice 'for-indice))
			    indice))
	      (for       (gensym 'for))
	      (stop-v    (gensym 'stop))
	      (user-body (let* ((dummy1 (make-local-variable))
				(body   (llambda body #f (append new-cp cp)
						 #f)))
			    (exit-lexical-block!)
			    body)))
	  (unset-constr-prop! indice 'for-indice)
	  (exit-lexical-block!)
	  `(let ((,stop-v ,(begin (make-local-variable)
				  (let ((res (llambda stop #f cp #f)))
				     (exit-lexical-block!)
				     res))))
	      (let ,for ((,indice ,(llambda init #f cp #f)))
		   (if (,test ,indice ,stop-v)
		       (begin
			  ,user-body
			  (,for (,incr ,indice 1)))
		       (unspecified))))))
      (else
       (error "camloo" "Illegal `Lfor' form" exp))))

;*---------------------------------------------------------------------*/
;*    *static-fail* ...                                                */
;*---------------------------------------------------------------------*/
(define *static-fail* '())

;*---------------------------------------------------------------------*/
;*    Lstaticfail ...                                                  */
;*---------------------------------------------------------------------*/
(define (Lstaticfail exp cp)
   (if (null? *static-fail*)
       '(staticfail)
       (list (car *static-fail*))))

;*---------------------------------------------------------------------*/
;*    Lstatichandle ...                                                */
;*---------------------------------------------------------------------*/
(define (Lstatichandle exp cp)
   (match-case exp
      ((?- ?body (Lstaticfail))
       (llambda body #f cp #f))
      ((?- (Llet ((Lhandle . ?-)) . ?-) ?rest)
       ;; le cas qui tue des streams...vraiment
       (let ((fail  (gensym 'staticfail))
	     (exit  (gensym 'staticexit))
	     (fbody (begin (make-local-variable)
			   (let ((res (llambda (caddr exp) #f cp #f)))
			      (exit-lexical-block!)
			      res))))
	  (set! *static-fail* (cons fail *static-fail*))
	  (let* ((res `(bind-exit (,exit)
				  (labels ((,fail () (,exit ,fbody)))
				     ,(llambda (cadr exp) #f cp #f)))))
	     (set! *static-fail* (cdr *static-fail*))
	     res)))
      (else
       (let ((fail  (gensym 'staticfail))
	     (fbody (llambda (caddr exp) #f cp #f)))
	  (set! *static-fail* (cons fail *static-fail*))
	  (let* ((res `(labels ((,fail () ,fbody))
			  ,(llambda (cadr exp) #f cp #f))))
	     (set! *static-fail* (cdr *static-fail*))
	     res)))))

;*---------------------------------------------------------------------*/
;*    handle ...                                                       */
;*---------------------------------------------------------------------*/
(define (Lhandle exp cp)
   (let* ((new-handler    (gensym))
	  (aux-top        (gensym 'handler-top))
	  (aux-flag       (gensym))
	  (body           (llambda (cadr exp) #f cp #f))
	  (fun            (gensym 'try))
	  (handler-formal (make-local-variable)))
      (let ((res `(let* ((,aux-top        current_handler)
			 (,aux-flag       (unspecified)))
		     (labels ((,fun (,aux-flag)
				    (begin
				       (get-the-continuation ,aux-flag)
				       (if (eq? #t #f) (,fun (,fun (,fun 1))))
				       (if ,aux-flag
					   ,body
					   current_handler))))
			(let ((,handler-formal (,fun ,aux-flag)))
			   (set! current_handler ,aux-top)
			   (if (=fx *try* 1)
			       (begin
				  (set! *try* 0)
				  ,(llambda (caddr exp) #f cp #f))
			       ,handler-formal))))))
	 (exit-lexical-block!)
	 res)))
       
 

