;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloos/recette/rgc-jm.scm ...              */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  3 12:14:43 1992                          */
;*    Last change :  Tue Nov  3 15:15:54 1992  (serrano)               */
;*                                                                     */
;*    Un essai de grammaire de Jean-Marie qui faisait planter          */
;*    bigloov1.0                                                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module rgc-jm
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-rgc-jm)))

;*---------------------------------------------------------------------*/
;*    test-rgc-jm ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-rgc-jm)
   (test-module "rgc-jm" "rgc-jm.scm" #f)
   (test "rgc-jm" (let* ((level 0)
			 (my-grammar
			  (regular-grammar ( (lpar (in #\( #\[ #\{))
					     (rpar (in #\) #\] #\})) )
			     ((lpar)
			      (the-string)
			      (set! level (+ level 1)))
			     ((rpar)
			      (the-string)
			      (set! level (- level 1))
			      'paren)
			     ((+ (out  #\( #\[ #\{
				       #\) #\] #\}))
			      (the-string))
			     (else (the-failing-char)))))
		     (with-input-from-file "misc/jm.txt"
			(lambda ()
			   (labels ((loop ()
			       (let ((c (read/rp my-grammar
						 (current-input-port))))
				  (if (eof-object? c)
				      level
				      (if (eq? c 'paren)
					  (loop)
					  (loop))))))
			      (loop)))))
	 7))



