;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../version.scm ...                                              */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 09:55:20 1993                          */
;*    Last change :  Thu Apr 28 09:16:56 1994 (serrano)                */
;*                                                                     */
;*    On affiche des informations sur bigloo                           */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module write_version 
   (import engine_param)
   (export (version)
	   (short-version)))

;*---------------------------------------------------------------------*/
;*    short-version ...                                                */
;*---------------------------------------------------------------------*/
(define (short-version)
   (print *bigloo-name*))

;*---------------------------------------------------------------------*/
;*    version ...                                                      */
;*---------------------------------------------------------------------*/
(define (version)
   (display-to-column "" 79 #\-)
   (newline)
   (horse (string-append *bigloo-name* (if (char? *bigloo-level*)
					   (let ((s " (level 0)"))
					      (string-set! s 8 *bigloo-level*)
					      s)
					   ""))
	  "a `Scheme' compiler"
	  (if (char=? (string-ref *bigloo-date* 0) #\space)
	      (substring *bigloo-date* 1 (string-length *bigloo-date*))
	      *bigloo-date*)
	  *bigloo-author*
	  "email:"
	  *bigloo-email*)
   (display-to-column "" 79 #\-)
   (newline)
   (newline))

;*---------------------------------------------------------------------*/
;*    horse ...                                                        */
;*---------------------------------------------------------------------*/
(define (horse . l)
   (let loop ((l     l)
	      (horse '("            ,--^, "
		       "      _ ___/ /|/  "
		       "  ,;'( )__, ) '   "
		       " ;;  //   L__.    " 
		       " '   \\    /  '    "
		       "      ^   ^       ")))
      (cond
	 ((null? l)
	  (if (null? horse)
	      'done
	      (begin
		 (display-to-column "" 62 #\space)
		 (print (car horse))
		 (loop '() (cdr horse)))))
	 ((null? horse)
	  (print (car l))
	  (loop (cdr l) '()))
	 (else
	  (display-to-column (car l) 62 #\space)
	  (print (car horse))
	  (loop (cdr l) (cdr horse))))))

;*---------------------------------------------------------------------*/
;*    display-to-column ...                                            */
;*---------------------------------------------------------------------*/
(define (display-to-column string column char)
   (display string)
   (let loop ((l (+fx 1 (string-length string))))
      (if (=fx l column)
	  'done
	  (begin
	     (write-char char)
	     (loop (+fx l 1))))))   
      
