;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../abstract.scm ...                                             */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 24 08:24:29 1993                          */
;*    Last change :  Mon Mar  7 09:07:34 1994 (serrano)                */
;*                                                                     */
;*    Un module qui permet de contruire des arbres de syntaxe          */
;*    abstraite dans les passes qui suivent `Scan'                     */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module heap_abstract
   (include "Var/variable.sch")
   (import  var_env)
   (export  (abstract-init!)
	    (abstract-nil)
	    (abstract-eoa)
	    (abstract-false)
	    (abstract-false?                          exp)
	    (abstract-true)
	    (abstract-true?                           exp)
	    (abstract-cons                            a d)
	    (abstract-cons?                           exp)
	    (abstract-car                             exp)
	    (abstract-car?                            exp)
	    (abstract-cdr                             exp)
	    (abstract-cdr?                            exp)
	    (abstract-null?                           exp)
	    (abstract-length                          exp)
	    (abstract-bbool->cbool                    exp)
	    (abstract-bbool->cbool?                   exp)
	    (abstract-cbool->bbool                    exp)
	    (abstract-cbool->bbool?                   exp)
	    (abstract-cint->bint                      exp)
	    (abstract-cint->bint?                     exp)
	    (abstract-bint->cint                      exp)
	    (abstract-bint->cint?                     exp)
	    (abstract-string->symbol                  exp)
	    (abstract-cstring->bstring                exp)
	    (abstract-cstring->bstring?               exp)
	    (abstract-bstring->cstring                exp)
	    (abstract-cchar->bchar                    exp)
	    (abstract-bchar->cchar                    exp)
	    (abstract-cdouble->breal                  exp)
	    (abstract-breal->cdouble                  exp)
	    (abstract-csymbol->bsymbol                exp)
	    (abstract-csymbol->bsymbol?               exp)
	    (abstract-boolean?                        exp)
	    (abstract-char?                           exp)
	    (abstract-procedure?                      exp)
	    (abstract-procedure-light?                exp)
	    (abstract-integer?                        exp)
	    (abstract-real?                           exp)
	    (abstract-pair?                           exp)
	    (abstract-vector?                         exp)
	    (abstract-input-port?                     exp)
	    (abstract-output-port?                    exp)
	    (abstract-string?                         exp) 
	    (abstract-struct?                         exp)
	    (abstract-symbol?                         exp)
	    (abstract-not?                            exp)
	    (abstract-boolean??                       exp)
	    (abstract-char??                          exp)
	    (abstract-procedure??                     exp)
	    (abstract-integer??                       exp)
	    (abstract-real??                          exp)
	    (abstract-pair??                          exp)
	    (abstract-vector??                        exp)
	    (abstract-input-port??                    exp)
	    (abstract-output-port??                   exp)
	    (abstract-string??                        exp)
	    (abstract-struct??                        exp)
	    (abstract-symbol??                        exp)
	    (abstract-type-error                      type var)
	    (abstract-=fx                             a b)
	    (abstract-=fx?                            fun)
	    (abstract-<=fx                            a b)
	    (abstract-<=fx?                           fun)
	    (abstract-negfx                           a)
	    (abstract--fx                             a b)
	    (abstract-va-procedure?                   exp)
	    (abstract-va-procedure??                  exp)
	    (abstract-unspecified)        
	    (abstract-cell-ref                        exp)
	    (abstract-cell-ref?                       exp)
	    (abstract-cell-set!                       exp)
	    (abstract-cell-set!?                      exp)
	    (abstract-make-cell                       exp)
	    (abstract-make-cell?                      exp)
	    (abstract-procedure-entry                 proc)
	    (abstract-procedure-light-entry           proc)
	    (abstract-make-fx-procedure               entry arity size)
	    (abstract-make-light-procedure            entry size)
	    (abstract-make-extra-light-procedure      size)
	    (abstract-make-fx-procedure?              exp)
	    (abstract-make-va-procedure               entry arity size)
	    (abstract-make-va-procedure?              exp)
	    (abstract-make-light-procedure?           exp)
	    (abstract-procedure-env-ref               proc indice)
	    (abstract-procedure-env-set!              proc indice val)
	    (abstract-procedure-light-env-ref         proc indice)
	    (abstract-procedure-light-env-set!        proc indice val)
	    (abstract-procedure-extra-light-env-ref   proc indice)
	    (abstract-procedure-extra-light-env-set!  proc indice val)
	    (abstract-list->vector                    list)
	    (abstract-define-primop-ref               n r)
	    (abstract-define-primop                   n o)
	    (abstract-location                        o)
	    (abstract-eval?                           o)
	    (abstract-eval                            e)
	    (abstract-type-tester)
	    (abstract-fx-arithmetic-tester)
	    (abstract-fx-arithmetic-op)
	    (abstract-special-no-cost?                exp)
	    (abstract                                 name . args)
	    (abstract?                                val . names)))
	    
;*---------------------------------------------------------------------*/
;*    La (longue) liste des variables locales                          */
;*---------------------------------------------------------------------*/
(define *nil*                            (unspecified))
(define *eoa*                            (unspecified))
(define *false*                          (unspecified))
(define *true*                           (unspecified))
(define *cons*                           (unspecified))
(define *O3cons*                         (unspecified))
(define *car*                            (unspecified))
(define *cdr*                            (unspecified))
(define *null?*                          (unspecified))
(define *length*                         (unspecified))
(define *bbool->cbool*                   (unspecified))
(define *cbool->bbool*                   (unspecified))
(define *cint->bint*                     (unspecified))
(define *bint->cint*                     (unspecified))
(define *string->symbol*                 (unspecified))
(define *cstring->bstring*               (unspecified))
(define *bstring->cstring*               (unspecified))
(define *cchar->bchar*                   (unspecified))
(define *bchar->cchar*                   (unspecified))
(define *cdouble->breal*                 (unspecified))
(define *breal->cdouble*                 (unspecified))
(define *csymbol->bsymbol*               (unspecified))
(define *boolean?*                       (unspecified))
(define *not*                            (unspecified))
(define *char?*                          (unspecified))
(define *procedure?*                     (unspecified))
(define *procedure-light?*               (unspecified))
(define *integer?*                       (unspecified))
(define *real?*                          (unspecified))
(define *pair?*                          (unspecified))
(define *input-port?*                    (unspecified))
(define *output-port?*                   (unspecified))
(define *string?*                        (unspecified))
(define *struct?*                        (unspecified))
(define *symbol?*                        (unspecified))
(define *vector?*                        (unspecified))
(define *type-error*                     (unspecified))
(define *=fx*                            (unspecified))
(define *<=fx*                           (unspecified))
(define *negfx*                          (unspecified))
(define *-fx*                            (unspecified))
(define *procedure-correct-arity?*       (unspecified))
(define *va-procedure?*                  (unspecified))
(define *unspecified*                    (unspecified))
(define *cell-ref*                       (unspecified))
(define *cell-set*                       (unspecified))
(define *make-cell*                      (unspecified))
(define *procedure-entry*                (unspecified))
(define *procedure-light-entry*          (unspecified))
(define *make-fx-procedure*              (unspecified))
(define *make-extra-light-procedure*     (unspecified))
(define *make-light-procedure*           (unspecified))
(define *make-va-procedure*              (unspecified))
(define *procedure-env-ref*              (unspecified))
(define *procedure-env-set!*             (unspecified))
(define *procedure-light-env-ref*        (unspecified))
(define *procedure-light-env-set!*       (unspecified))
(define *procedure-extra-light-env-ref*  (unspecified))
(define *procedure-extra-light-env-set!* (unspecified))
(define *list->vector*                   (unspecified))
(define *define-primop-ref*              (unspecified))
(define *define-primop*                  (unspecified))
(define *location*                       (unspecified))
(define *eval*                           (unspecified))
(define *load*                           (unspecified))
(define *loadq*                          (unspecified))
(define *repl*                           (unspecified))
(define *abstract-type-tester*           (unspecified))
(define *abstract-fx-arithmetic-tester*  (unspecified))
(define *abstract-fx-arithmetic-op*      (unspecified))

;*---------------------------------------------------------------------*/
;*    abstract-init! ...                                               */
;*---------------------------------------------------------------------*/
(define (abstract-init!)
   (set! *nil*                        (require '__nil__))
   (set! *eoa*                        (require '__eoa__))
   (set! *false*                      (require 'c-false))
   (set! *true*                       (require 'c-true))
   (set! *cons*                       (require 'c-cons))
   (set! *O3cons*                     (require 'c-O3cons))
   (set! *car*                        (require 'c-car))
   (set! *cdr*                        (require 'c-cdr))
   (set! *null?*                      (require 'c-null?))
   (set! *length*                     (require 'length))
   (set! *bbool->cbool*               (require 'c-bbool->cbool))
   (set! *cbool->bbool*               (require 'c-cbool->bbool))
   (set! *cint->bint*                 (require 'c-cint->bint))
   (set! *bint->cint*                 (require 'c-bint->cint))
   (set! *string->symbol*             (require 'c-string->symbol))
   (set! *cstring->bstring*           (require 'c-cstring->bstring))
   (set! *bstring->cstring*           (require 'c-bstring->cstring))
   (set! *cchar->bchar*               (require 'c-cchar->bchar))
   (set! *bchar->cchar*               (require 'c-bchar->cchar))
   (set! *cdouble->breal*             (require 'c-cdouble->breal))
   (set! *breal->cdouble*             (require 'c-breal->cdouble))
   (set! *csymbol->bsymbol*           (require 'c-string->symbol))
   (set! *boolean?*                   (require 'c-boolean?))
   (set! *not*                        (require 'c-not))
   (set! *char?*                      (require 'c-char?))
   (set! *procedure?*                 (require 'c-procedure?))
   (set! *procedure-light?*           (require 'c-procedure-light?))
   (set! *integer?*                   (require 'c-integer?))
   (set! *real?*                      (require 'c-real?))
   (set! *pair?*                      (require 'c-pair?))
   (set! *input-port?*                (require 'c-input-port?))
   (set! *output-port?*               (require 'c-output-port?))
   (set! *string?*                    (require 'c-string?))
   (set! *struct?*                    (require 'c-struct?))
   (set! *symbol?*                    (require 'c-symbol?))
   (set! *vector?*                    (require 'c-vector?))
   (set! *type-error*                 (require 'type-error))
   (set! *=fx*                        (require 'c-eq.i))
   (set! *<=fx*                       (require 'c-le.i))
   (set! *negfx*                      (require 'c-neg.i))
   (set! *-fx*                        (require 'c-sub.i))
   (set! *procedure-correct-arity?*   (require 'procedure-correct-arity?))
   (set! *va-procedure?*              (require 'va-procedure?))
   (set! *unspecified*                (require 'unspec))
   (set! *cell-ref*                   (require 'cell-ref))
   (set! *cell-set*                   (require 'cell-set!))
   (set! *make-cell*                  (require 'make-cell))
   (set! *procedure-entry*            (require 'procedure-entry))
   (set! *procedure-light-entry*      (require 'procedure-light-entry))
   (set! *make-fx-procedure*          (require 'make-fx-procedure))
   (set! *make-light-procedure*       (require 'make-light-procedure))
   (set! *make-extra-light-procedure* (require 'make-extra-light-procedure))
   (set! *make-va-procedure*          (require 'make-va-procedure))
   (set! *procedure-env-ref*          (require 'procedure-env-ref))
   (set! *procedure-env-set!*         (require 'procedure-env-set!))
   (set! *procedure-light-env-ref*    (require 'procedure-light-env-ref))
   (set! *procedure-light-env-set!*   (require 'procedure-light-env-set!))
   (set! *procedure-extra-light-env-ref*
	 (require 'procedure-extra-light-env-ref))
   (set! *procedure-extra-light-env-set!*
	 (require 'procedure-extra-light-env-set!))
   (set! *list->vector*               (require 'list->vector))
   (set! *define-primop-ref*          (require 'define-primop-ref!))
   (set! *define-primop*              (require 'define-primop!))
   (set! *location*                   (require 'location))
   (set! *eval*                       (require 'eval))
   (set! *repl*                       (require 'repl))
   (set! *loadq*                      (require 'loadq))
   (set! *load*                       (require 'load))
   (set! *abstract-type-tester*       (list *va-procedure?*
					    *vector?*
					    *symbol?*
					    *struct?*
					    *string?*
					    *output-port?*
					    *input-port?*
					    *pair?*
					    *null?*
					    *real?*
					    *integer?*
					    *procedure?*
					    *char?*
					    *boolean?*
					    *procedure-correct-arity?*))
   (set! *abstract-fx-arithmetic-tester* (list *=fx*
					       *<=fx*
					       (require 'c-eq.i)
					       (require 'c-lt.i)
					       (require 'c-gt.i)
					       (require 'c-ge.i)))
   (set! *abstract-fx-arithmetic-op*  (list (require 'c-add.i)
					    *negfx*
					    *-fx*
					    (require 'c-add-ptag.i)
					    (require 'c-sub-ptag.i)
					    (require 'c-psub-tag)
					    (require 'c-padd-tag)
					    (require 'c-mul.i)
					    (require 'c-div.i))))

;*---------------------------------------------------------------------*/
;*    require ...                                                      */
;*---------------------------------------------------------------------*/
(define (require var)
   (let ((global (find-in-global-environment var *Genv*)))
      (if (not (global? global))
	  (error "require" "Can't find library function" var)
	  (begin
	     (putprop! var 'heap global)
	     global))))

;*---------------------------------------------------------------------*/
;*    abstract-nil ...                                                 */
;*---------------------------------------------------------------------*/
(define (abstract-nil)
   *nil*)

;*---------------------------------------------------------------------*/
;*    abstract-eoa ...                                                 */
;*---------------------------------------------------------------------*/
(define (abstract-eoa)
   *eoa*)

;*---------------------------------------------------------------------*/
;*    abstract-false ...                                               */
;*---------------------------------------------------------------------*/
(define (abstract-false)
   *false*)

;*---------------------------------------------------------------------*/
;*    abstract-false? ...                                              */
;*---------------------------------------------------------------------*/
(define (abstract-false? exp)
   (eq? exp *false*))

;*---------------------------------------------------------------------*/
;*    abstract-true ...                                                */
;*---------------------------------------------------------------------*/
(define (abstract-true)
   *true*)

;*---------------------------------------------------------------------*/
;*    abstract-true? ...                                               */
;*---------------------------------------------------------------------*/
(define (abstract-true? exp)
   (eq? *true* exp))

;*---------------------------------------------------------------------*/
;*    abstract-cons ...                                                */
;*---------------------------------------------------------------------*/
(define (abstract-cons a d)
   `(,*cons* ,a ,d))

;*---------------------------------------------------------------------*/
;*    abstract-cons? ...                                               */
;*---------------------------------------------------------------------*/
(define (abstract-cons? exp)
   (eq? exp *cons*))

;*---------------------------------------------------------------------*/
;*    abstract-car ...                                                 */
;*---------------------------------------------------------------------*/
(define (abstract-car exp)
   `(,*car* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-car? ...                                                */
;*---------------------------------------------------------------------*/
(define (abstract-car? exp)
   (eq? *car* exp))

;*---------------------------------------------------------------------*/
;*    abstract-cdr ...                                                 */
;*---------------------------------------------------------------------*/
(define (abstract-cdr exp)
   `(,*cdr* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-cdr? ...                                                */
;*---------------------------------------------------------------------*/
(define (abstract-cdr? exp)
   (eq? *cdr* exp))

;*---------------------------------------------------------------------*/
;*    abstract-null? ...                                               */
;*---------------------------------------------------------------------*/
(define (abstract-null? exp)
   `(,*null?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-length ...                                              */
;*---------------------------------------------------------------------*/
(define (abstract-length exp)
   `(,*length* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-bbool->cbool ...                                        */
;*---------------------------------------------------------------------*/
(define (abstract-bbool->cbool exp)
   `(,*bbool->cbool* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-bbool->cbool? ...                                       */
;*---------------------------------------------------------------------*/
(define (abstract-bbool->cbool? exp)
   (eq? *bbool->cbool* exp))

;*---------------------------------------------------------------------*/
;*    abstract-cbool->bbool ...                                        */
;*---------------------------------------------------------------------*/
(define (abstract-cbool->bbool exp)
   `(,*cbool->bbool* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-cbool->bbool? ...                                       */
;*---------------------------------------------------------------------*/
(define (abstract-cbool->bbool? exp)
   (eq? *cbool->bbool* exp))

;*---------------------------------------------------------------------*/
;*   abstract-cint->bint ...                                           */
;*---------------------------------------------------------------------*/
(define (abstract-cint->bint exp)
   `(,*cint->bint* ,exp))

;*---------------------------------------------------------------------*/
;*   abstract-bint->cint ...                                           */
;*---------------------------------------------------------------------*/
(define (abstract-bint->cint exp)
   `(,*bint->cint* ,exp))

;*---------------------------------------------------------------------*/
;*   abstract-cint->bint? ...                                          */
;*---------------------------------------------------------------------*/
(define (abstract-cint->bint? exp)
   (eq? exp *cint->bint*))

;*---------------------------------------------------------------------*/
;*   abstract-bint->cint? ...                                          */
;*---------------------------------------------------------------------*/
(define (abstract-bint->cint? exp)
   (eq? *bint->cint* exp))

;*---------------------------------------------------------------------*/
;*    abstract-string->symbol ...                                      */
;*---------------------------------------------------------------------*/
(define (abstract-string->symbol exp)
   `(,*string->symbol* ,exp))

;*---------------------------------------------------------------------*/
;*   abstract-cstring->bstring ...                                     */
;*---------------------------------------------------------------------*/
(define (abstract-cstring->bstring exp)
   `(,*cstring->bstring* ,exp))

;*---------------------------------------------------------------------*/
;*   abstract-cstring->bstring? ...                                    */
;*---------------------------------------------------------------------*/
(define (abstract-cstring->bstring? exp)
   (eq? *cstring->bstring* exp))

;*---------------------------------------------------------------------*/
;*   abstract-bstring->cstring ...                                     */
;*---------------------------------------------------------------------*/
(define (abstract-bstring->cstring exp)
   `(,*bstring->cstring* ,exp))

;*---------------------------------------------------------------------*/
;*   abstract-cchar->bchar ...                                         */
;*---------------------------------------------------------------------*/
(define (abstract-cchar->bchar exp)
   `(,*cchar->bchar* ,exp))

;*---------------------------------------------------------------------*/
;*   abstract-bchar->cchar ...                                         */
;*---------------------------------------------------------------------*/
(define (abstract-bchar->cchar exp)
   `(,*bchar->cchar* ,exp))

;*---------------------------------------------------------------------*/
;*   abstract-cdouble->breal ...                                       */
;*---------------------------------------------------------------------*/
(define (abstract-cdouble->breal exp)
   `(,*cdouble->breal* ,exp))

;*---------------------------------------------------------------------*/
;*   abstract-breal->cdouble ...                                       */
;*---------------------------------------------------------------------*/
(define (abstract-breal->cdouble exp)
   `(,*breal->cdouble* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-boolean? ...                                            */
;*---------------------------------------------------------------------*/
(define (abstract-boolean? exp)
   `(,*boolean?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-boolean?? ...                                           */
;*---------------------------------------------------------------------*/
(define (abstract-boolean?? exp)
   (eq? *boolean?* exp))

;*---------------------------------------------------------------------*/
;*    abstract-not? ...                                                */
;*---------------------------------------------------------------------*/
(define (abstract-not? exp)
   (eq? *not* exp))

;*---------------------------------------------------------------------*/
;*    abstract-char? ...                                               */
;*---------------------------------------------------------------------*/
(define (abstract-char? exp)
   `(,*char?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-char?? ...                                              */
;*---------------------------------------------------------------------*/
(define (abstract-char?? exp)
   (eq? *char?* exp))

;*---------------------------------------------------------------------*/
;*    abstract-procedure? ...                                          */
;*---------------------------------------------------------------------*/
(define (abstract-procedure? exp)
   `(,*procedure?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-procedure-light? ...                                    */
;*---------------------------------------------------------------------*/
(define (abstract-procedure-light? exp)
   `(,*procedure-light?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-procedure?? ...                                         */
;*---------------------------------------------------------------------*/
(define (abstract-procedure?? exp)
   (eq? *procedure?* exp))

;*---------------------------------------------------------------------*/
;*    abstract-integer? ...                                            */
;*---------------------------------------------------------------------*/
(define (abstract-integer? exp)
   `(,*integer?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-integer?? ...                                           */
;*---------------------------------------------------------------------*/
(define (abstract-integer?? exp)
   (eq? *integer?* exp))

;*---------------------------------------------------------------------*/
;*    abstract-real? ...                                               */
;*---------------------------------------------------------------------*/
(define (abstract-real? exp)
   `(,*real?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-real?? ...                                              */
;*---------------------------------------------------------------------*/
(define (abstract-real?? exp)
   (eq? *real?* exp))

;*---------------------------------------------------------------------*/
;*    abstract-pair? ...                                               */
;*---------------------------------------------------------------------*/
(define (abstract-pair? exp)
   `(,*pair?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-pair?? ...                                              */
;*---------------------------------------------------------------------*/
(define (abstract-pair?? exp)
   (eq? *pair?* exp))

;*---------------------------------------------------------------------*/
;*    abstract-vector? ...                                             */
;*---------------------------------------------------------------------*/
(define (abstract-vector? exp)
   `(,*vector?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-vector?? ...                                            */
;*---------------------------------------------------------------------*/
(define (abstract-vector?? exp)
   (eq? *vector?* exp))

;*---------------------------------------------------------------------*/
;*    abstract-input-port? ...                                         */
;*---------------------------------------------------------------------*/
(define (abstract-input-port? exp)
   `(,*input-port?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-input-port?? ...                                        */
;*---------------------------------------------------------------------*/
(define (abstract-input-port?? exp)
   (eq? *input-port?* exp))

;*---------------------------------------------------------------------*/
;*    abstract-output-port?? ...                                       */
;*---------------------------------------------------------------------*/
(define (abstract-output-port?? exp)
   (eq? *output-port?* exp))

;*---------------------------------------------------------------------*/
;*    abstract-output-port? ...                                        */
;*---------------------------------------------------------------------*/
(define (abstract-output-port? exp)
   `(,*output-port?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-string? ...                                             */
;*---------------------------------------------------------------------*/
(define (abstract-string? exp)
   `(,*string?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-string?? ...                                            */
;*---------------------------------------------------------------------*/
(define (abstract-string?? exp)
   (eq? *string?* exp))

;*---------------------------------------------------------------------*/
;*    abstract-struct? ...                                             */
;*---------------------------------------------------------------------*/
(define (abstract-struct? exp)
   `(,*struct?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-struct?? ...                                            */
;*---------------------------------------------------------------------*/
(define (abstract-struct?? exp)
   (eq? *struct?* exp))

;*---------------------------------------------------------------------*/
;*    abstract-symbol? ...                                             */
;*---------------------------------------------------------------------*/
(define (abstract-symbol? exp)
   `(,*symbol?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-symbol?? ...                                            */
;*---------------------------------------------------------------------*/
(define (abstract-symbol?? exp)
   (eq? *symbol?* exp))

;*---------------------------------------------------------------------*/
;*    abstract-type-error ...                                          */
;*---------------------------------------------------------------------*/
(define (abstract-type-error type name)
   `(,*type-error* ,type ,name))

;*---------------------------------------------------------------------*/
;*    abstract-=fx ...                                                 */
;*---------------------------------------------------------------------*/
(define (abstract-=fx e1 e2)
   `(,*=fx* ,e1 ,e2))

;*---------------------------------------------------------------------*/
;*    abstract-=fx? ...                                                */
;*---------------------------------------------------------------------*/
(define (abstract-=fx? fun)
   (eq? fun *=fx*))

;*---------------------------------------------------------------------*/
;*    abstract-<=fx ...                                                */
;*---------------------------------------------------------------------*/
(define (abstract-<=fx e1 e2)
   `(,*<=fx* ,e1 ,e2))

;*---------------------------------------------------------------------*/
;*    abstract-<=fx? ...                                               */
;*---------------------------------------------------------------------*/
(define (abstract-<=fx? fun)
   (eq? fun *<=fx*))

;*---------------------------------------------------------------------*/
;*    abstract-negfx ...                                               */
;*---------------------------------------------------------------------*/
(define (abstract-negfx e)
   `(,*negfx* ,e))

;*---------------------------------------------------------------------*/
;*    abstract--fx ...                                                 */
;*---------------------------------------------------------------------*/
(define (abstract--fx e1 e2)
   `(,*-fx* ,e1 ,e2))

;*---------------------------------------------------------------------*/
;*    abstract-va-procedure? ...                                       */
;*---------------------------------------------------------------------*/
(define (abstract-va-procedure? exp)
   `(,*va-procedure?* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-va-procedure?? ...                                      */
;*---------------------------------------------------------------------*/
(define (abstract-va-procedure?? exp)
   (eq? *va-procedure?* exp))

;*---------------------------------------------------------------------*/
;*    abstract-csymbol->bsymbol ...                                    */
;*---------------------------------------------------------------------*/
(define (abstract-csymbol->bsymbol exp)
   `(,*csymbol->bsymbol* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-csymbol->bsymbol? ...                                   */
;*---------------------------------------------------------------------*/
(define (abstract-csymbol->bsymbol? exp)
   (eq? *csymbol->bsymbol* exp))

;*---------------------------------------------------------------------*/
;*    abstract-unspecified ...                                         */
;*---------------------------------------------------------------------*/
(define (abstract-unspecified)
   *unspecified*)

;*---------------------------------------------------------------------*/
;*    abstract-cell-ref ...                                            */
;*---------------------------------------------------------------------*/
(define (abstract-cell-ref cell)
   `(,*cell-ref* ,cell))

;*---------------------------------------------------------------------*/
;*    abstract-cell-ref? ...                                           */
;*---------------------------------------------------------------------*/
(define (abstract-cell-ref? fun)
   (eq? fun *cell-ref*))

;*---------------------------------------------------------------------*/
;*    abstract-cell-set! ...                                           */
;*---------------------------------------------------------------------*/
(define (abstract-cell-set! exp)
   (set-car! exp *cell-set*))

;*---------------------------------------------------------------------*/
;*    abstract-cell-set!? ...                                          */
;*---------------------------------------------------------------------*/
(define (abstract-cell-set!? fun)
   (eq? fun *cell-set*))

;*---------------------------------------------------------------------*/
;*    abstract-make-cell ...                                           */
;*---------------------------------------------------------------------*/
(define (abstract-make-cell val)
   `(,*make-cell* ,val))

;*---------------------------------------------------------------------*/
;*    abstract-make-cell? ...                                          */
;*---------------------------------------------------------------------*/
(define (abstract-make-cell? fun)
   (eq? fun *make-cell*))

;*---------------------------------------------------------------------*/
;*    abstract-procedure-entry ...                                     */
;*---------------------------------------------------------------------*/
(define (abstract-procedure-entry proc)
   `(,*procedure-entry* ,proc))

;*---------------------------------------------------------------------*/
;*    abstract-procedure-light-entry ...                               */
;*---------------------------------------------------------------------*/
(define (abstract-procedure-light-entry proc)
   `(,*procedure-light-entry* ,proc))

;*---------------------------------------------------------------------*/
;*    abstract-make-fx-procedure ...                                   */
;*---------------------------------------------------------------------*/
(define (abstract-make-fx-procedure entry arity size)
   `(,*make-fx-procedure* ,entry ,arity ,size))

;*---------------------------------------------------------------------*/
;*    abstract-make-light-procedure ...                                */
;*---------------------------------------------------------------------*/
(define (abstract-make-light-procedure entry size)
   `(,*make-light-procedure* ,entry ,size))

;*---------------------------------------------------------------------*/
;*    abstract-make-extra-light-procedure ...                          */
;*---------------------------------------------------------------------*/
(define (abstract-make-extra-light-procedure size)
   `(,*make-extra-light-procedure* ,size))

;*---------------------------------------------------------------------*/
;*    abstract-make-fx-procedure? ...                                  */
;*---------------------------------------------------------------------*/
(define (abstract-make-fx-procedure? exp)
   (eq? exp *make-fx-procedure*))

;*---------------------------------------------------------------------*/
;*    abstract-make-va-procedure ...                                   */
;*---------------------------------------------------------------------*/
(define (abstract-make-va-procedure entry arity size)
   `(,*make-va-procedure* ,entry ,arity ,size))

;*---------------------------------------------------------------------*/
;*    abstract-make-va-procedure? ...                                  */
;*---------------------------------------------------------------------*/
(define (abstract-make-va-procedure? exp)
   (eq? exp *make-va-procedure*))

;*---------------------------------------------------------------------*/
;*    abstract-make-light-procedure? ...                               */
;*---------------------------------------------------------------------*/
(define (abstract-make-light-procedure? exp)
   (eq? exp *make-light-procedure*))

;*---------------------------------------------------------------------*/
;*    abstract-procedure-env-ref ...                                   */
;*---------------------------------------------------------------------*/
(define (abstract-procedure-env-ref proc indice)
   `(,*procedure-env-ref* ,proc ,indice))

;*---------------------------------------------------------------------*/
;*    abstract-procedure-env-set! ...                                  */
;*---------------------------------------------------------------------*/
(define (abstract-procedure-env-set! proc indice value)
   `(,*procedure-env-set!* ,proc ,indice ,value))

;*---------------------------------------------------------------------*/
;*    abstract-procedure-light-env-ref ...                             */
;*---------------------------------------------------------------------*/
(define (abstract-procedure-light-env-ref proc indice)
   `(,*procedure-light-env-ref* ,proc ,indice))

;*---------------------------------------------------------------------*/
;*    abstract-procedure-light-env-set! ...                            */
;*---------------------------------------------------------------------*/
(define (abstract-procedure-light-env-set! proc indice value)
   `(,*procedure-light-env-set!* ,proc ,indice ,value))

;*---------------------------------------------------------------------*/
;*    abstract-procedure-extra-light-env-ref ...                       */
;*---------------------------------------------------------------------*/
(define (abstract-procedure-extra-light-env-ref proc indice)
   `(,*procedure-extra-light-env-ref* ,proc ,indice))

;*---------------------------------------------------------------------*/
;*    abstract-procedure-extra-light-env-set! ...                      */
;*---------------------------------------------------------------------*/
(define (abstract-procedure-extra-light-env-set! proc indice value)
   `(,*procedure-extra-light-env-set!* ,proc ,indice ,value))

;*---------------------------------------------------------------------*/
;*    abstract-list->vector ...                                        */
;*---------------------------------------------------------------------*/
(define (abstract-list->vector list)
   `(,*list->vector* ,list))

;*---------------------------------------------------------------------*/
;*    abstract-define-primop-ref ...                                   */
;*---------------------------------------------------------------------*/
(define (abstract-define-primop-ref name ref)
   `(,*define-primop-ref* ,name ,ref))

;*---------------------------------------------------------------------*/
;*    abstract-define-primop ...                                       */
;*---------------------------------------------------------------------*/
(define (abstract-define-primop name obj)
   `(,*define-primop* ,name ,obj))

;*---------------------------------------------------------------------*/
;*    abstract-location ...                                            */
;*---------------------------------------------------------------------*/
(define (abstract-location obj)
   `(,*location* ,obj))

;*---------------------------------------------------------------------*/
;*    abstract-eval? ...                                               */
;*---------------------------------------------------------------------*/
(define (abstract-eval? o)
   (and (global? o)
	(or (eq? o *eval*)
	    (eq? o *repl*)
	    (eq? o *load*)
	    (eq? o *loadq*))))

;*---------------------------------------------------------------------*/
;*    abstract-eval ...                                                */
;*---------------------------------------------------------------------*/
(define (abstract-eval exp)
   `(,*eval* ,exp))

;*---------------------------------------------------------------------*/
;*    abstract-type-tester ...                                         */
;*---------------------------------------------------------------------*/
(define (abstract-type-tester)
   *abstract-type-tester*)

;*---------------------------------------------------------------------*/
;*    abstract-fx-arithmetic-tester ...                                */
;*---------------------------------------------------------------------*/
(define (abstract-fx-arithmetic-tester)
   *abstract-fx-arithmetic-tester*)

;*---------------------------------------------------------------------*/
;*    abstract-fx-arithmetic-op ...                                    */
;*---------------------------------------------------------------------*/
(define (abstract-fx-arithmetic-op)
   *abstract-fx-arithmetic-op*)

;*---------------------------------------------------------------------*/
;*    abstract-special-no-cost? ...                                    */
;*    -------------------------------------------------------------    */
;*    Un truc tres special: ce predicat retourne #t si la forme est    */
;*    un appel a une fonction qui ne coute rien !                      */
;*---------------------------------------------------------------------*/
(define (abstract-special-no-cost? exp)
   (and (pair? exp)
	(global? (car exp))
	(or (abstract-bbool->cbool? (car exp))
	    (abstract-cbool->bbool? (car exp)))))

;*---------------------------------------------------------------------*/
;*    abstract ...                                                     */
;*    -------------------------------------------------------------    */
;*    On construit une forme runtime.                                  */
;*---------------------------------------------------------------------*/
(define (abstract name . args)
   (let ((glo (let ((heap-val (getprop name 'heap)))
		 (if heap-val
		     heap-val
		     (let ((glo (find-in-global-environment name *Genv*)))
			(putprop! name 'heap glo)
			glo)))))
      (if (not (global? glo))
	  (error "abstract" "Can't find function" name)
	  `(,glo ,@args))))

;*---------------------------------------------------------------------*/
;*    abstract? ...                                                    */
;*    -------------------------------------------------------------    */
;*    On teste une forme runtime.                                      */
;*---------------------------------------------------------------------*/
(define (abstract? obj . names)
   (let loop ((ns names))
      (if (null? ns)
	  #f
	  (let ((glo (let ((heap-val (getprop (car ns) 'heap)))
			(if heap-val
			    heap-val
			    (let ((glo (find-in-global-environment (car ns)
								   *Genv*)))
			       (putprop! (car ns) 'heap glo)
			       glo)))))
	     (cond
		((not (global? glo))
		 (error "abstract?" "Can't find function" (car names)))
		((eq? glo obj)
		 #t)
		(else
		 (loop (cdr ns))))))))

