;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../parse.scm ...                                                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Oct 19 09:43:24 1993                          */
;*    Last change :  Tue Jan  4 15:03:56 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On verifie un test de type, et en meme temps, on le definit      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module foreign_parse
   (import  tools_error
	    tools_args
	    foreign_tools
	    foreign_declare)
   (export  (parse-type type)))

;*---------------------------------------------------------------------*/
;*    user-foreign-type? ...                                           */
;*---------------------------------------------------------------------*/
(define (user-foreign-type? exp)
   (match-case exp
      ((? symbol?)
       #t)
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    parse-type ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-type type)
   (match-case type
      ((type (atom ?type-user-id) ?type-user-exp)
       (let (type-id type-name)
	  (cond
	     ((symbol? type-user-id)
	      (set! type-id type-user-id)
	      (set! type-name (symbol->string type-user-id)))
	     ((string? type-user-id)
	      (set! type-id (string->symbol (string-upcase type-user-id)))
	      (set! type-name type-user-id))
	     (else
	      (partial-error "parse-type" "Illegal `foreign type'" type)))
	  (cond
;*--- Encore une erreur possible --------------------------------------*/
	     ((null? type-user-exp)
	      (partial-error "parse-type" "Illegal `foreign type'" type))
	     (else
;*--- Les types `entiers' ---------------------------------------------*/
	      (match-case type-user-exp
		 ((atom ?a)
		  (case a
		     ((short int long signed unsigned short-int
			     signed-short-int signed-int long-int signed-long
			     signed-long-int unsigned-short unsigned-short-int
			     unsigned unsigned-int unsigned-long
			     unsigned-long-int)
		      (declare-integer type-id type-name a))
		     ((char signed-char unsigned-char)
		      (declare-char type-id type-name a))
		     ((float double long-double)
		      (declare-float type-id type-name a))
		     (else
		      (declare-alias type-id a))))
;*--- Les pointers ----------------------------------------------------*/
		 ((pointer (and ?of (? symbol?)))
		  (declare-pointer type-id of))
;*--- Les tableaux ----------------------------------------------------*/
		 ((array (and ?of (? user-foreign-type?)))
		  (declare-unbound-array type-id of))
		 ((array (and ?of (? user-foreign-type?))
			 (and ?min (or (? symbol?) (? integer?)))
			 (and ?max (or (? symbol?) (? integer?))))
		  (declare-bound-array type-id of min max))
;*--- les structures & les unions -------------------------------------*/
		 (((or struct union) ?slots . ?rest)
		  (let ((name (if (pair? rest)
				  (if (string? (car rest))
				      (car rest)
				      (partial-error "parse-type"
						     "Illegal 'foreign-type'"
						     type))
				  (string-append "struct " type-name))))
		     (let loop ((fields slots))
			(if (null? fields)
			    (declare-struct/union type-id slots name)
			    (match-case (car fields)
			       (((? user-foreign-type?) (? string?))
				(loop (cdr fields)))
			       ((bitfield (? integer?)
					  (? user-foreign-type?) (? string?))
				(loop (cdr fields)))
			       (else
				(partial-error "parse-type"
					       "Illegal `foreign-type'"
					       type)))))))
;*--- Les fonctions ---------------------------------------------------*/
		 ((function (and ?to (? user-foreign-type?))
			    (and ?_froms (? pair?)))
		  (let loop ((froms _froms))
		     (cond
			((null? froms)
			 (declare-function type-id to _froms))
			((not (user-foreign-type? (car froms)))
			 (partial-error "parse-type"
					"Illegal `foreign type'"
					type))
			(else
			 (loop (cdr froms))))))
;*--- Les subtypes ----------------------------------------------------*/
		 ((subtype (and ?from (? symbol?))
			   (and ?from->to (? symbol?))
			   (and ?to->from (? symbol?)))
		  (declare-subtype type-id type-name from from->to to->from))
;*--- Les erreurs -----------------------------------------------------*/
		 (else
		  (partial-error "parse-type"
				 "Illegal `foreign type'"
				 type)))))))))
 
   
