;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Expand/map.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Dec  4 18:08:53 1992                          */
;*    Last change :  Tue Dec 14 16:39:38 1993 (serrano)                */
;*                                                                     */
;*    La macro-expansion de `map' et `for-each'                        */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_map
   (import tools_error)
   (export (expand-map      x e)
	   (expand-for-each x e)))

;*---------------------------------------------------------------------*/
;*    expand-map ...                                                   */
;*---------------------------------------------------------------------*/
(define (expand-map x e)
   (match-case x
      ((?- ?fun ?list)
       (let ((l (gensym)))
	  (e `(let ((,l ,list))
		 (if (null? ,l)
		     '()
		     ,(match-case fun
			 ((or (lambda . ?-)
			      (not (?- . ?-)))
			  ;; la fonction n'est pas un appel fonctionnel,
			  ;; on peut donc generer du code qui ne cons
			  ;; pas trop!
			  `(let ((head (cons (,fun (car ,l)) '())))
			      (let _loop_ ((,l    (cdr ,l))
					   (tail head))
				 (if (null? ,l)
				     head
				     (let ((new-tail 
					    (cons (,fun (car ,l))
						  '())))
					(set-cdr! tail new-tail)
					(_loop_ (cdr ,l)
						new-tail))))))
			 (else
			  `(let ((head (cons '() '())))
			      (let _loop_ ((,l    ,l)
					   (tail head))
				 (if (null? ,l)
				     (cdr head)
				     (let ((new-tail 
					    (cons (,fun (car ,l))
						  '())))
					(set-cdr! tail new-tail)
					(_loop_ (cdr ,l)
						new-tail)))))))))
	     e)))
      ((?- ?fun ?l1 ?l2)
       (let ((ll1 (gensym))
	     (ll2 (gensym)))
	  (e `(let ((,ll1 ,l1)
		    (,ll2 ,l2))
		 (if (null? ,ll1)
		     '()
		     ,(match-case fun
			 ((or (lambda . ?-)
			      (not (?- . ?-)))
			  ;; la fonction n'est pas un appel fonctionnel,
			  ;; on peut donc generer du code qui ne cons pas trop!
			  `(let ((head (cons (,fun (car ,ll1) (car ,ll2))
					     '())))
			      (let _loop_ ((,ll1   (cdr ,ll1))
					   (,ll2   (cdr ,ll2))
					   (tail head))
				 (if (null? ,ll1)
				     head
				     (let ((new-tail 
					    (cons (,fun (car ,ll1) (car ,ll2))
						  '())))
					(set-cdr! tail new-tail)
					(_loop_ (cdr ,ll1)
						(cdr ,ll2)
						new-tail))))))
			 (else
			  `(let ((head (cons '() '())))
			      (let _loop_ ((,ll1   ,ll1)
					   (,ll2   ,ll2)
					   (tail head))
				 (if (null? ,ll1)
				     (cdr head)
				     (let ((new-tail 
					    (cons (,fun (car ,ll1) (car ,ll2))
						  '())))
					(set-cdr! tail new-tail)
					(_loop_ (cdr ,ll1)
						(cdr ,ll2)
						new-tail)))))))))
	     e)))
      ((?- ?fun . ?lists)
       `(map ,(e fun e)
	     ,@(map (lambda (l) (e l e)) lists)))
      (else
       (partial-error "map" "Illegal `map' form" x))))

;*---------------------------------------------------------------------*/
;*    expand-for-each ...                                              */
;*---------------------------------------------------------------------*/
(define (expand-for-each x e)
   (match-case x
      ((?- ?fun ?list)
       (let ((l (gensym)))
	  (e `(let _loop_ ((,l ,list))
		 (if (null? ,l)
		     #t
		     (begin
			(,fun (car ,l))
			(_loop_ (cdr ,l)))))
	     e)))
      ((?- ?fun ?l1 ?l2)
       (let ((ll1 (gensym))
	     (ll2 (gensym)))
	  (e `(let _loop_ ((,ll1 ,l1)
			   (,ll2 ,l2))
		 (if (null? ,ll1)
		     #t
		     (begin
			(,fun (car ,ll1) (car ,ll2))
			(_loop_ (cdr ,ll1) (cdr ,ll2)))))
	     e)))
      ((?- ?fun . ?lists)
       `(for-each ,(e fun e)
		  ,@(map (lambda (l) (e l e)) lists)))
      (else
       (partial-error "for-each" "Illegal `for-each' form" x))))
