;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Expand/cond.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun 18 10:38:45 1992                          */
;*    Last change :  Tue Dec 14 16:36:06 1993 (serrano)                */
;*                                                                     */
;*    L'expansion des formes conditionnelles                           */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_conditional
   (import tools_progn
	   tools_error
	   tools_strings
	   engine_param)
   (export (expand-cond exp)
	   (expand-or   exp)
	   (expand-and  exp)
	   (expand-test x e)))

;*---------------------------------------------------------------------*/
;*    expand-cond ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-cond exp)
   (let* ((clauses  (cdr exp))
	  (clause1  (if (pair? clauses)
			(car clauses)
			'()))
	  (clause2+ (if (pair? clause1)
			(cdr clauses)
			#f)))
      (cond
	 ((null? clause1)
	  '#f)
	 ((or (not (pair? clause1)) (equal? clause1 '(else)))
	  (partial-error "cond" "Illegal `cond' form" exp))
	 ((null? (cdr clause1))
	  `(or ,(car clause1) (cond ,@clause2+)))
	 ((and (eq? (cadr clause1) '=>) (=fx (length clause1) 3))
	  `(let ((test-result ,(car clause1))
		 (thunk2 (lambda () ,(caddr clause1)))
		 (thunk3 (lambda () (cond ,@clause2+))))
	      (if test-result ((thunk2) test-result) (thunk3))))
	 ((eq? (car clause1) 'else)
	  (normalize-progn (cdr clause1)))
	 (else `(if ,(car clause1)
		    ,(normalize-progn (cdr clause1))
		    (cond ,@clause2+))))))

;*---------------------------------------------------------------------*/
;*    get-new-test-name ...                                            */
;*---------------------------------------------------------------------*/
(define get-new-test-name
   (let ((counter -1))
      (lambda (string)
	 (set! counter (+fx 1 counter))
	 (upper-string->symbol (string-append "_" string "test_"
					      (integer->string counter))))))

;*---------------------------------------------------------------------*/
;*    expand-or ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-or exp)
   (let loop ((sor (cdr exp)))
      (cond
	 ((null? sor)
	  #f)
	 ((null? (cdr sor))
	  (car sor))
	 (else
	  (let ((test (get-new-test-name "or")))
	     `(let ((,test ,(car sor)))
		 (if ,test ,test ,(loop (cdr sor)))))))))

;*---------------------------------------------------------------------*/
;*    expand-and ...                                                   */
;*---------------------------------------------------------------------*/
(define (expand-and exp)
   (let loop ((sand (cdr exp)))
      (cond
	 ((null? sand)
	  #t)
	 ((null? (cdr sand))
	  (car sand))
	 (else
	  `(if ,(car sand)
	       ,(loop (cdr sand))
	       #f)))))

;*---------------------------------------------------------------------*/
;*    expand-test ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-test x e)
   (if *nil*
       (e x e)
       `(let ((test-aux-for-nil ,(e x e)))
	   (if test-aux-for-nil
	       (if (null? test-aux-for-nil)
		   #f
		   #t)
	       #f))))

