;;; -*-Scheme-*-
;;;
;;; Copyright (c) 1991 Massachusetts Institute of Technology
;;;
;;; This material was developed by the Scheme project at the
;;; Massachusetts Institute of Technology, Department of Electrical
;;; Engineering and Computer Science.  Permission to copy this
;;; software, to redistribute it, and to use it for any purpose is
;;; granted, subject to the following restrictions and understandings.
;;;
;;; 1. Any copy made of this software must include this copyright
;;; notice in full.
;;;
;;; 2. Users of this software agree to make their best efforts (a) to
;;; return to the MIT Scheme project any improvements or extensions
;;; that they make, so that these may be included in future releases;
;;; and (b) to inform MIT of noteworthy uses of this software.
;;;
;;; 3. All materials developed as a consequence of the use of this
;;; software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4. MIT has made no warrantee or representation that the operation
;;; of this software will be error-free, and MIT is under no
;;; obligation to provide any services, by way of maintenance, update,
;;; or otherwise.
;;;
;;; 5. In conjunction with products arising from the use of this
;;; material, there shall be no use of the name of the Massachusetts
;;; Institute of Technology nor of any adaptation thereof in any
;;; advertising, promotional, or sales literature without prior
;;; written consent from MIT in each case.

;;;; R4RS Global Environment

(define sc-transformer-environment #f)
(define er-transformer-environment #f)

(define (initialize-transformer-environments!)
  ;; Use host implementations's own definition of STRING-CI<? to
  ;; decide on the proper sorting.  This is a merge sort.
  (let ((shared-bindings (shared-transformer-environment-bindings))
	(bindings->environment
	 (lambda (bindings)
	   (list (cons (list->vector (map car bindings))
		       (list->vector (map cdr bindings)))))))
    (letrec
	((sort
	  (lambda (l)
	    (if (and (pair? l) (pair? (cdr l)))
		(split l '() '())
		l)))
	 (split
	  (lambda (l one two)
	    (if (pair? l)
		(split (cdr l) two (cons (car l) one))
		(merge (sort one) (sort two)))))
	 (merge
	  (lambda (one two)
	    (cond ((null? one)
		   two)
		  ((string-ci<? (symbol->string (caar two))
				(symbol->string (caar one)))
		   (cons (car two)
			 (merge (cdr two) one)))
		  (else
		   (cons (car one)
			 (merge (cdr one) two)))))))
      (set! sc-transformer-environment
	    (bindings->environment
	     (sort (append (sc-transformer-environment-bindings)
			   shared-bindings))))
      (set! er-transformer-environment sc-transformer-environment)))
  'INITIALIZED)

(define (sc-transformer-environment-bindings)
  `(
    (make-syntactic-closure . ,make-syntactic-closure)
    (capture-syntactic-environment . ,capture-syntactic-environment)
    (identifier? . ,identifier?)
    (identifier=? . ,identifier=?)

    ;; referred to by SYNTAX-RULES
    (ill-formed-syntax . ,ill-formed-syntax)
    ))

(define (shared-transformer-environment-bindings)
  ;; If any of the following are missing from the host implementation,
  ;; just comment them out.  Inessential procedures are flagged to aid
  ;; you in this process.
  `(
    ;; 6.1
    (not . ,not)
    (boolean? . ,boolean?)

    ;; 6.2
    (eqv? . ,eqv?)
    (eq? . ,eq?)
    (equal? . ,equal?)

    ;; 6.3
    (pair? . ,pair?)
    (cons . ,cons)
    (car . ,car)
    (cdr . ,cdr)
    (set-car! . ,set-car!)
    (set-cdr! . ,set-cdr!)
    (caar . ,caar)
    (cadr . ,cadr)
    (cdar . ,cdar)
    (cddr . ,cddr)
    (caaar . ,caaar)
    (caadr . ,caadr)
    (cadar . ,cadar)
    (caddr . ,caddr)
    (cdaar . ,cdaar)
    (cdadr . ,cdadr)
    (cddar . ,cddar)
    (cdddr . ,cdddr)
    (caaaar . ,caaaar)
    (caaadr . ,caaadr)
    (caadar . ,caadar)
    (caaddr . ,caaddr)
    (cadaar . ,cadaar)
    (cadadr . ,cadadr)
    (caddar . ,caddar)
    (cadddr . ,cadddr)
    (cdaaar . ,cdaaar)
    (cdaadr . ,cdaadr)
    (cdadar . ,cdadar)
    (cdaddr . ,cdaddr)
    (cddaar . ,cddaar)
    (cddadr . ,cddadr)
    (cdddar . ,cdddar)
    (cddddr . ,cddddr)
    (null? . ,null?)
    (list? . ,list?)
    (list . ,list)
    (length . ,length)
    (append . ,append)
    (reverse . ,reverse)
    (list-tail . ,list-tail)		;inessential
    (list-ref . ,list-ref)
    (memq . ,memq)
    (memv . ,memv)
    (member . ,member)
    (assq . ,assq)
    (assv . ,assv)
    (assoc . ,assoc)

    ;; 6.4
    (symbol? . ,symbol?)
    (symbol->string . ,symbol->string)
    (string->symbol . ,string->symbol)

    ;; 6.5
    (number? . ,number?)
    (complex? . ,complex?)
    (real? . ,real?)
    (rational? . ,rational?)
    (integer? . ,integer?)
    (exact? . ,exact?)
    (inexact? . ,inexact?)
    (zero? . ,zero?)
    (positive? . ,positive?)
    (negative? . ,negative?)
    (odd? . ,odd?)
    (even? . ,even?)
    (max . ,max)
    (min . ,min)
    (+ . ,+)
    (* . ,*)
    (- . ,-)
    (/ . ,/)
    (abs . ,abs)
    (quotient . ,quotient)
    (remainder . ,remainder)
    (modulo . ,modulo)
    (gcd . ,gcd)
    (lcm . ,lcm)
    (numerator . ,numerator)		;inessential
    (denominator . ,denominator)	;inessential
    (floor . ,floor)
    (ceiling . ,ceiling)
    (truncate . ,truncate)
    (round . ,round)
    (rationalize . ,rationalize)	;inessential
    (exp . ,exp)			;inessential
    (log . ,log)			;inessential
    (sin . ,sin)			;inessential
    (cos . ,cos)			;inessential
    (tan . ,tan)			;inessential
    (asin . ,asin)			;inessential
    (acos . ,acos)			;inessential
    (atan . ,atan)			;inessential
    (sqrt . ,sqrt)			;inessential
    (expt . ,expt)			;inessential
    (make-rectangular . ,make-rectangular) ;inessential
    (make-polar . ,make-polar)		;inessential
    (real-part . ,real-part)		;inessential
    (imag-part . ,imag-part)		;inessential
    (magnitude . ,magnitude)		;inessential
    (angle . ,angle)			;inessential
    (exact->inexact . ,exact->inexact)	;inessential
    (inexact->exact . ,inexact->exact)	;inessential
    (number->string . ,number->string)
    (string->number . ,string->number)

    ;; 6.6
    (char? . ,char?)
    (char=? . ,char=?)
    (char<? . ,char<?)
    (char>? . ,char>?)
    (char<=? . ,char<=?)
    (char>=? . ,char>=?)
    (char-ci=? . ,char-ci=?)
    (char-ci<? . ,char-ci<?)
    (char-ci>? . ,char-ci>?)
    (char-ci<=? . ,char-ci<=?)
    (char-ci>=? . ,char-ci>=?)
    (char-alphabetic? . ,char-alphabetic?)
    (char-numeric? . ,char-numeric?)
    (char-whitespace? . ,char-whitespace?)
    (char-upper-case? . ,char-upper-case?)
    (char-lower-case? . ,char-lower-case?)
    (char->integer . ,char->integer)
    (integer->char . ,integer->char)
    (char-upcase . ,char-upcase)
    (char-downcase . ,char-downcase)

    ;; 6.7
    (string? . ,string?)
    (make-string . ,make-string)
    (string . ,string)
    (string-length . ,string-length)
    (string-ref . ,string-ref)
    (string-set! . ,string-set!)
    (string=? . ,string=?)
    (string-ci=? . ,string-ci=?)
    (string<? . ,string<?)
    (string>? . ,string>?)
    (string<=? . ,string<=?)
    (string>=? . ,string>=?)
    (string-ci<? . ,string-ci<?)
    (string-ci>? . ,string-ci>?)
    (string-ci<=? . ,string-ci<=?)
    (string-ci>=? . ,string-ci>=?)
    (substring . ,substring)
    (string-append . ,string-append)
    (string->list . ,string->list)
    (list->string . ,list->string)
    (string-copy . ,string-copy)	;inessential
    (string-fill! . ,string-fill!)	;inessential

    ;; 6.8
    (vector? . ,vector?)
    (make-vector . ,make-vector)
    (vector-length . ,vector-length)
    (vector-ref . ,vector-ref)
    (vector-set! . ,vector-set!)
    (vector->list . ,vector->list)
    (list->vector . ,list->vector)
    (vector-fill! . ,vector-fill!)	;inessential

    ;; 6.9
    (procedure? . ,procedure?)
    (apply . ,apply)
    (map . ,map)
    (for-each . ,for-each)
    (force . ,force)			;inessential
    (call-with-current-continuation . ,call-with-current-continuation)

    ;; 6.10
    (call-with-input-file . ,call-with-input-file)
    (call-with-output-file . ,call-with-output-file)
    (input-port? . ,input-port?)
    (output-port? . ,output-port?)
    (current-input-port . ,current-input-port)
    (current-output-port . ,current-output-port)
    (with-input-from-file . ,with-input-from-file) ;inessential
    (with-output-to-file . ,with-output-to-file) ;inessential
    (open-input-file . ,open-input-file)
    (open-output-file . ,open-output-file)
    (close-input-port . ,close-input-port)
    (close-output-port . ,close-output-port)
    (read . ,read)
    (read-char . ,read-char)
    (peek-char . ,peek-char)
    (eof-object? . ,eof-object?)
    (char-ready? . ,char-ready?)	;inessential
    (write . ,write)
    (display . ,display)
    (newline . ,newline)
    (write-char . ,write-char)
    (load . ,load)
    (transcript-on . ,transcript-on)	;inessential
    (transcript-off . ,transcript-off)	;inessential
    ))