;; -*- Scheme -*-
;;
;; $Id: mawk03.scm,v 1.4 1993/10/31 15:49:53 bevan Exp $

(require 'mawk:awk)

;;+doc
;; procedure: mawk:file
;; arguments: file action[line line-number]
;; signature: string x (string x int -> unspecified) -> unspecified
;; arguments: file action[line line-number]
;; signature: string x (string x int -> unspecified) -> unspecified
;; arguments: file action[line line-number state] state
;; signature: forall a => string x (string x int x a -> a) x a -> a
;;
;; Opens FILE as an input port and applies ACTION to each line read
;; from PORT (which is open on FILE).  If a third arguments is defined,
;; then this is taken to be the initial value for a STATE that is to be
;; threaded through the iteration over each line.  Note in this case
;; that ACTION also takes the STATE as a second argument.
;;-doc

(define mawk:file
  (lambda (f a . opt)
    (let ((ip (open-input-file f)))
      (let ((r (apply mawk:awk a ip opt)))
	(close-input-port ip)
	r))))

;; eof
