;\documentstyle[astyped,12pt,twoside,latexinfo]{report}
;
;\begin{document}
;
;\newindex{cp}
;\newindex{vr}
;\newindex{fn}
;\newindex{tp}
;\newindex{pg}
;\newindex{ky}
;
;
;\markboth{Taurus}{Taurus}
;\pagestyle{empty}
;\title{Taurus, a Generator for Error Recovering Parsers}
;
;\author{Pertti Kellom\"aki, {\tt pk@tut.fi}}
;
;\date{\today}
;\maketitle
;
;\clearpage
;\vspace{0pt plus 1filll}
;Copyright \copyright{} 1990 Pertti Kellom\"aki.
;
;\sp{2}
;This is version 1.0 of the parser generator Taurus.
;\sp{2}
;
;Permission is granted to make and distribute verbatim copies of
;this manual provided the copyright notice and this permission notice
;are preserved on all copies.
;
;Permission is granted to copy and distribute modified versions of this
;manual under the conditions for verbatim copying, provided that the entire
;resulting derived work is distributed under the terms of a permission
;notice identical to this one.
;
;Permission is granted to copy and distribute translations of this manual
;into another language, under the above conditions for modified versions,
;except that this permission notice may be stated in a translation approved
;by the author.
;
;\clearpage
;
;\pagestyle{headings}
;\pagenumbering{roman}
;\tableofcontents
;
;\clearpage
;\pagenumbering{arabic}
;
;\setfilename{taurus.info}
;\node Top, Licensing Information, (dir)Top, (dir)Top
;
;\begin{ifinfo}
;This file documents Taurus version 0.9, a parser generator that 
;produces Scheme.
;
;Copyright 1990 Pertti Kellomaki
;
;Permission is granted to make and distribute verbatim copies of
;this manual provided the copyright notice and this permission notice
;are preserved on all copies.
;
;\begin{ignore}
;Permission is granted to process this file through TeX and print the
;results, provided the printed document carries a copying permission
;notice identical to this one except for the removal of this 
;paragraph (this paragraph not being relevant to the printed manual).\refill
;
;\end{ignore}
;Permission is granted to copy and distribute modified versions of this
;manual under the conditions for verbatim copying, provided also that the
;sections entitled ``Distribution'' and ``General Public License'' are
;included exactly as in the original, and provided that the entire
;resulting derived work is distributed under the terms of a permission
;notice identical to this one.
;
;Permission is granted to copy and distribute translations of this manual
;into another language, under the above conditions for modified versions,
;except that the sections entitled ``Distribution'' and ``General Public
;License'' may be included in a translation approved by the author instead
;of in the original English.
;
;\end{ifinfo}
;
;\begin{menu}
;* Licensing Information::
;* Preface::
;* Distribution::
;* General Public License::
;* Overview::
;* Concept Index::
;* Procedure Index::
;\end{menu}
;
;\node Licensing Information, Preface, Top, Top
;\chapter*{Licensing Information}
;\cindex{Licensing Information}
;
;Taurus is distributed under the GNU General Public 
;License (\pxref{General Public License}), which basically means that you are
;free to do anything you like with it, but if you use portions of it in
;another piece of software, that software must also be distributed
;under the GNU General Public Licence.  The parsers that have been
;generated using Taurus are not, however, covered by the General Public
;License; they are public domain. This is done in order to allow users
;to do anything they want with the parsers they have created.
;
;
;\comment  node-name,  next,  previous,  up
;\node Preface, Distribution, Licensing Information, Top
;\chapter{Preface}
;\cindex{Preface}
;
;\c	    Copyright (C) 1990 Pertti Kellomaki
;\c	 
;\c	 This file is part of Taurus, a parser generator producing Scheme.
;\c	 
;\c	 Taurus is free software; you can redistribute it and/or modify
;\c	 it under the terms of the GNU General Public License as published by
;\c	 the Free Software Foundation; either version 1, or (at your option)
;\c	 any later version.
;\c	 
;\c	 Taurus is distributed in the hope that it will be useful,
;\c	 but WITHOUT ANY WARRANTY; without even the implied warranty of
;\c	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;\c	 GNU General Public License for more details.
;\c	 
;\c	 You should have received a copy of the GNU General Public License
;\c	 along with Taurus; see the file COPYING.  If not, write to
;\c	 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;
;
;This document describes Taurus, a parser generator written in the
;programming language Scheme. Taurus  generates a recursive descent parser
;from an LL(1) grammar augmented
;with semantic actions written by the user.  The grammar is specified
;in a lisp-like prefix notation.  The generated parser is a Scheme
;language procedure, and it can perform automatic syntactic error
;recovery.  
;
;This documentation was produced with a tool called Scheme\TeX{}, which
;allows mixing of Scheme code and text written using \TeX{} commands.
;The GNU project \LaTeX{}info package was used for formatting the text.
;
;\comment  node-name,  next,  previous,  up
;
;\begin{menu}
;* Distribution::
;* General Public License::
;* Overview::
;* How the Parser Is Generated::
;* The Rest of Taurus::
;* Converting to Internal Representation::
;\end{menu}
;
;\comment  node-name,  next,  previous,  up
;\node Distribution, General Public License, Preface, Top
;\chapter{Distribution}
;\cindex{Distribution}
;
;This software is not being distributed very widely, yet, because it is
;under development. If you want to get a more up-to-date version or are
;otherwise interested in it, the author can be contacted via electronic
;mail as \code{pk@tut.fi}, or via ordinary mail as Pertti Kellomaki,
;Software Systems Lab, Tampere University of Technology, P.O.Box 527,
;SF-33101 Tampere, Finland.
;
;\comment  node-name,  next,  previous,  up
;\node General Public License, Preamble, Distribution, Top
;\chapter{General Public License}
;\cindex{General Public License}
;
;\begin{center}
;		    GNU GENERAL PUBLIC LICENSE
;		     Version 1, February 1989
;
; Copyright (C) 1989 Free Software Foundation, Inc.
;                    675 Mass Ave, Cambridge, MA 02139, USA
; Everyone is permitted to copy and distribute verbatim copies
; of this license document, but changing it is not allowed.
;\end{center}
;
;\comment  node-name,  next,  previous,  up
;\node Preamble, Overview, General Public License, General Public License
;\section{Preamble}
;\cindex{Preamble}
;
;  The license agreements of most software companies try to keep users
;at the mercy of those companies.  By contrast, our General Public
;License is intended to guarantee your freedom to share and change free
;software--to make sure the software is free for all its users.  The
;General Public License applies to the Free Software Foundation's
;software and to any other program whose authors commit to using it.
;You can use it for your programs, too.
;
;  When we speak of free software, we are referring to freedom, not
;price.  Specifically, the General Public License is designed to make
;sure that you have the freedom to give away or sell copies of free
;software, that you receive source code or can get it if you want it,
;that you can change the software or use pieces of it in new free
;programs; and that you know you can do these things.
;
;  To protect your rights, we need to make restrictions that forbid
;anyone to deny you these rights or to ask you to surrender the rights.
;These restrictions translate to certain responsibilities for you if you
;distribute copies of the software, or if you modify it.
;
;  For example, if you distribute copies of a such a program, whether
;gratis or for a fee, you must give the recipients all the rights that
;you have.  You must make sure that they, too, receive or can get the
;source code.  And you must tell them their rights.
;
;  We protect your rights with two steps: (1) copyright the software, 
;and (2) offer you this license which gives you legal permission to copy,
;distribute and/or modify the software.
;
;  Also, for each author's protection and ours, we want to make certain
;that everyone understands that there is no warranty for this free
;software.  If the software is modified by someone else and passed on, we
;want its recipients to know that what they have is not the original, so
;that any problems introduced by others will not reflect on the original
;authors' reputations.
;
;  The precise terms and conditions for copying, distribution and
;modification follow.
;
;\begin{center}
;		    GNU GENERAL PUBLIC LICENSE
;   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
;\end{center}
;
;\begin{enumerate}
;\item
;This License Agreement applies to any program or other work which
;contains a notice placed by the copyright holder saying it may be
;distributed under the terms of this General Public License.  The
;``Program'', below, refers to any such program or work, and a ``work based
;on the Program'' means either the Program or any work containing the
;Program or a portion of it, either verbatim or with modifications.  Each
;licensee is addressed as ``you''.
;
;\item
;You may copy and distribute verbatim copies of the Program's source
;code as you receive it, in any medium, provided that you conspicuously and
;appropriately publish on each copy an appropriate copyright notice and
;disclaimer of warranty; keep intact all the notices that refer to this
;General Public License and to the absence of any warranty; and give any
;other recipients of the Program a copy of this General Public License
;along with the Program.  You may charge a fee for the physical act of
;transferring a copy.
;
;\item
;You may modify your copy or copies of the Program or any portion of
;it, and copy and distribute such modifications under the terms of Paragraph
;1 above, provided that you also do the following:
;
;\begin{description}
;\item{a)}
; cause the modified files to carry prominent notices stating that
;    you changed the files and the date of any change; and
;
;\item{b)}
; cause the whole of any work that you distribute or publish, that
;    in whole or in part contains the Program or any part thereof, either
;    with or without modifications, to be licensed at no charge to all
;    third parties under the terms of this General Public License (except
;    that you may choose to grant warranty protection to some or all
;    third parties, at your option).
;
;\item{c)}
; If the modified program normally reads commands interactively when
;    run, you must cause it, when started running for such interactive use
;    in the simplest and most usual way, to print or display an
;    announcement including an appropriate copyright notice and a notice
;    that there is no warranty (or else, saying that you provide a
;    warranty) and that users may redistribute the program under these
;    conditions, and telling the user how to view a copy of this General
;    Public License.
;
;\item{d)}
; You may charge a fee for the physical act of transferring a
;    copy, and you may at your option offer warranty protection in
;    exchange for a fee.
;\end{description}
;Mere aggregation of another independent work with the Program (or its
;derivative) on a volume of a storage or distribution medium does not bring
;the other work under the scope of these terms.
;
;\item
;You may copy and distribute the Program (or a portion or derivative of
;it, under Paragraph 2) in object code or executable form under the terms of
;Paragraphs 1 and 2 above provided that you also do one of the following:
;
;\begin{description}
;\item{a)}
; accompany it with the complete corresponding machine-readable
;    source code, which must be distributed under the terms of
;    Paragraphs 1 and 2 above; or,
;
;\item{b)}
; accompany it with a written offer, valid for at least three
;    years, to give any third party free (except for a nominal charge
;    for the cost of distribution) a complete machine-readable copy of the
;    corresponding source code, to be distributed under the terms of
;    Paragraphs 1 and 2 above; or,
;
;\item{c)}
; accompany it with the information you received as to where the
;    corresponding source code may be obtained.  (This alternative is
;    allowed only for noncommercial distribution and only if you
;    received the program in object code or executable form alone.)
;\end{description}
;
;Source code for a work means the preferred form of the work for making
;modifications to it.  For an executable file, complete source code means
;all the source code for all modules it contains; but, as a special
;exception, it need not include source code for modules which are standard
;libraries that accompany the operating system on which the executable
;file runs, or for standard header files or definitions files that
;accompany that operating system.
;
;\item
;You may not copy, modify, sublicense, distribute or transfer the
;Program except as expressly provided under this General Public License.
;Any attempt otherwise to copy, modify, sublicense, distribute or transfer
;the Program is void, and will automatically terminate your rights to use
;the Program under this License.  However, parties who have received
;copies, or rights to use copies, from you under this General Public
;License will not have their licenses terminated so long as such parties
;remain in full compliance.
;
;\item
;By copying, distributing or modifying the Program (or any work based
;on the Program) you indicate your acceptance of this license to do so,
;and all its terms and conditions.
;
;\item
;Each time you redistribute the Program (or any work based on the
;Program), the recipient automatically receives a license from the original
;licensor to copy, distribute or modify the Program subject to these
;terms and conditions.  You may not impose any further restrictions on the
;recipients' exercise of the rights granted herein.
;
;\item
;The Free Software Foundation may publish revised and/or new versions
;of the General Public License from time to time.  Such new versions will
;be similar in spirit to the present version, but may differ in detail to
;address new problems or concerns.
;
;Each version is given a distinguishing version number.  If the Program
;specifies a version number of the license which applies to it and "any
;later version", you have the option of following the terms and conditions
;either of that version or of any later version published by the Free
;Software Foundation.  If the Program does not specify a version number of
;the license, you may choose any version ever published by the Free Software
;Foundation.
;
;\item
;If you wish to incorporate parts of the Program into other free
;programs whose distribution conditions are different, write to the author
;to ask for permission.  For software which is copyrighted by the Free
;Software Foundation, write to the Free Software Foundation; we sometimes
;make exceptions for this.  Our decision will be guided by the two goals
;of preserving the free status of all derivatives of our free software and
;of promoting the sharing and reuse of software generally.
;
;
;\item
;
;\begin{center}
;NO WARRANTY
;\end{center}
;
;BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
;FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
;OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
;PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
;OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
;MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
;TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
;PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
;REPAIR OR CORRECTION.
;
;\item
;IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
;WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
;REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
;INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
;OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
;TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
;YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
;PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
;POSSIBILITY OF SUCH DAMAGES.
;
;		     END OF TERMS AND CONDITIONS
;\end{enumerate}
;
;\begin{menu}
;* Overview::
;* How the Parser Is Generated::
;* The Rest of Taurus::
;* Converting to Internal Representation::
;\end{menu}
;
;\comment  node-name,  next,  previous,  up
;\node Overview, How the Parser Is Generated, Preamble, Top
;\chapter{Overview}
;\cindex{Overview}
;
;Digital's Scheme to C compiler \file{scc} requires the module
;form to be the first item in the source file. It is used for
;generating the object file. It also tells the compiler what the main
;procedure is:
;
(module taurus
	(main taurus-main)
	(with tmisc texpr tcodegen tstart tfixed tll1))

;The source code is divided in six files. The files are:
;
;\begin{description}
;\item[taurus.st]
;Contains the main procedure and some
;procedures used in converting the grammar into an internal
;representation. 
;\item[texpr.st]
;Provides the internal data types used by all the other
;modules.
;\item[tcodegen.st]
;Handles the actual generation of the parser.
;\item[tfixed.st]
;Contains some fixed code to be included in the parser.
;\item[tstart.st]
;Procedures for computing lookahead sets for the parser.
;\item[tll1.st]
;Implements LL(1) checking for the grammar. \strong{NIY}.
;\item[tmisc.st]
;Contains some miscellaneous procedures that did not fit into
;any of the above categories.
;\end{description}
;
;\comment  node-name,  next,  previous,  up
;
;\begin{menu}
;* How the Parser Is Generated::
;* The Rest of Taurus::
;* Converting to Internal Representation::
;\end{menu}
;
;\node How the Parser Is Generated, The Rest of Taurus, Overview, Overview
;\section{How the Parser Is Generated}
;\cindex{How the Parser Is Generated}
;
;This section gives an overview of how the grammar is converted to an executable
;parser. The details of each phase are given in later chapters.
;
;First, the grammar is converted to an internal representation. This is
;done using the procedures \code{make-parser} and \code{make-expr}. The
;internal representation is then given to \code{check-ll1}, which checks
;that the grammar satisfies the LL(1) criterion. If the check fails, the
;user is notified. 
;\c ?? During the LL(1) check, the FIRST sets that are used as lookahead
;\c sets for the generated parser are computed. 
;
;After the LL(1) check, the generation of the parser begins. The
;procedure \code{generate-code} takes the internal representation and
;builds the parser. For each construct in the grammar, there is a
;corresponding template, which is filled with data derived from the
;grammar. In addition to this, some fixed routines, local variables etc.
;are included in the generated parser.
;
;The main procedure expects the name of the file containing the grammar
;description to be given as a command line argument. It is then loaded.
;Note that when using Taurus interactively (not from command line) the
;procedure \code{taurus-main} should not be used at all, but
;\code{make-parser} should be called instead.
;
;\findex{taurus-main}
(define (taurus-main clargs)
  (cond ((= (length clargs) 2)
	 (let ((grammar (with-input-from-file
			    (cadr clargs) read)))
	   (pp (apply make-parser (cdr grammar)))
	   (newline)))
	(else
	 (display "Usage: taurus grammar-file" stderr-port)
	 (newline stderr-port))))

;\comment  node-name,  next,  previous,  up
;\node The Rest of Taurus, Converting to Internal Representation, How the Parser Is Generated, Overview
;\section{The Rest of Taurus}
;\cindex{The Rest of Taurus}
;
;The rest of the generator resides in the following files. If Taurus is
;loaded by the Scheme procedure \code{load}, the rest of the files are
;also loaded.  When taurus is compiled,
;the modules are first compiled separately and then combined.
;
;\strong{This does not work!} when the compiled generator is run, it
;barfs at this. Right now the \code{quote} fixes it, but it is really
;not a satisfactory solution...
;
(quote (eval-when (load)
		  (load "tstart.st")
		  (load "tmisc.st")
		  (load "texpr.st")
		  (load "tcodegen.st")
		  (load "tfixed.st")
		  (load "tll1.st")
		  ))

;\comment  node-name,  next,  previous,  up
;\node Converting to Internal Representation, Converting the Grammar, The Rest of Taurus, Overview
;\section{Converting to Internal Representation}
;\cindex{Converting to Internal Representation}
;
;The main procedure constructs the internal representation of the
;parser specification and calls the LL(1) checker and code generator.
;If you do not want to quote the terminal lists and the rules, you can
;make \code{make-parser} a macro. This would have already been done, if
;a standard macro facility existed for Scheme.
;
;\findex{make-parser}
(define (make-parser token-classes syntactic-sugar . rules)
  (init-first-sets)
  ;(newline stderr-port)
  ;(display ";Reading input" stderr-port)
  ;(newline stderr-port)
  (let ((grammar (convert-rules (append token-classes
					syntactic-sugar)
				rules)))
    ;(display ";Checking LL(1) property" stderr-port)
    ;(newline stderr-port)
    (check-ll1 grammar)
    ;(display ";Generating code" stderr-port)
    ;(newline stderr-port)
    (generate-code grammar syntactic-sugar)))

;Only two procedures, \code{make-parser} and \code{make-expr} know about
;the external representation of the grammar. All the other parts of
;Taurus work with the internal data types. The detailed syntax of the
;external representation is given in the User's Manual (which is yet to
;be written!)
;
;\comment  node-name,  next,  previous,  up
;\node Converting the Grammar, Converting Expressions to Taurus Representation, Converting to Internal Representation, Converting to Internal Representation
;\subsection{Converting the Grammar}
;\cindex{Converting the Grammar}
;
;Nonterminals are extracted from the list representation of rules by
;mapping \code{car} over \code{rules}. If the rule does not include a
;list \code{(error-value }\var{scheme-form}\code{)} as the second element,
;the default value \code{(quote undefined)} is passed to
;\code{make-rule}. Also, the implicit \code{seq} is prepended to the
;body of the rule.
;
;\findex{convert-rules}
(define (convert-rules terminals rules)
  (let ((nonterminals (map (lambda (rule) (car rule))
			   rules)))
    (map (lambda (rule)
	   (if (and (pair? (cadr rule))
		    (eq? 'error-value (caadr rule)))
	       (make-rule (make-nonterminal (car rule))
			  (cadadr rule)
			  (make-expr (cons 'seq (cddr rule) )
				     terminals nonterminals))
	       (make-rule (make-nonterminal (car rule))
			  '(quote undefined)
			  (make-expr (cons 'seq (cdr rule) )
				     terminals nonterminals))))
	 rules)))

;\comment  node-name,  next,  previous,  up
;\node Converting Expressions to Taurus Representation, Concept Index, Converting the Grammar, Converting to Internal Representation
;\subsection{Converting Expressions to Taurus Representation}
;\cindex{Converting Expressions to Taurus Representation}
;
;Expressions given in Taurus notation are converted to the internal
;representation using the procedure \code{make-expr}. It takes an
;expression \code{expr} and two lists: \code{terminals} and
;\code{nonterminals} and returns an expression that is constructed
;using the constructors defined for the internal data types
;{}(\pxref{Internal Data Types} for description of them.)
;
;If \code{expr} is not a pair, it is searched for in \code{terminals} and
;\code{nonterminals}. If it is not found, the special symbol \code{empty}
;is also checked. Then, if it is a symbol and its print name starts
;with a dollar sign, it is assumed to be a semantic action consisting
;solely of returning the semantic value of some other constituent.
;If all that fails, it is assumed to be a terminal
;symbol that the user forgot to give in \code{terminals}.
;
;If \code{expr} is a pair, its \code{car} part is checked for the key
;words \code{seq}, \code{alt}, \code{iter+} and \code{iter*}. If one of
;these is found, \code{make-expr} is mapped over the rest of the list and
;the corresponding constructor is called with the result. Otherwise, the
;pair is assumed to be a semantic action.
;
;\findex{make-expr}
(define (make-expr expr terminals nonterminals)
  (cond
   ((not (pair? expr))
    (cond ((member expr terminals)
	   (make-terminal expr))
	  ((member expr nonterminals)
	   (make-nonterminal expr))
	  ((equal? expr 'empty)
	   (make-empty))
	  ((and (symbol? expr)
		(char=? #\$
			(car (string->list (symbol->string expr)))))
	   (make-action expr))
	  (else
	   (display
	    ";input symbol not terminal or nonterminal " stderr-port)
	   (display expr stderr-port)
	   (newline stderr-port)
	   (display ";assuming it is a terminal symbol" stderr-port)
	   (newline stderr-port)
	   (make-terminal expr))))
   (else
    (case (car expr)
      ((seq)
       (make-sequence
	(map (lambda (constituent)
	       (make-expr constituent
			  terminals
			  nonterminals))
	     (cdr expr))))
      ((alt)
       (make-alternative
	(map (lambda (constituent)
	       (make-expr constituent
			  terminals
			  nonterminals))
	     (cdr expr))))
      ((iter+)
       (make-nonzero-iteration
	(make-expr (cons 'seq (cdr expr))
		   terminals
		   nonterminals)))
      ((iter*)
       (make-zero-iteration
	(make-expr (cons 'seq (cdr expr))
		   terminals
		   nonterminals)))
      (else
       (make-action expr))))))



;\input{texpr}
;\input{tcodegen}
;\input{tfixed}
;\input{tstart}
;\input{tll1}
;\input{tmisc}
;
;\comment  node-name,  next,  previous,  up
;\node Concept Index, Procedure Index, Converting Expressions to Taurus Representation, Top
;\chapter*{Concept Index}
;\cindex{Concept Index}
;\printindex{cp}
;
;\comment  node-name,  next,  previous,  up
;\node Procedure Index, Top, Concept Index, Top
;\chapter*{Procedure Index}
;\cindex{Procedure Index}
;\printindex{fn}
;
;\end{document}
