
;;; make-module macro

(define-macro (make-module . bindings)
  (let loop ((bindings bindings) (names '()) (exps '()))
    (if (null? bindings)
	`(lambda (self)
	   (make-record
	    ,@(map (lambda (name exp)
		     `(make-binding
		      ,name
		      (make-new-entry 
		       self 
		       (lambda (env) (in-package env ,exp)))))
		   names exps)))
	(loop (cddr bindings)
	      (cons (car bindings) names)
	      (cons (cadr bindings) exps)))))

