;;; JACAL: Symbolic Mathematics System.        -*-scheme-*-
;;; Copyright 1989, 1990, 1991, 1992, 1993 Aubrey Jaffer.

(require 'defmacro)
(define debug:indent 0)

(define (math:printn x) (math:print x) (newline-diag))

(define (print . args)
  (define result #f)
  (for-each (lambda (x) (set! result x) (math:print x)
		    (display-diag #\ ))
	    args)
  (newline-diag)
  result)

(define (mtracef function . optname)
    (set! debug:indent 0)
    (let ((name (if (null? optname) function (car optname))))
      (lambda args
	(cond ((and (not (null? args))
		    (eq? (car args) 'debug:untrace-object)
		    (null? (cdr args)))
	       function)
	      (else
	       (do ((i debug:indent (+ -1 i))) ((zero? i)) (display "  "))
	       (display "CALLED ") (display name) (newline)
	       (for-each math:printn args)
	       (set! debug:indent (modulo (+ 1 debug:indent) 8))
	       (let ((ans (apply function args)))
		 (set! debug:indent (modulo (+ -1 debug:indent) 8))
		 (do ((i debug:indent (+ -1 i))) ((zero? i)) (display "  "))
		 (display "RETURNED ") (display name) (newline)
		 (math:printn ans)
		 ans))))))

(define (muntracef function)
  (set! debug:indent 0)
  (function 'debug:untrace-object))

(define *traced-procedures* '())
(define (mtrace:tracef fun sym)
  (cond ((memq sym *traced-procedures*)
	 (display "WARNING: already traced " (current-error-port))
	 (display sym (current-error-port))
	 (newline (current-error-port))
	 fun)
	(else
	 (set! *traced-procedures* (cons sym *traced-procedures*))
	 (mtracef fun sym))))
(define (mtrace:untracef fun sym)
  (require 'common-list-functions)
  (cond ((memq sym *traced-procedures*)
	 (set! *traced-procedures* (remove sym *traced-procedures*))
	 (muntracef fun))
	(else
	 (display "WARNING: not traced " (current-error-port))
	 (display sym (current-error-port))
	 (newline (current-error-port))
	 fun)))

;;; Macros.

(defmacro:eval
  '(defmacro mtrace x
     (if (null? x) '*traced-procedures*
	 `(begin ,@(map (lambda (x) `(set! ,x (mtrace:tracef ,x ',x))) x)))))
(defmacro:eval
  '(defmacro muntrace x
     (if (null? x)
	 (slib:eval
	  `(begin ,@(map (lambda (x) `(set! ,x (mtrace:untracef ,x ',x)))
			 *traced-procedures*)
		  '',*traced-procedures*))
	 `(begin ,@(map (lambda (x) `(set! ,x (mtrace:untracef ,x ',x))) x)))))

(defmacro:eval
  '(defmacro trace x
     (if (null? x) '*traced-procedures*
	 `(begin ,@(map (lambda (x) `(set! ,x (mtrace:tracef ,x ',x))) x)))))
(defmacro:eval
  '(defmacro untrace x
     (if (null? x)
	 (slib:eval
	  `(begin ,@(map (lambda (x) `(set! ,x (mtrace:untracef ,x ',x)))
			 *traced-procedures*)
		  '',*traced-procedures*))
	 `(begin ,@(map (lambda (x) `(set! ,x (mtrace:untracef ,x ',x))) x)))))
